package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActivitySupplierPoolPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivitySupplierPoolMapper
 * @Description: ActivitySupplierPoolMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:43:59
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivitySupplierPoolMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivitySupplierPoolPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    List<ActivitySupplierPoolPO> selectByCondition(ActivitySupplierPoolPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int delete(ActivitySupplierPoolPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int insert(ActivitySupplierPoolPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int allInsert(List<ActivitySupplierPoolPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int update(ActivitySupplierPoolPO record);

    /**
     * 可选供应商批量查询
     * @param ids
     * @return
     */
    List<ActivitySupplierPoolPO> queryActivityUnselectSupplierPageList(@Param("list")List<Long> list);
}
