package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActivityUserScoresUseRecordPO;
import com.tydic.dyc.act.repository.po.ActivityUserScoresUseRecordTimePO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivityUserScoresUseRecordMapper
 * @Description: ActivityUserScoresUseRecordMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:43:58
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityUserScoresUseRecordMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityUserScoresUseRecordPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:43:58
     */
    List<ActivityUserScoresUseRecordPO> selectByCondition(ActivityUserScoresUseRecordPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:58
     */
    int delete(ActivityUserScoresUseRecordPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:58
     */
    int insert(ActivityUserScoresUseRecordPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:58
     */
    int allInsert(List<ActivityUserScoresUseRecordPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:58
     */
    int update(ActivityUserScoresUseRecordPO record);

    /**
     * 活动用户积分流水查询（分页）服务
     * @param activityUserScoresUseRecordTimePO
     * @return
     */
    List<ActivityUserScoresUseRecordPO> queryActivityUserScoresUseRecordPageList(ActivityUserScoresUseRecordTimePO activityUserScoresUseRecordTimePO);
}
