package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActActivityChangeCommodityRepository;
import com.tydic.dyc.act.repository.dao.ActSkuInfoMapper;
import com.tydic.dyc.act.repository.dao.ActivityChangeRelaCommodityCatalogMapper;
import com.tydic.dyc.act.repository.dao.ActivityChangeRelaCommodityMapper;
import com.tydic.dyc.act.repository.dao.ActivityChangeRelaCommodityPoolMapper;
import com.tydic.dyc.act.repository.po.*;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 说明：〈活动商品变更基建方法〉实现
 *
 * @author zhoulu
 * @date 2023年12月22日 14:26
 */
@Service
public class DycActActivityChangeCommodityRepositoryImpl implements DycActActivityChangeCommodityRepository {
    @Autowired
    private ActivityChangeRelaCommodityCatalogMapper activityChangeRelaCommodityCatalogMapper;
    @Autowired
    private ActivityChangeRelaCommodityPoolMapper activityChangeRelaCommodityPoolMapper;

    @Autowired
    private ActivityChangeRelaCommodityMapper activityChangeRelaCommodityMapper;

    @Autowired
    private ActSkuInfoMapper actSkuInfoMapper;

    @Override
    public BasePageRspBo<DycActivityChangeRelaCommodityCatalogInfo> queryActivityChangeSelectedCommodityCatalogPageList(DycActivityChangeDO reqBo) {
        BasePageRspBo<DycActivityChangeRelaCommodityCatalogInfo> rspBo = new BasePageRspBo<>();
        ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPo = JSON.parseObject(JSON.toJSONString(reqBo), ActivityChangeRelaCommodityCatalogPO.class);
        Page<ActivityChangeRelaCommodityCatalogPO> page = PageHelper.startPage(reqBo.getPageNo(), reqBo.getPageSize()).doSelectPage(() -> this.activityChangeRelaCommodityCatalogMapper.selectByCondition(activityChangeRelaCommodityCatalogPo));
        if (ObjectUtils.isEmpty(page)) {
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        List<DycActivityChangeRelaCommodityCatalogInfo> rows = JSON.parseArray(JSON.toJSONString(page.getResult()), DycActivityChangeRelaCommodityCatalogInfo.class);
        List<Long> threeCatalogIds = rows.stream().map(DycActivityChangeRelaCommodityCatalogInfo::getThreeCatalogId).filter(StringUtils::isNotBlank).map(Convert::toLong).distinct().collect(Collectors.toList());
        //根据三级类目，查询商品数量
        Map<Long, List<ActSkuInfoPO>> guideIdMap = new HashMap<>(16);
        if(!CollectionUtils.isEmpty(threeCatalogIds)){
            ActSkuInfoPO qryActSkuInfoPo = new ActSkuInfoPO();
            qryActSkuInfoPo.setGuideIds(threeCatalogIds);
            qryActSkuInfoPo.setAgreementPriceMin(reqBo.getAgreementPriceMin());
            qryActSkuInfoPo.setAgreementPriceMax(reqBo.getAgreementPriceMax());
            List<ActSkuInfoPO> actSkuInfoPos = actSkuInfoMapper.selectSkuCountByCondition(qryActSkuInfoPo);
            if(!CollectionUtils.isEmpty(actSkuInfoPos)){
                guideIdMap = actSkuInfoPos.stream().collect(Collectors.groupingBy(ActSkuInfoPO::getGuideId));
            }
        }
        for (DycActivityChangeRelaCommodityCatalogInfo row : rows) {
            row.setTotalCommodity(0);
            if(StringUtils.isBlank(row.getThreeCatalogId())){
                continue;
            }
            if(!MapUtil.isEmpty(guideIdMap)){
                List<ActSkuInfoPO> actSkuInfoPos = guideIdMap.get(Long.parseLong(row.getThreeCatalogId()));
                if(!CollectionUtils.isEmpty(actSkuInfoPos)){
                    row.setTotalCommodity(actSkuInfoPos.get(0).getSkuCount());
                }
            }
        }
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(rows);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public BasePageRspBo<DycActivityChangeRelaCommodityPoolInfo> queryActivityChangeCommodityPoolPageList(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        ActivityChangeRelaCommodityPoolPO selectActivityChangeRelaCommodityPoolPO = new ActivityChangeRelaCommodityPoolPO();
        BeanUtils.copyProperties(reqBO, selectActivityChangeRelaCommodityPoolPO);
        Page<ActivityChangeRelaCommodityPoolPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityChangeRelaCommodityPoolMapper.selectByCondition(selectActivityChangeRelaCommodityPoolPO));

        //封装集合
        List<DycActivityChangeRelaCommodityPoolInfo> activityChangeRelaCommodityPoolBOList = new ArrayList<>();
        for (ActivityChangeRelaCommodityPoolPO activityChangeRelaCommodityPoolPO : page.getResult()) {
            DycActivityChangeRelaCommodityPoolInfo activityChangeRelaCommodityPoolBO = new DycActivityChangeRelaCommodityPoolInfo();
            BeanUtils.copyProperties(activityChangeRelaCommodityPoolPO, activityChangeRelaCommodityPoolBO);
            activityChangeRelaCommodityPoolBOList.add(activityChangeRelaCommodityPoolBO);
        }

        BasePageRspBo<DycActivityChangeRelaCommodityPoolInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityChangeRelaCommodityPoolBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspPage;
    }

    @Override
    public DycActivityChangeRelaCommodityPoolInfo batchSelectActivityChangeCommodityPool(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getChangeId()) {
            throw new ZTBusinessException("入参不能为空或者变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityPoolList())) {
            throw new ZTBusinessException("商品池列表不能为空！");
        }
        List<ActivityChangeRelaCommodityPoolPO> commodityPoolPOS = JSON.parseArray(JSON.toJSONString(reqBO.getCommodityPoolList()), ActivityChangeRelaCommodityPoolPO.class);
        commodityPoolPOS.forEach(item -> {
            item.setRelaId(Sequence.getInstance().nextId());
            item.setChangeId(reqBO.getChangeId());
            item.setDelFlag(0);
            item.setCreateTime(new Date());
            item.setCreateUserId(reqBO.getCreateUserId());
            item.setCreateUserName(reqBO.getCreateUserName());
            item.setUpdateTime(null);
            item.setUpdateUserId(null);
            item.setUpdateUserName(null);
        });

        int i = activityChangeRelaCommodityPoolMapper.allInsert(commodityPoolPOS);
        if (reqBO.getCommodityPoolList().size() != i) {
            throw new ZTBusinessException("活动变更商品池选择（批量）服务失败！");
        }
        return new DycActivityChangeRelaCommodityPoolInfo();
    }

    @Override
    public DycActivityChangeRelaCommodityPoolInfo batchRemoveActivityChangeCommodityPool(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getChangeId()) {
            throw new ZTBusinessException("入参不能为空或者变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityPoolIdList())) {
            throw new ZTBusinessException("商品池Id列表不能为空！");
        }
        ActivityChangeRelaCommodityPoolPO commodityPoolPO = new ActivityChangeRelaCommodityPoolPO();
        commodityPoolPO.setChangeId(reqBO.getChangeId());
        commodityPoolPO.setUpdateTime(new Date());
        commodityPoolPO.setUpdateUserId(reqBO.getUpdateUserId());
        commodityPoolPO.setUpdateUserName(reqBO.getUpdateUserName());
        int i = activityChangeRelaCommodityPoolMapper.updateBatchById(reqBO.getCommodityPoolIdList(), commodityPoolPO);
        if (i != reqBO.getCommodityPoolIdList().size()) {
            throw new ZTBusinessException("活动变更商品池移除（批量）服务失败！");
        }
        return new DycActivityChangeRelaCommodityPoolInfo();
    }

    @Override
    public int batchSelectActivityChangeCommodity(DycActivityChangeDO reqBo) {
        if (ObjectUtils.isEmpty(reqBo) || null == reqBo.getChangeId()) {
            throw new ZTBusinessException("入参不能为空或者变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBo.getCommodityList())) {
            throw new ZTBusinessException("商品列表不能为空！");
        }
        List<ActivityChangeRelaCommodityPO> commodityPoList = JSON.parseArray(JSON.toJSONString(reqBo.getCommodityList()), ActivityChangeRelaCommodityPO.class);
        commodityPoList.forEach(item -> {
            item.setRelaId(Sequence.getInstance().nextId());
            item.setChangeId(reqBo.getChangeId());
            item.setDelFlag(0);
            item.setCreateTime(new Date());
            if(item.getFavorableRate() != null){
                BigDecimal bigDecimal = BigDecimal.valueOf(item.getFavorableRate());
                item.setFavorableRate(bigDecimal.setScale(2, RoundingMode.HALF_UP).doubleValue());
            }
            item.setCreateUserId(reqBo.getCreateUserId());
            item.setCreateUserName(reqBo.getCreateUserName());
            item.setUpdateTime(null);
            item.setUpdateUserId(null);
            item.setUpdateUserName(null);
        });
        int i = activityChangeRelaCommodityMapper.allInsert(commodityPoList);
        if (reqBo.getCommodityList().size() != i) {
            throw new ZTBusinessException("活动变更商品选择（批量）服务失败！");
        }
        return i;
    }

    @Override
    public int batchSelectActivityChangeCommodityCatalog(DycActivityChangeDO reqBo) {
        if (ObjectUtils.isEmpty(reqBo) || null == reqBo.getChangeId()) {
            throw new ZTBusinessException("入参不能为空或者变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBo.getCommodityCatalogList())) {
            throw new ZTBusinessException("商品类型列表不能为空！");
        }
        List<ActivityChangeRelaCommodityCatalogPO> commodityPoList = JSON.parseArray(JSON.toJSONString(reqBo.getCommodityCatalogList()), ActivityChangeRelaCommodityCatalogPO.class);
        commodityPoList.forEach(item -> {
            item.setRelaId(Sequence.getInstance().nextId());
            item.setChangeId(reqBo.getChangeId());
            item.setDelFlag(0);
            item.setCreateTime(new Date());
            item.setCreateUserId(reqBo.getCreateUserId());
            item.setCreateUserName(reqBo.getCreateUserName());
            item.setUpdateTime(null);
            item.setUpdateUserId(null);
            item.setUpdateUserName(null);
        });

        int i = activityChangeRelaCommodityCatalogMapper.allInsert(commodityPoList);
        if (reqBo.getCommodityCatalogList().size() != i) {
            throw new ZTBusinessException("活动变更商品类型选择（批量）服务失败！");
        }
        return i;
    }

    @Override
    public int batchRemoveActivityChangeCommodityCatalog(DycActivityChangeDO reqBO) {
        List<ActivityChangeRelaCommodityCatalogPO> list = new ArrayList<>();
        for (Long aLong : reqBO.getRelaIdList()) {
            ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPo = new ActivityChangeRelaCommodityCatalogPO();
            activityChangeRelaCommodityCatalogPo.setChangeId(reqBO.getChangeId());
            activityChangeRelaCommodityCatalogPo.setUpdateTime(new Date());
            activityChangeRelaCommodityCatalogPo.setUpdateUserId(reqBO.getUpdateUserId());
            activityChangeRelaCommodityCatalogPo.setUpdateUserName(reqBO.getUpdateUserName());
            activityChangeRelaCommodityCatalogPo.setRelaId(aLong);
            list.add(activityChangeRelaCommodityCatalogPo);
        }
        return activityChangeRelaCommodityCatalogMapper.batchRemoveActivityChangeCommodityCatalog(list);
    }

    @Override
    public BasePageRspBo<ActivityChangeRelaCommodityInfo> queryActivityChangeCommodityPageList(ActActivityChangeCommodityInfoQryDO qryDo) {
        BasePageRspBo<ActivityChangeRelaCommodityInfo> rspBo = new BasePageRspBo<>();
        ActActivityChangeCommodityInfoQryPO qryPo = JSON.parseObject(JSON.toJSONString(qryDo), ActActivityChangeCommodityInfoQryPO.class);
        Page<ActActivityChangeCommodityInfoPO> page = PageHelper.startPage(qryDo.getPageNo(), qryDo.getPageSize()).doSelectPage(() -> this.activityChangeRelaCommodityMapper.selectByCondition(qryPo));
        if (ObjectUtils.isEmpty(page)) {
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        List<ActivityChangeRelaCommodityInfo> rows = JSON.parseArray(JSON.toJSONString(page.getResult()), ActivityChangeRelaCommodityInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(rows);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        if(!CollectionUtils.isEmpty(rspBo.getRows())){
            for (ActivityChangeRelaCommodityInfo info:rspBo.getRows()){
                info.setCatalogNameStr(info.getFirstCatalogName()+">"+info.getSecondCatalogName()+">"+info.getThreeCatalogName());
                if(info.getFavorableRate() != null){
                    if(info.getFavorableRate()%info.getFavorableRate().intValue() == 0){
                        info.setFavorableRateStr(info.getFavorableRate().intValue() +"%");
                    }else {
                        info.setFavorableRateStr(info.getFavorableRate() +"%");
                    }
                }else {
                    info.setFavorableRateStr("-");
                }
            }
        }
        return rspBo;
    }

    @Override
    public int batchRemoveActivityChangeCommodity(DycActivityChangeDO reqBO) {
        List<ActivityChangeRelaCommodityPO> list = new ArrayList<>();
        for (Long aLong : reqBO.getSkuIdList()) {
            ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo = new ActivityChangeRelaCommodityPO();
            activityChangeRelaCommodityPo.setChangeId(reqBO.getChangeId());
            activityChangeRelaCommodityPo.setUpdateTime(new Date());
            activityChangeRelaCommodityPo.setUpdateUserId(reqBO.getUpdateUserId());
            activityChangeRelaCommodityPo.setUpdateUserName(reqBO.getUpdateUserName());
            activityChangeRelaCommodityPo.setSkuId(aLong);
            list.add(activityChangeRelaCommodityPo);
        }
        return activityChangeRelaCommodityMapper.batchRemoveActivityChangeCommodity(list);
    }

    /**
     * 活动变更已选商品列表
     * @param reqBO
     * @return
     */
    @Override
    public List<ActivityChangeRelaCommodityInfo> getList(ActivityChangeRelaCommodityInfo reqBO) {
        ActActivityChangeCommodityInfoQryPO qryPO = ActRu.js(reqBO,ActActivityChangeCommodityInfoQryPO.class);
        List<ActivityChangeRelaCommodityPO> activityChangeRelaCommodityPOS = activityChangeRelaCommodityMapper.selectByCondition(qryPO);
        return ActRu.jsl(activityChangeRelaCommodityPOS,ActivityChangeRelaCommodityInfo.class);
    }

    @Override
    public void update(ActivityChangeRelaCommodityInfo reqBO) {
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPO = ActRu.js(reqBO,ActivityChangeRelaCommodityPO.class);
        activityChangeRelaCommodityMapper.update(activityChangeRelaCommodityPO);
    }

    @Override
    public List<DycActivityChangeRelaCommodityCatalogInfo> getListCatalog(DycActivityChangeDO reqBo) {
        ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPo = new ActivityChangeRelaCommodityCatalogPO();
        activityChangeRelaCommodityCatalogPo.setChangeId(reqBo.getChangeId());
        List<ActivityChangeRelaCommodityCatalogPO> activityChangeRelaCommodityCatalogPoList = activityChangeRelaCommodityCatalogMapper.selectByCondition(activityChangeRelaCommodityCatalogPo);
        return JSONObject.parseArray(JSONObject.toJSONString(activityChangeRelaCommodityCatalogPoList),DycActivityChangeRelaCommodityCatalogInfo.class);
    }

    @Override
    public int insertNew(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityPO.class);
        return activityChangeRelaCommodityMapper.insertNew(activityChangeRelaCommodityPo);
    }

    @Override
    public int updateByNew(DycActivityChangeRelaCommodityInfo set, DycActivityChangeRelaCommodityInfo where) {
        ActivityChangeRelaCommodityPO setPo = JSONObject.parseObject(JSONObject.toJSONString(set), ActivityChangeRelaCommodityPO.class);
        ActivityChangeRelaCommodityPO wherePo = JSONObject.parseObject(JSONObject.toJSONString(where), ActivityChangeRelaCommodityPO.class);
        return activityChangeRelaCommodityMapper.updateBy(setPo,wherePo);
    }

    @Override
    public int getCheckByNew(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityPO.class);
        return activityChangeRelaCommodityMapper.getCheckBy(activityChangeRelaCommodityPo);
    }

    @Override
    public DycActivityChangeRelaCommodityInfo getModelByNew(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityPO.class);
        ActivityChangeRelaCommodityPO modelBy = activityChangeRelaCommodityMapper.getModelBy(activityChangeRelaCommodityPo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy),DycActivityChangeRelaCommodityInfo.class);
    }

    @Override
    public List<DycActivityChangeRelaCommodityInfo> getListNew(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityPO.class);
        List<ActivityChangeRelaCommodityPO> list = activityChangeRelaCommodityMapper.getList(activityChangeRelaCommodityPo);
        return JSONObject.parseArray(JSONObject.toJSONString(list),DycActivityChangeRelaCommodityInfo.class);
    }

    @Override
    public void insertBatchNew(List<DycActivityChangeRelaCommodityInfo> list) {
        List<ActivityChangeRelaCommodityPO> listPo = JSONObject.parseArray(JSONObject.toJSONString(list), ActivityChangeRelaCommodityPO.class);
        activityChangeRelaCommodityMapper.insertBatch(listPo);
    }
}
