package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActActivityRepository;
import com.tydic.dyc.act.repository.dao.ActivityBaseInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoPO;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoTimePO;
import com.tydic.dyc.act.repository.po.DycActActivityApproveBaseInfoPO;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈活动实体基建方法实现〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:33
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Slf4j
@Service
public class DycActActivityRepositoryImpl implements DycActActivityRepository {

    @Autowired
    private ActivityBaseInfoMapper activityBaseInfoMapper;

    /**
     * 根据条件查询活动基本信息列表（分页）
     *
     * @param reqBO
     * @return
     */
    @Override
    public BasePageRspBo<DycActivityBaseInfo> queryActivityPageList(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPO = new ActivityBaseInfoPO();
        BasePageRspBo<DycActivityBaseInfo> rspPage = new BasePageRspBo<>();
        BeanUtils.copyProperties(reqBO, selectActivityBaseInfoPO);
        Page<ActivityBaseInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityBaseInfoMapper.selectByTabId(selectActivityBaseInfoPO));

        if (ObjectUtils.isEmpty(page)) {
            rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspPage;
        }
        //封装集合
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<DycActivityBaseInfo> activityBaseInfoBOList = new ArrayList<>();
        for (ActivityBaseInfoPO activityBaseInfoPO : page.getResult()) {
            DycActivityBaseInfo activityBaseInfoBO = new DycActivityBaseInfo();
            BeanUtils.copyProperties(activityBaseInfoPO, activityBaseInfoBO);
            activityBaseInfoBO.setInvoiceClassStr(DycActivityTransFieldUtil.InvoiceClass(String.valueOf(activityBaseInfoBO.getInvoiceClass())));
            activityBaseInfoBO.setInvoiceTypeStr(DycActivityTransFieldUtil.ActivityType(String.valueOf(activityBaseInfoBO.getInvoiceType())));
            activityBaseInfoBO.setActivityTypeStr(DycActivityTransFieldUtil.ActivityType(String.valueOf(activityBaseInfoBO.getActivityType())));
            activityBaseInfoBO.setActivityPayModeStr(DycActivityTransFieldUtil.ActivityPayMode(String.valueOf(activityBaseInfoBO.getActivityPayMode())));
            activityBaseInfoBO.setActivityStateStr(DycActivityTransFieldUtil.ActivityState(activityBaseInfoBO.getActivityState()));
            activityBaseInfoBO.setCommodityRelaMethodStr(DycActivityTransFieldUtil.CommodityRelaMethodSTR(String.valueOf(activityBaseInfoBO.getCommodityRelaMethod())));
            String startTime = sdf.format(activityBaseInfoPO.getActivityStartTime());
            String endTime = sdf.format(activityBaseInfoPO.getActivityEndTime());
            activityBaseInfoBO.setActivityStartToEndTime(startTime + "-" + endTime);
            activityBaseInfoBO.setActivitySyncStateStr(DycActivityTransFieldUtil.ActivitySyncState(String.valueOf(activityBaseInfoPO.getActivitySyncState())));
            activityBaseInfoBOList.add(activityBaseInfoBO);
        }

        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityBaseInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspPage;
    }

    @Override
    public List<DycActivityBaseInfo> queryActivityList(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPo = new ActivityBaseInfoPO();
        BeanUtils.copyProperties(reqBO, selectActivityBaseInfoPo);
        List<ActivityBaseInfoPO> activityBaseInfoPoList = activityBaseInfoMapper.selectByCondition(selectActivityBaseInfoPo);
        //封装集合
        List<DycActivityBaseInfo> activityBaseInfoBOList = new ArrayList<>();
        if (CollectionUtils.isEmpty(activityBaseInfoPoList)) {
            return new ArrayList<>();
        }
        for (ActivityBaseInfoPO activityBaseInfoPo : activityBaseInfoPoList) {
            DycActivityBaseInfo activityBaseInfoBo = new DycActivityBaseInfo();
            BeanUtils.copyProperties(activityBaseInfoPo, activityBaseInfoBo);
            activityBaseInfoBo.setActivityStateStr(DycActivityTransFieldUtil.ActivityState(activityBaseInfoPo.getActivityState()));
            activityBaseInfoBo.setActivityTypeStr(DycActivityTransFieldUtil.ActivityType(String.valueOf(activityBaseInfoPo.getActivityType())));
            activityBaseInfoBo.setActivityPayModeStr(DycActivityTransFieldUtil.ActivityPayMode(String.valueOf(activityBaseInfoPo.getActivityPayMode())));
            activityBaseInfoBo.setCommodityRelaMethodStr(DycActivityTransFieldUtil.CommodityRelaMethodSTR(String.valueOf(activityBaseInfoPo.getCommodityRelaMethod())));
            activityBaseInfoBOList.add(activityBaseInfoBo);
        }
        return activityBaseInfoBOList;
    }


    /**
     * 描述:活动基本详情保存
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityBaseInfo
     */
    @Override
    public DycActivityBaseInfo saveActiveBaseInfo(DycActiveBaseInfoSaveReqBO reqBO) {
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        if (null == reqBO.getActivityId()) {
            //新增
            ActivityBaseInfoPO insertBO = new ActivityBaseInfoPO();
            BeanUtils.copyProperties(reqBO, insertBO);

            insertBO.setActivityId(Sequence.getInstance().nextId());
            insertBO.setActivityVersion(1);
            insertBO.setActivityState("1");
            insertBO.setDelFlag(0);
            insertBO.setCreateTime(new Date());

            activityBaseInfoMapper.insert(insertBO);
            rspBO.setActivityId(insertBO.getActivityId());
        } else {
            //修改
            ActivityBaseInfoPO baseInfoPO = new ActivityBaseInfoPO();
            BeanUtils.copyProperties(reqBO, baseInfoPO);
            activityBaseInfoMapper.update(baseInfoPO);
        }
        return rspBO;
    }

    @Override
    public int changeActivityState(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (StringUtils.isEmpty(reqBO.getActivityState())) {
            throw new ZTBusinessException("活动状态不能为空！");
        }
        ActivityBaseInfoPO activityBaseInfoPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityBaseInfoPO.class);
        activityBaseInfoPO.setUpdateTime(new Date());
        return activityBaseInfoMapper.update(activityBaseInfoPO);
    }

    @Override
    public int deleteActivity(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        ActivityBaseInfoPO infoPO = new ActivityBaseInfoPO();
        infoPO.setActivityId(reqBO.getActivityId());
        List<ActivityBaseInfoPO> infoPOS = activityBaseInfoMapper.selectByCondition(infoPO);
        if (!DycActivityConstants.ActivityState.ACTIVITY_STATE_ONE.equals(infoPOS.get(0).getActivityState())
                && !DycActivityConstants.ActivityState.ACTIVITY_STATE_THREE.equals(infoPOS.get(0).getActivityState())) {
            throw new ZTBusinessException("当前活动状态不允许删除！");
        }

        ActivityBaseInfoPO activityBaseInfoPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityBaseInfoPO.class);
        activityBaseInfoPO.setUpdateTime(new Date());
        return activityBaseInfoMapper.deleteActivity(activityBaseInfoPO);
    }

    @Override
    public int autoEffectActivity(DycActivityDO reqBO) {
        ActivityBaseInfoPO activityBaseInfoPO = new ActivityBaseInfoPO();
        List<ActivityBaseInfoPO> list = activityBaseInfoMapper.selectAutoEffectActivity(activityBaseInfoPO);
        if (list.size() < 1) {
            return 0;
        }
        for (ActivityBaseInfoPO baseInfoPO : list) {
            baseInfoPO.setUpdateTime(new Date());
            baseInfoPO.setActivityState("5");
        }
        return activityBaseInfoMapper.batchUpdate(list);
    }

    @Override
    public DycActivityBaseInfo autoLoseEffectActivity(DycActivityDO reqBO) {
        List<ActivityBaseInfoPO> activityBaseInfoPOS = activityBaseInfoMapper.autoLoseEffectActivity();
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        if (CollectionUtils.isEmpty(activityBaseInfoPOS)) {
            return rspBO;
        }
        activityBaseInfoPOS.forEach(item -> {
            item.setActivityState(String.valueOf(7));
            item.setUpdateTime(new Date());
        });
        activityBaseInfoMapper.batchUpdate(activityBaseInfoPOS);
        return rspBO;
    }

    @Override
    public BasePageRspBo<DycActActivityApproveBaseInfo> queryActivityApprovePageList(DycProcessDO reqBO) {
        BasePageRspBo<DycActActivityApproveBaseInfo> rspBo = new BasePageRspBo<>();
        ActivityBaseInfoTimePO activityBaseInfoTimePO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityBaseInfoTimePO.class);
        List<Integer> status = DycActivityTransFieldUtil.TaskStatus(activityBaseInfoTimePO.getTabId());
        activityBaseInfoTimePO.setPendingAuditUserId(reqBO.getUserId());
        Page<DycActActivityApproveBaseInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityBaseInfoMapper.queryActivityApprovePageList(activityBaseInfoTimePO, status));

        if (ObjectUtils.isEmpty(page)) {
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        //封装集合
        List<DycActActivityApproveBaseInfo> activityBaseInfoBOList = JSON.parseArray(JSON.toJSONString(page.getResult()), DycActActivityApproveBaseInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(activityBaseInfoBOList);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public int updateActivityState(DycActivityDO reqBO) {
        ActivityBaseInfoPO infoPO = new ActivityBaseInfoPO();
        BeanUtils.copyProperties(reqBO, infoPO);
        infoPO.setUpdateTime(new Date());
        return activityBaseInfoMapper.update(infoPO);
    }

    @Override
    public DycActivityBaseInfo getActivityBaseInfoDetail(DycActivityDO dycActivityDO) {
        ActivityBaseInfoPO qryInfoPo = JUtil.js(dycActivityDO, ActivityBaseInfoPO.class);
        ActivityBaseInfoPO activityBaseInfoPo = activityBaseInfoMapper.getActivityBaseInfoDetail(qryInfoPo);
        DycActivityBaseInfo dycActivityBaseInfo = null;
        if(activityBaseInfoPo !=  null){
            dycActivityBaseInfo  = JUtil.js(activityBaseInfoPo, DycActivityBaseInfo.class);
        }
        return dycActivityBaseInfo;
    }


    @Override
    public DycActivityBaseInfo qryActiveBaseInfo(DycActivityDO reqBo) {
        ActivityBaseInfoPO infoPo = new ActivityBaseInfoPO();
        infoPo.setActivityId(reqBo.getActivityId());
        ActivityBaseInfoPO activityBaseInfoPo = activityBaseInfoMapper.qryActiveBaseInfo(infoPo);
        return JSONObject.parseObject(JSONObject.toJSONString(activityBaseInfoPo),DycActivityBaseInfo.class);
    }

    @Override
    public void insert(DycActiveBaseInfoSaveReqBO reqBo) {
        ActivityBaseInfoPO activityBaseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityBaseInfoPO.class);
        activityBaseInfoMapper.insert(activityBaseInfoPo);
    }


    @Override
    public int insertNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityChangeInfoPo = JSONObject.parseObject(JSONObject.toJSONString(reqBO), ActivityBaseInfoPO.class);
        return activityBaseInfoMapper.insertNew(activityChangeInfoPo);
    }

    @Override
    public int updateByNew(DycActivityBaseInfo set, DycActivityBaseInfo where) {
        ActivityBaseInfoPO activityBaseInfoPoSet = JSONObject.parseObject(JSONObject.toJSONString(set), ActivityBaseInfoPO.class);
        ActivityBaseInfoPO activityBaseInfoPoWhere = JSONObject.parseObject(JSONObject.toJSONString(where), ActivityBaseInfoPO.class);
        return activityBaseInfoMapper.updateBy(activityBaseInfoPoSet,activityBaseInfoPoWhere);
    }

    @Override
    public int getCheckByNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityChangeInfoPo = JSONObject.parseObject(JSONObject.toJSONString(reqBO), ActivityBaseInfoPO.class);
        return activityBaseInfoMapper.getCheckBy(activityChangeInfoPo);
    }

    @Override
    public DycActivityBaseInfo getModelByNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityBaseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(reqBO), ActivityBaseInfoPO.class);
        ActivityBaseInfoPO modelBy = activityBaseInfoMapper.getModelBy(activityBaseInfoPo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy),DycActivityBaseInfo.class);
    }

    @Override
    public List<DycActivityBaseInfo> getListNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityBaseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(reqBO), ActivityBaseInfoPO.class);
        List<ActivityBaseInfoPO> list = activityBaseInfoMapper.getList(activityBaseInfoPo);
        return JSONObject.parseArray(JSONObject.toJSONString(list),DycActivityBaseInfo.class);
    }

    @Override
    public void insertBatchNew(List<DycActivityBaseInfo> list) {
        List<ActivityBaseInfoPO> listPo = JSONObject.parseArray(JSONObject.toJSONString(list), ActivityBaseInfoPO.class);
        activityBaseInfoMapper.insertBatch(listPo);
    }
}
