package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfo;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfoAddBatchBO;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfoDeleteBatchBO;
import com.tydic.dyc.act.repository.api.DycActActivitySupplierRepository;
import com.tydic.dyc.act.repository.dao.ActivitySupplierInfoMapper;
import com.tydic.dyc.act.repository.dao.ActivitySupplierPoolMapper;
import com.tydic.dyc.act.repository.po.ActivitySupplierInfoPO;
import com.tydic.dyc.act.repository.po.ActivitySupplierPoolPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题：DycActActivitySupplierRepositoryImpl
 * 说明：
 * 时间： 2023-12-13 11:21
 * 作者 @author LY
 */
@Service
public class DycActActivitySupplierRepositoryImpl implements DycActActivitySupplierRepository {

    @Autowired
    private ActivitySupplierInfoMapper activitySupplierInfoMapper;

    @Autowired
    private ActivitySupplierPoolMapper activitySupplierPoolMapper;


    @Override
    public BasePageRspBo<DycActivitySupplierInfo> queryActivityUnselectSupplierPageList(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        BasePageRspBo<DycActivitySupplierInfo> rspBo = new BasePageRspBo<>();
        Page<ActivitySupplierPoolPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activitySupplierPoolMapper.queryActivityUnselectSupplierPageList(reqBO.getSupplierIds()));

        if (ObjectUtils.isEmpty(page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        rspBo.setRows(JSON.parseArray(JSON.toJSONString(page.getResult()), DycActivitySupplierInfo.class));
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;

    }

    /**
     * 描述: 供应商批量更新
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivitySupplierInfo
     */
    @Override
    public DycActivitySupplierInfo addBatchActiveSupplier(DycActivitySupplierInfoAddBatchBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("添加供应商数据为空或者活动id为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getSupplierList())) {
            throw new ZTBusinessException("添加供应商,供应商为空！");
        }
        List<ActivitySupplierInfoPO> collect = reqBO.getSupplierList().stream().map(item -> {
            ActivitySupplierInfoPO activitySupplierInfoPO = new ActivitySupplierInfoPO();
            item.setId(Sequence.getInstance().nextId());
            BeanUtils.copyProperties(item, activitySupplierInfoPO);
            activitySupplierInfoPO.setActivityId(reqBO.getActivityId());
            return activitySupplierInfoPO;
        }).collect(Collectors.toList());
        int i = activitySupplierInfoMapper.allInsert(collect);
        if (i != reqBO.getSupplierList().size()) {
            throw new ZTBusinessException("活动供应商插入失败！");
        }
        DycActivitySupplierInfo rspBO = new DycActivitySupplierInfo();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public DycActivitySupplierInfo deleteActiveSupplier(DycActivitySupplierInfoDeleteBatchBO reqBO) {
        ActivitySupplierInfoPO infoPO = new ActivitySupplierInfoPO();
        infoPO.setActivityId(reqBO.getActivityId());
        activitySupplierInfoMapper.delete(infoPO);
        return new DycActivitySupplierInfo();
    }


    /**
     * 描述: 供应商批量删除
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivitySupplierInfo
     */
    @Override
    public DycActivitySupplierInfo deleteBatchActiveSupplier(DycActivitySupplierInfoDeleteBatchBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || CollectionUtils.isEmpty(reqBO.getSupplierIdList()) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("删除供应商数据为空！");
        }
        activitySupplierInfoMapper.deleteBatchByActivityId(reqBO.getSupplierIdList(), reqBO.getActivityId());
        DycActivitySupplierInfo rspBO = new DycActivitySupplierInfo();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public BasePageRspBo<DycActivitySupplierInfo> queryActiveSupplierList(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        BasePageRspBo<DycActivitySupplierInfo> rspBo = new BasePageRspBo<>();
        ActivitySupplierInfoPO activitySupplierInfoPO = new ActivitySupplierInfoPO();
        activitySupplierInfoPO.setActivityId(reqBO.getActivityId());
        Page<ActivitySupplierPoolPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activitySupplierInfoMapper.selectByCondition(activitySupplierInfoPO));

        if (ObjectUtils.isEmpty(page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        rspBo.setRows(JSON.parseArray(JSON.toJSONString(page.getResult()), DycActivitySupplierInfo.class));
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public List<DycActivitySupplierInfo> queryActiveSupplierAllList(DycActivityDO reqBO) {
        List<DycActivitySupplierInfo> rspList = new ArrayList<>();
        ActivitySupplierPoolPO activitySupplierInfoPO = new ActivitySupplierPoolPO();
        List<ActivitySupplierPoolPO> activitySupplierInfoPOS = activitySupplierPoolMapper.selectByCondition(activitySupplierInfoPO);
        if (activitySupplierInfoPOS.size() < 0) {
            return rspList;
        }
        rspList = JSON.parseArray(JSON.toJSONString(activitySupplierInfoPOS), DycActivitySupplierInfo.class);
        return rspList;
    }

    @Override
    public int insertNew(DycActivitySupplierInfo reqBo) {
        ActivitySupplierInfoPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivitySupplierInfoPO.class);
        return activitySupplierInfoMapper.insertNew(insert);
    }

    @Override
    public int updateByNew(DycActivitySupplierInfo set, DycActivitySupplierInfo where) {
        ActivitySupplierInfoPO setPo = JSONObject.parseObject(JSONObject.toJSONString(set), ActivitySupplierInfoPO.class);
        ActivitySupplierInfoPO wherePo = JSONObject.parseObject(JSONObject.toJSONString(where), ActivitySupplierInfoPO.class);
        return activitySupplierInfoMapper.updateBy(setPo,wherePo);
    }

    @Override
    public int getCheckByNew(DycActivitySupplierInfo reqBo) {
        ActivitySupplierInfoPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivitySupplierInfoPO.class);
        return activitySupplierInfoMapper.getCheckBy(insert);
    }

    @Override
    public DycActivitySupplierInfo getModelByNew(DycActivitySupplierInfo reqBo) {
        ActivitySupplierInfoPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivitySupplierInfoPO.class);
        ActivitySupplierInfoPO modelBy = activitySupplierInfoMapper.getModelBy(qryBo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy), DycActivitySupplierInfo.class);
    }

    @Override
    public List<DycActivitySupplierInfo> getListNew(DycActivitySupplierInfo reqBo) {
        ActivitySupplierInfoPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivitySupplierInfoPO.class);
        List<ActivitySupplierInfoPO> list = activitySupplierInfoMapper.getList(qryBo);
        return JSONObject.parseArray(JSONObject.toJSONString(list), DycActivitySupplierInfo.class);
    }

    @Override
    public void insertBatchNew(List<DycActivitySupplierInfo> list) {
        List<ActivitySupplierInfoPO> listPo = JSONObject.parseArray(JSONObject.toJSONString(list), ActivitySupplierInfoPO.class);
        activitySupplierInfoMapper.insertBatch(listPo);
    }
}
