package com.tydic.dyc.act.repository.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActAlreadySyncExternalUserDO;
import com.tydic.dyc.act.model.bo.ActAlreadySyncExternalUserInfo;
import com.tydic.dyc.act.repository.api.DycActAlreadySyncExternalUserRepository;
import com.tydic.dyc.act.repository.dao.ActAlreadySyncExternalUserMapper;
import com.tydic.dyc.act.repository.po.ActAlreadySyncExternalUserPO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题：DycActAlreadySyncExternalUserRepositoryImpl
 * 说明：
 * 时间： 2024-04-15 16:38
 * 作者 @author LY
 */
@Service
public class DycActAlreadySyncExternalUserRepositoryImpl implements DycActAlreadySyncExternalUserRepository {

    @Autowired
    private ActAlreadySyncExternalUserMapper actAlreadySyncExternalUserMapper;


    @Override
    public List<ActAlreadySyncExternalUserInfo> queryActAlreadySyncExternalUserList(ActAlreadySyncExternalUserDO reqBO) {
        List<ActAlreadySyncExternalUserInfo> rspBO = new ArrayList<>();
        ActAlreadySyncExternalUserPO selectActAlreadySyncExternalUserPO = new ActAlreadySyncExternalUserPO();
        BeanUtils.copyProperties(reqBO, selectActAlreadySyncExternalUserPO);
        List<ActAlreadySyncExternalUserPO> actAlreadySyncExternalUserPOList = this.actAlreadySyncExternalUserMapper.selectByCondition(selectActAlreadySyncExternalUserPO);

        for (ActAlreadySyncExternalUserPO actAlreadySyncExternalUserPO : actAlreadySyncExternalUserPOList) {
            ActAlreadySyncExternalUserInfo actAlreadySyncExternalUserBO = new ActAlreadySyncExternalUserInfo();
            BeanUtils.copyProperties(actAlreadySyncExternalUserPO, actAlreadySyncExternalUserBO);
            rspBO.add(actAlreadySyncExternalUserBO);
        }
        return rspBO;
    }

    @Override
    public int addListActAlreadySyncExternalUser(List<ActAlreadySyncExternalUserDO> reqBO) {
        List<ActAlreadySyncExternalUserPO> collect = reqBO.stream().map(item -> {
            ActAlreadySyncExternalUserPO userPO = new ActAlreadySyncExternalUserPO();
            BeanUtils.copyProperties(item, userPO);
            userPO.setId(Sequence.getInstance().nextId());
            return userPO;
        }).collect(Collectors.toList());
        return actAlreadySyncExternalUserMapper.allInsert(collect);
    }

    @Override
    public int deleteActAlreadySyncExternalUser(ActAlreadySyncExternalUserDO reqBO) {
        ActAlreadySyncExternalUserPO userPO = new ActAlreadySyncExternalUserPO();
        BeanUtils.copyProperties(reqBO, userPO);
        return actAlreadySyncExternalUserMapper.delete(userPO);
    }
}
