package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityFileInfo;
import com.tydic.dyc.act.repository.api.DycActFileRepository;
import com.tydic.dyc.act.repository.dao.ActivityFileInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityFileInfoPO;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈活动实体基建方法实现〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:33
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Service
public class DycActFileRepositoryImpl implements DycActFileRepository {

    @Autowired
    ActivityFileInfoMapper activityFileInfoMapper;


    @Override
    public List<DycActivityFileInfo> queryActivityFileList(DycActivityDO reqBO) {
        List<DycActivityFileInfo> activityBaseInfoBOList = new ArrayList<>();
        ActivityFileInfoPO activityFileInfoPO = new ActivityFileInfoPO();
        BeanUtils.copyProperties(reqBO, activityFileInfoPO);
        List<ActivityFileInfoPO> activityBaseInfoPOS = activityFileInfoMapper.selectByCondition(activityFileInfoPO);
        //封装集合
        if (activityBaseInfoPOS.size() < 1) {
            return activityBaseInfoBOList;
        }
        for (ActivityFileInfoPO activityBaseInfoPO : activityBaseInfoPOS) {
            DycActivityFileInfo activityBaseInfoBO = new DycActivityFileInfo();
            BeanUtils.copyProperties(activityBaseInfoPO, activityBaseInfoBO);
            activityBaseInfoBO.setObjTypeStr(DycActivityTransFieldUtil.BusinessObject(String.valueOf(activityBaseInfoBO.getObjType())));
            activityBaseInfoBOList.add(activityBaseInfoBO);
        }

        return activityBaseInfoBOList;
    }

    @Override
    public DycActivityFileInfo updateActivityFileInfo(DycActivityFileInfo reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        DycActivityFileInfo rspBO = new DycActivityFileInfo();
        ActivityFileInfoPO selectActivityFileInfoPO = new ActivityFileInfoPO();
        selectActivityFileInfoPO.setFileId(reqBO.getFileId());
        List<ActivityFileInfoPO> activityFileInfoList = this.activityFileInfoMapper.selectByCondition(selectActivityFileInfoPO);
        if (activityFileInfoList.size() == 1) {
            ActivityFileInfoPO updateActivityFileInfoPO = new ActivityFileInfoPO();
            BeanUtils.copyProperties(reqBO, updateActivityFileInfoPO);

            int num = this.activityFileInfoMapper.update(updateActivityFileInfoPO);
            if (num == 1) {
                BeanUtils.copyProperties(updateActivityFileInfoPO, rspBO);
            }
        }
        return rspBO;
    }

    @Override
    public List<DycActivityFileInfo> addListActivityFileInfo(List<DycActivityFileInfo> reqBO) {
        if (reqBO.size() < 1) {
            throw new ZTBusinessException("入参不能为空！");
        }
        List<DycActivityFileInfo> rspBO = new ArrayList<>();
        for (int i = 0; i < reqBO.size(); i++) {
            long id = Sequence.getInstance().nextId();
            reqBO.get(i).setFileId(id);
        }
        List<ActivityFileInfoPO> insertActivityFileInfoPO = JSONObject.parseArray(JSONObject.toJSONString(reqBO), ActivityFileInfoPO.class);
        //TODO 封装其它信息

        int num = this.activityFileInfoMapper.allInsert(insertActivityFileInfoPO);
        if (num == reqBO.size()) {
            rspBO = JSONObject.parseArray(JSONObject.toJSONString(insertActivityFileInfoPO), DycActivityFileInfo.class);
        }
        return rspBO;
    }

    @Override
    public int deleteActivityFileInfo(DycActivityFileInfo reqBO) {
        ActivityFileInfoPO record = new ActivityFileInfoPO();
        record.setObjId(reqBO.getObjId());
        record.setObjType(reqBO.getObjType());
        return this.activityFileInfoMapper.delete(record);
    }

    @Override
    public DycActivityFileInfo queryActivityFile(DycActivityFileInfo reqBO) {
        ActivityFileInfoPO activityFileInfoPO = new ActivityFileInfoPO();
        BeanUtils.copyProperties(reqBO, activityFileInfoPO);
        ActivityFileInfoPO activityFileInfoPOResult = activityFileInfoMapper.selectOneByCondition(activityFileInfoPO);
        return JSONObject.parseObject(JSONObject.toJSONString(activityFileInfoPOResult), DycActivityFileInfo.class);
    }

    @Override
    public DycActivityFileInfo saveActivityFileInfo(DycActivityFileInfo reqBO) {
        if (reqBO.getFileId() == null) {
            List<DycActivityFileInfo> list = new ArrayList<>();
            list.add(reqBO);
            return this.addListActivityFileInfo(list).get(0);
        }
        //修改信息
        else {
            return this.updateActivityFileInfo(reqBO);
        }
    }

    @Override
    public void updateByObjId(DycActivityFileInfo reqBo) {
        ActivityFileInfoPO activityFileInfoPo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityFileInfoPO.class);
        activityFileInfoMapper.updateByObjId(activityFileInfoPo);
    }
}
