package com.tydic.dyc.act.repository.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.dyc.act.model.bo.DycActFscRelOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscRelOrderInfo;
import com.tydic.dyc.act.repository.api.DycActFscCheckResultRepository;
import com.tydic.dyc.act.repository.dao.ActFscCheckResultMapper;
import com.tydic.dyc.act.repository.po.ActFscCheckResultPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName DycActFscCheckResultRepositoryImpl
 * @Author 14051
 * @Date 2024/4/6 14:08
 * @Version 1.0
 * @Description TODO
 **/
@Service
public class DycActFscCheckResultRepositoryImpl implements DycActFscCheckResultRepository {

    @Autowired
    private ActFscCheckResultMapper actFscCheckResultMapper;

    @Override
    public BasePageRspBo<DycActFscRelOrderInfo> selectByConditon(DycActFscRelOrderDO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        Page<ActFscCheckResultPO> page;
        ActFscCheckResultPO record = new ActFscCheckResultPO();
        BeanUtils.copyProperties(reqBO, record);
        if (reqBO.getFscOrderId() != null){
            page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actFscCheckResultMapper.selectByFscOrderId(record));
        } else {
            page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actFscCheckResultMapper.selectByCondition(record));
        }
        //封装集合
        List<DycActFscRelOrderInfo> fscRelOrderInfos = new ArrayList<>();
        for (ActFscCheckResultPO actFscCheckResultPO : page.getResult()) {
            DycActFscRelOrderInfo dycActFscRelOrderInfo = new DycActFscRelOrderInfo();
            BeanUtils.copyProperties(actFscCheckResultPO, dycActFscRelOrderInfo);
            dycActFscRelOrderInfo.setOrderId(actFscCheckResultPO.getOrderId().toString());
            dycActFscRelOrderInfo.setCheckResult(actFscCheckResultPO.getStatus());
            dycActFscRelOrderInfo.setOrderAmt(actFscCheckResultPO.getAmount());
            dycActFscRelOrderInfo.setAmt(actFscCheckResultPO.getAmount());
            dycActFscRelOrderInfo.setOtherAmt(actFscCheckResultPO.getOtherAmount());
            dycActFscRelOrderInfo.setCheckUserName(actFscCheckResultPO.getOperName());
            dycActFscRelOrderInfo.setPersonMoney(actFscCheckResultPO.getPersonAmount());
            dycActFscRelOrderInfo.setOrderCreateTime(actFscCheckResultPO.getOrderTime());
            fscRelOrderInfos.add(dycActFscRelOrderInfo);
        }
        BasePageRspBo<DycActFscRelOrderInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(fscRelOrderInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }
}
