package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActFscOrderRepository;
import com.tydic.dyc.act.repository.dao.ActFscOrderBatchInfoMapper;
import com.tydic.dyc.act.repository.dao.ActFscOrderMapper;
import com.tydic.dyc.act.repository.dao.ActivityFileInfoMapper;
import com.tydic.dyc.act.repository.po.ActFscOrderBatchInfoPO;
import com.tydic.dyc.act.repository.po.ActFscOrderPO;
import com.tydic.dyc.act.repository.po.ActivityFileInfoPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName DycActFscOrderRepositoryImpl
 * @Author 14051
 * @Date 2024/4/2 20:26
 * @Version 1.0
 * @Description TODO
 **/
@Service
public class DycActFscOrderRepositoryImpl implements DycActFscOrderRepository {

    @Autowired
    private ActFscOrderMapper actFscOrderMapper;
    @Autowired
    private ActivityFileInfoMapper activityFileInfoMapper;
    @Autowired
    private ActFscOrderBatchInfoMapper actFscOrderBatchInfoMapper;

    @Override
    public int dealPayOrderState(DycActFscOrderDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        int i = actFscOrderMapper.update(record);
        return i;
    }

    @Override
    public int dealSignOrderState(DycActFscOrderSignDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        int i = actFscOrderMapper.update(record);
        return i;
    }

    @Override
    public DycActFscOrderInfo getFscOrderOne(DycActFscOrderDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        ActFscOrderPO actFscOrderPO = actFscOrderMapper.getFscOrderOne(record);
        return JSON.parseObject(JSON.toJSONString(actFscOrderPO), DycActFscOrderInfo.class);
    }

    @Override
    public BasePageRspBo<DycActFscOrderInfo> selectByCondition(DycActFscOrderQryDO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        Page<ActFscOrderPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actFscOrderMapper.selectByCondition(record));
        //封装集合
        List<DycActFscOrderInfo> fscOrderInfos = new ArrayList<>();
        for (ActFscOrderPO fscOrderPO : page.getResult()) {
            DycActFscOrderInfo dycActFscOrderInfo = new DycActFscOrderInfo();
            BeanUtils.copyProperties(fscOrderPO, dycActFscOrderInfo);
            fscOrderInfos.add(dycActFscOrderInfo);
        }
        BasePageRspBo<DycActFscOrderInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(fscOrderInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public List<DycActFscOrderFileInfo> selectFileListByIds(DycActFscOrderFileQryDO reqBO) {
        List<DycActFscOrderFileInfo> rspBO = new ArrayList<>();
        ActivityFileInfoPO record = new ActivityFileInfoPO();
        record.setObjIds(reqBO.getFscOrderIds());
        List<ActivityFileInfoPO> activityFileInfoPOS = activityFileInfoMapper.selectByCondition(record);
        if (!CollectionUtils.isEmpty(activityFileInfoPOS)){
            rspBO = JSON.parseArray(JSON.toJSONString(activityFileInfoPOS), DycActFscOrderFileInfo.class);
        }
        return rspBO;
    }

    @Override
    public int dealOrderState(DycActFscOrderDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        int i = actFscOrderMapper.update(record);
        return i;
    }

    @Override
    public int updateLogisticsInfo(DycActFscOrderLogisticsInfoDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        int i = actFscOrderMapper.update(record);
        return i;
    }

    @Override
    public DycActFscOrdSaveInfo saveFscOrder(DycActFscOrderSaveDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        record.setFscOrderId(Sequence.getInstance().nextId());
        record.setCreateCompanyId(reqBO.getCompanyId());
        record.setCreateCompanyName(reqBO.getCompanyName());
        record.setCreateOperName(reqBO.getName());
        record.setCreateUserId(reqBO.getUserId());
        record.setCreateOrgId(reqBO.getOrgId());
        record.setCreateOrgName(reqBO.getOrgName());
        record.setCreateOrgPath(reqBO.getOrgPath());
        record.setBuildAction(0);
        record.setPayeeId(reqBO.getSupplierId());
        record.setPayeeName(reqBO.getSupplierName());
        record.setPayerId(reqBO.getCompanyId());
        record.setPayerName(reqBO.getCompanyName());
        actFscOrderMapper.insert(record);
        DycActFscOrdSaveInfo dycActFscOrdSaveInfo = new DycActFscOrdSaveInfo();
        dycActFscOrdSaveInfo.setFscOrderId(record.getFscOrderId());
        return dycActFscOrdSaveInfo;
    }

    @Override
    public int getFscPushFailNum(DycActFscOrderDO reqBO) {
        ActFscOrderBatchInfoPO record = new ActFscOrderBatchInfoPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        return actFscOrderBatchInfoMapper.getFscPushFailNum(record);
    }
}
