package com.tydic.dyc.act.repository.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActOrderInfoRepository;
import com.tydic.dyc.act.repository.dao.ActOrderAfterInfoMapper;
import com.tydic.dyc.act.repository.dao.ActOrderInfoMapper;
import com.tydic.dyc.act.repository.dao.ActOrderInfoMapperUni;
import com.tydic.dyc.act.repository.po.ActOrderAfsUniInfo;
import com.tydic.dyc.act.repository.po.ActOrderAfterInfoPO;
import com.tydic.dyc.act.repository.po.ActOrderInfoPO;
import com.tydic.dyc.act.repository.po.ActOrderUniInfo;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName DycActOrderInfoRepositoryImpl
 * @Author 14051
 * @Date 2024/4/2 10:50
 * @Version 1.0
 * @Description TODO
 **/
@Service
public class DycActOrderInfoRepositoryImpl implements DycActOrderInfoRepository {

    @Autowired
    private ActOrderInfoMapperUni actOrderInfoMapperUni;
    @Autowired
    private ActOrderInfoMapper actOrderInfoMapper;
    @Autowired
    private ActOrderAfterInfoMapper actOrderAfterInfoMapper;

    @Override
    public BasePageRspBo<DycActOrderInfo> qryOrdInfoPageList(DycActOrderQryDO dycActOrderQryDO) {
        if (dycActOrderQryDO.getPageNo() < 1) {
            dycActOrderQryDO.setPageNo(1);
        }
        if (dycActOrderQryDO.getPageSize() < 1) {
            dycActOrderQryDO.setPageSize(10);
        }
        Page<ActOrderUniInfo> page = PageHelper.startPage(dycActOrderQryDO.getPageNo(), dycActOrderQryDO.getPageSize()).doSelectPage(() -> this.actOrderInfoMapperUni.selectOrdInfoPageByCond(dycActOrderQryDO));
        //封装集合
        List<DycActOrderInfo> actOrderInfoBOList = new ArrayList<>();
        for (ActOrderUniInfo actOrderInfoPO : page.getResult()) {
            DycActOrderInfo actOrderInfoBO = new DycActOrderInfo();
            BeanUtils.copyProperties(actOrderInfoPO, actOrderInfoBO);
            actOrderInfoBOList.add(actOrderInfoBO);
        }
        BasePageRspBo<DycActOrderInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actOrderInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public BasePageRspBo<DycActOrderAfsInfo> qryOrdAfsInfoPageList(DycActOrderAfsQryDO dycActOrderAfsQryDO) {
        if (dycActOrderAfsQryDO.getPageNo() < 1) {
            dycActOrderAfsQryDO.setPageNo(1);
        }
        if (dycActOrderAfsQryDO.getPageSize() < 1) {
            dycActOrderAfsQryDO.setPageSize(10);
        }
        Page<ActOrderAfsUniInfo> page = PageHelper.startPage(dycActOrderAfsQryDO.getPageNo(), dycActOrderAfsQryDO.getPageSize()).doSelectPage(() -> this.actOrderInfoMapperUni.selectOrdAfsInfoPageByCond(dycActOrderAfsQryDO));
        //封装集合
        List<DycActOrderAfsInfo> actOrderAfsInfoBOList = new ArrayList<>();
        for (ActOrderAfsUniInfo actOrderAfsInfoPO : page.getResult()) {
            DycActOrderAfsInfo actOrderAfsInfoBO = new DycActOrderAfsInfo();
            BeanUtils.copyProperties(actOrderAfsInfoPO, actOrderAfsInfoBO);
            actOrderAfsInfoBO.setAfsOrderId(actOrderAfsInfoPO.getAfsServiceId());
            actOrderAfsInfoBO.setAfsDetailUrl(actOrderAfsInfoPO.getAfDetailUrl());
            actOrderAfsInfoBO.setCreateTime(actOrderAfsInfoPO.getAfsApplyTime());
            actOrderAfsInfoBO.setServState(actOrderAfsInfoPO.getAfsStep().toString());
            actOrderAfsInfoBO.setServStateStr(actOrderAfsInfoPO.getAfsStepName());
            actOrderAfsInfoBO.setServType(actOrderAfsInfoPO.getServType().toString());
            actOrderAfsInfoBO.setServTypeStr(actOrderAfsInfoPO.getServTypeName());
            actOrderAfsInfoBO.setReceiveTime(actOrderAfsInfoBO.getReceiveTime());
            actOrderAfsInfoBOList.add(actOrderAfsInfoBO);
        }
        BasePageRspBo<DycActOrderAfsInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actOrderAfsInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public BigDecimal getTotalScoreByActivityId(Long activityId) {
        return actOrderInfoMapper.getTotalScoreByActivityId(activityId);
    }

    @Override
    public List<String> qryAlertOrderList(DycActDealAlertQryOrderDO reqBO) {
        ActOrderInfoPO record = new ActOrderInfoPO();
        record.setOrderState(reqBO.getOrderState());
        record.setDayNum(reqBO.getDayNum());
        if (StringUtils.isNotBlank(reqBO.getOrderId())){
            record.setOrderId(reqBO.getOrderId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderIds())){
            record.setOrderIds(reqBO.getOrderIds());
        }
        if ("1".equals(reqBO.getAlertFlag())){
            return actOrderInfoMapper.qryUnSendOrderList(record);
        } else if ("2".equals(reqBO.getAlertFlag())) {
            return actOrderInfoMapper.qryUnReceiveOrderList(record);
        }
        return null;
    }

    @Override
    public void updateOrderAlertType(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        ActOrderInfoPO record = new ActOrderInfoPO();
        record.setOrderId(dycActDealOrderAlertDO.getOrderId());
        record.setOrderIds(dycActDealOrderAlertDO.getOrderIds());
        record.setAlertType(dycActDealOrderAlertDO.getAlertType());
        actOrderInfoMapper.updateAlertType(record);
    }

    @Override
    public List<ActAlertOrderInfo> qryExistAlertOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        return actOrderInfoMapperUni.qryExistAlertOrderList(dycActDealAlertQryOrderDO);
    }

    @Override
    public List<String> qryAlertAfsOrderList(DycActDealAlertQryOrderDO reqBO) {
        ActOrderAfterInfoPO record = new ActOrderAfterInfoPO();
        if (StringUtils.isNotBlank(reqBO.getAfsServiceId())){
            record.setAfsServiceId(reqBO.getAfsServiceId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getAfsServiceIds())){
            record.setAfsServiceIds(reqBO.getAfsServiceIds());
        }
        record.setDayNum(reqBO.getDayNum());
        return actOrderAfterInfoMapper.qryUnRespOrderList(record);
    }

    @Override
    public void updateAfsOrderAlertType(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        ActOrderAfterInfoPO record = new ActOrderAfterInfoPO();
        record.setAfsServiceId(dycActDealOrderAlertDO.getOrderId());
        record.setAfsServiceIds(dycActDealOrderAlertDO.getOrderIds());
        record.setAlertType(dycActDealOrderAlertDO.getAlertType());
        actOrderAfterInfoMapper.updateAlertType(record);
    }

    @Override
    public List<ActAlertAfsOrderInfo> qryExistAlertAfsOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        return actOrderInfoMapperUni.qryExistAlertAfsOrderList(dycActDealAlertQryOrderDO);
    }
}
