package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActSkuInfoRepository;
import com.tydic.dyc.act.repository.dao.ActSkuDetailMapper;
import com.tydic.dyc.act.repository.dao.ActSkuInfoMapper;
import com.tydic.dyc.act.repository.dao.ActSkuPicMapper;
import com.tydic.dyc.act.repository.dao.ActSkuPoolMapper;
import com.tydic.dyc.act.repository.po.*;
import com.tydic.dyc.act.utils.ActRu;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("actSkuInfoService")
public class DycActSkuInfoRepositoryImpl implements DycActSkuInfoRepository {

    @Autowired
    ActSkuInfoMapper actSkuInfoMapper;
    @Autowired
    private ActSkuPoolMapper actSkuPoolMapper;

    @Autowired
    private ActSkuDetailMapper actSkuDetailMapper;

    @Autowired
    private ActSkuPicMapper actSkuPicMapper;

    @Override
    public ActSkuInfoRspBO queryActSkuInfoSingle(ActSkuInfoReqBO actSkuInfoReqBO){
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();
        ActSkuInfoExtPO selectActSkuInfoPO = new ActSkuInfoExtPO();
        BeanUtils.copyProperties(actSkuInfoReqBO, selectActSkuInfoPO);
        List<ActSkuInfoPO> actSkuInfoList = this.actSkuInfoMapper.selectByCondition(selectActSkuInfoPO);
        if (actSkuInfoList.size() == 1) {
            ActSkuInfoBO actSkuInfoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties(actSkuInfoList.get(0), actSkuInfoBO);
            rspBO.setData(actSkuInfoBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else if (actSkuInfoList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuInfoListRspBO queryActSkuInfoList(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoListRspBO rspBO = new ActSkuInfoListRspBO();
        ActSkuInfoExtPO selectActSkuInfoPO = new ActSkuInfoExtPO();
        BeanUtils.copyProperties(actSkuInfoReqBO, selectActSkuInfoPO);
        List<ActSkuInfoPO> actSkuInfoPOList = this.actSkuInfoMapper.selectByCondition(selectActSkuInfoPO);

        List<ActSkuInfoBO> actSkuInfoBOList = new ArrayList<>();
        for (ActSkuInfoPO actSkuInfoPO : actSkuInfoPOList) {
            ActSkuInfoBO actSkuInfoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties(actSkuInfoPO, actSkuInfoBO);
            actSkuInfoBOList.add(actSkuInfoBO);
        }

        rspBO.setData(actSkuInfoBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public ActSkuInfoRspBO addActSkuInfo(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();

        ActSkuInfoPO insertActSkuInfoPO = new ActSkuInfoPO();
        BeanUtils.copyProperties(actSkuInfoReqBO, insertActSkuInfoPO);
        long id = Sequence.getInstance().nextId();
        insertActSkuInfoPO.setSkuId(id);
        //TODO 封装其它信息

        int num = this.actSkuInfoMapper.insert(insertActSkuInfoPO);
        if (num == 1) {
            ActSkuInfoBO ActSkuInfoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties(insertActSkuInfoPO, ActSkuInfoBO);
            rspBO.setData(ActSkuInfoBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }


    @Override
    public ActSkuInfoListRspBO addListActSkuInfo(List<ActSkuInfoReqBO> actSkuInfoReqBO) {
        ActSkuInfoListRspBO rspBO = new ActSkuInfoListRspBO();
        for(int i = 0;i < actSkuInfoReqBO.size();i++){
                            long id = Sequence.getInstance().nextId();
                actSkuInfoReqBO.get(i).setSkuId(id);
                }

        List<ActSkuInfoPO> insertActSkuInfoPO = JSONObject.parseArray(JSONObject.toJSONString(actSkuInfoReqBO),ActSkuInfoPO.class);


        int num = this.actSkuInfoMapper.allInsert(insertActSkuInfoPO);
        if (num == actSkuInfoReqBO.size()) {
            List<ActSkuInfoBO> lActSkuInfoBO = JSONObject.parseArray(JSONObject.toJSONString(insertActSkuInfoPO),ActSkuInfoBO.class);
            rspBO.setData(lActSkuInfoBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    public ActSkuInfoRspBO updateActSkuInfo(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();
        ActSkuInfoExtPO selectActSkuInfoPO = new ActSkuInfoExtPO();
        selectActSkuInfoPO.setSkuId(actSkuInfoReqBO.getSkuId());
        List<ActSkuInfoPO> actSkuInfoList = this.actSkuInfoMapper.selectByCondition(selectActSkuInfoPO);
        if (actSkuInfoList.size() == 1) {
            ActSkuInfoPO updateActSkuInfoPO = new ActSkuInfoPO();
            BeanUtils.copyProperties(actSkuInfoReqBO, updateActSkuInfoPO);

            int num = this.actSkuInfoMapper.update(updateActSkuInfoPO);
            if (num == 1) {
                ActSkuInfoBO actSkuInfoBO = new ActSkuInfoBO();
                BeanUtils.copyProperties(updateActSkuInfoPO, actSkuInfoBO);
                rspBO.setData(actSkuInfoBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }
        } else if (actSkuInfoList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActSkuInfoRspBO saveActSkuInfo(ActSkuInfoReqBO actSkuInfoReqBO) {
        //新增信息
        if (actSkuInfoReqBO.getSkuId() == null) {
            return this.addActSkuInfo(actSkuInfoReqBO);
        }
        //修改信息
        else {
            return this.updateActSkuInfo(actSkuInfoReqBO);
        }
    }

    @Override
    public ActSkuInfoRspBO deleteActSkuInfo(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();
        ActSkuInfoExtPO selectActSkuInfoPO = new ActSkuInfoExtPO();
        selectActSkuInfoPO.setSkuId(actSkuInfoReqBO.getSkuId());
        List<ActSkuInfoPO> actSkuInfoList = this.actSkuInfoMapper.selectByCondition(selectActSkuInfoPO);
        if (actSkuInfoList.size() == 1) {
            ActSkuInfoPO deleteActSkuInfoPO = new ActSkuInfoPO();
            BeanUtils.copyProperties(actSkuInfoReqBO, deleteActSkuInfoPO);

            int num = this.actSkuInfoMapper.delete(deleteActSkuInfoPO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actSkuInfoList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public Map<Long,ActSkuInfoBO> queryActSkuInfoByIdList(List<Long> skuIds) {
        List<ActSkuInfoExtPO> rspBO = actSkuInfoMapper.selectBySkuIdsCondition(skuIds);
        //查询单品所属商品池名称
        List<ActSkuPoolExtPO> actSkuPoolExtPOS = actSkuPoolMapper.selectBySkuIdsCondition(skuIds);
        Map<Long, List<ActSkuPoolExtPO>> poolMap = new HashMap<>();
        if(!CollectionUtils.isEmpty(actSkuPoolExtPOS)){
            poolMap = actSkuPoolExtPOS.stream().collect(Collectors.groupingBy(ActSkuPoolExtPO::getSkuId));
        }
        Map<Long,ActSkuInfoBO> map = new HashMap<>();
        for (ActSkuInfoExtPO item : rspBO) {
            ActSkuInfoBO infoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties(item,infoBO);
            if(!poolMap.isEmpty()){
                //组装商品池名称
                if(poolMap.containsKey(item.getSkuId())){
                    List<ActSkuPoolExtPO> poolList = poolMap.get(item.getSkuId());
                    List<String> poolNameList = poolList.stream().map(ActSkuPoolExtPO::getPoolName).distinct().collect(Collectors.toList());
                    String poolNames = String.join(",", poolNameList);
                    infoBO.setPoolNames(poolNames);
                }
            }
            map.put(item.getSkuId(),infoBO);
        }
        return map;
    }

    @Override
    public ActSkuInfoQryRspBO querySkuPageList(ActSkuInfoQryBO qryBO) {
        ActSkuInfoExtPO qryPO = ActRu.js(qryBO, ActSkuInfoExtPO.class);
        Page<ActSkuInfoExtPO> page = PageHelper.startPage(qryBO.getPageNo(), qryBO.getPageSize()).doSelectPage(() -> this.actSkuInfoMapper.getListPage(qryPO));
        ActSkuInfoQryRspBO rspBo = new ActSkuInfoQryRspBO();
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRows(!CollectionUtils.isEmpty(page.getResult()) ? ActRu.jsl(page.getResult(), ActSkuInfoDO.class) : new ArrayList<>(0));
        return rspBo;
    }

    @Override
    public Map<String, ActSkuInfoBO> queryActSkuInfoByCodeList(List<String> skuCodes) {
        List<ActSkuInfoExtPO> rspBO = actSkuInfoMapper.selectBySkuCodesCondition(skuCodes);

        if(CollectionUtils.isEmpty(rspBO)){
            return new HashMap<>();
        }
        List<Long> skuIds = rspBO.stream().map(ActSkuInfoExtPO::getSkuId).collect(Collectors.toList());
        //查询单品所属商品池名称
        List<ActSkuPoolExtPO> actSkuPoolExtPOS = actSkuPoolMapper.selectBySkuIdsCondition(skuIds);

        //查询出所有商品详情
        ActSkuDetailPO actSkuDetailPO = new ActSkuDetailPO();
        actSkuDetailPO.setSkuIds(skuIds);
        List<ActSkuDetailPO> actSkuDetailPOS = actSkuDetailMapper.selectByCondition(actSkuDetailPO);
        Map<Long,List<ActSkuDetailPO>> detailMap = new HashMap<>();
        if(!CollectionUtils.isEmpty(actSkuDetailPOS)){
            detailMap = actSkuDetailPOS.stream().collect(Collectors.groupingBy(ActSkuDetailPO::getSkuId));
        }

        //查询所有商品图片
        ActSkuPicPO actSkuPicPO = new ActSkuPicPO();
        actSkuPicPO.setSkuIds(skuIds);
        actSkuPicPO.setPicType(DycActivityConstants.PicType.CZG);
        List<ActSkuPicPO> actSkuPicPOS = actSkuPicMapper.selectByCondition(actSkuPicPO);
        Map<Long,List<ActSkuPicPO>> picMap = new HashMap<>();
        if(!CollectionUtils.isEmpty(actSkuPicPOS)){
            picMap = actSkuPicPOS.stream().collect(Collectors.groupingBy(ActSkuPicPO::getSkuId));
        }

        Map<Long, List<ActSkuPoolExtPO>> poolMap = new HashMap<>();
        if(!CollectionUtils.isEmpty(actSkuPoolExtPOS)){
            poolMap = actSkuPoolExtPOS.stream().collect(Collectors.groupingBy(ActSkuPoolExtPO::getSkuId));
        }
        Map<String,ActSkuInfoBO> map = new HashMap<>();
        for (ActSkuInfoExtPO item : rspBO) {
            ActSkuInfoBO infoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties(item,infoBO);
            if(!poolMap.isEmpty()){
                //组装商品池名称
                if(poolMap.containsKey(item.getSkuId())){
                    List<ActSkuPoolExtPO> poolList = poolMap.get(item.getSkuId());
                    List<String> poolNameList = poolList.stream().map(ActSkuPoolExtPO::getPoolName).distinct().collect(Collectors.toList());
                    String poolNames = String.join(",", poolNameList);
                    infoBO.setPoolNames(poolNames);
                }
                //组装商品图片
                if(picMap.containsKey(item.getSkuId())){
                    List<ActSkuPicPO> picList = picMap.get(item.getSkuId());
                    infoBO.setSkuUrl(picList.get(0).getSkuPicUrl());
                }
                //组装商品详情
                if(detailMap.containsKey(item.getSkuId())){
                    List<ActSkuDetailPO> detailList = detailMap.get(item.getSkuId());
                    infoBO.setSkuPcDetailUrl(detailList.get(0).getSkuPcDetailUrl());
                }
            }
            map.put(item.getSkuCode(),infoBO);
        }
        return map;
    }

}
