package com.tydic.dyc.act.repository.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: ActAlertInfoPO
 * @Description: ActAlertInfoPO
 * @author: liaoyang
 * @date: 2024年04月16日17:42:19
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActAlertInfoPO implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键ID
	 */
    private Long id;
	/**
	 * 单据ID
	 */
    private String objId;
	/**
	 * 类型：1订单、2服务单、3结算单
	 */
    private Integer objType;
	/**
	 * 预警类型：1超期未发货、2超期未收货、3超期未响应、4超期未签收、5超期未付款
	 */
    private Integer alertType;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 预警状态：0未处理，1已处理
	 */
    private Integer alertState;
	/**
	 * 更新时间
	 */
    private Date updateTime;
	/**
	 * 主键ID集合
	 */
	private List<Long> ids;
}