package com.tydic.dyc.act.repository.po;

import lombok.Data;
import java.math.BigDecimal;
import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName: ActivityUserInfoPO
 * @Description: ActivityUserInfoPO
 * @author: zhoulu
 * @date: 2023年12月11日16:43:59
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class ActivityUserInfoPO implements Serializable {


	private static final long serialVersionUID = 5474664880138425899L;
	/**
	 * ID
	 */
    private Long id;
	/**
	 * 活动id
	 */
    private Long activityId;
	/**
	 * 用户id
	 */
    private Long userId;
	/**
	 * 用户名
	 */
    private String userName;
	/**
	 * 用户姓名
	 */
    private String name;
	/**
	 * 工号
	 */
    private String workNo;
	/**
	 * 性别; 1 男 2 女
	 */
    private Integer sex;
	/**
	 * 电话
	 */
    private String phone;
	/**
	 * 用户所属组织ID
	 */
    private Long userOrgId;
	/**
	 * 用户所属组织名称
	 */
    private String userOrgName;
	/**
	 * 用户所属公司ID
	 */
	private Long userCompanyId;
	/**
	 * 用户所属公司名称
	 */
	private String userCompanyName;
	/**
	 * 用户所属机构树路径
	 */
	private String userOrgPath;
	/**
	 * 积分状态（0：正常，1：冻结）
	 */
    private Integer scoresType;
	/**
	 * 发放积分（第一次的发放）
	 */
    private BigDecimal giveScores;
	/**
	 * 已使用积分
	 */
    private BigDecimal usedScores;
	/**
	 * 剩余可用积分
	 */
    private BigDecimal balanceScores;
	/**
	 * 删除标志
            0:未删除；1：已删除
	 */
    private Integer delFlag;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 创建人ID
	 */
    private Long createUserId;
	/**
	 * 创建人名称
	 */
    private String createUserName;
	/**
	 * 更新时间
	 */
    private Date updateTime;
	/**
	 * 更新人名称
	 */
    private String updateUserName;
	/**
	 * 更新人ID
	 */
    private Long updateUserId;
	/**
	 * 创建时间
	 */
	private Date createTimeEnd;
	/**
	 * 创建时间
	 */
	private Date createTimeStart;
	/**
	 * 更新时间
	 */
	private Date updateTimeStart;
	/**
	 * 更新时间
	 */
	private Date updateTimeEnd;

	/**
	 * 剩余积分最小值
	 */
	private BigDecimal balanceScoresMin;
	/**
	 * 剩余积分最大值
	 */
	private BigDecimal balanceScoresMax;

	/**
	 * 排序
	 */
	private String orderBy;
}