/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.util.DesensitizedUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.ActConstants;
import com.tydic.dyc.act.model.bo.ActivityChangeUserInfo;
import com.tydic.dyc.act.model.bo.ActivityChangeUserInfoQryBO;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo;
import com.tydic.dyc.act.repository.api.DycActActivityChangeUserRepository;
import com.tydic.dyc.act.repository.dao.ActivityChangeUserInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityChangeUserInfoPO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycActActivityChangeUserRepositoryImpl
implements DycActActivityChangeUserRepository {
    @Autowired
    private ActivityChangeUserInfoMapper activityChangeUserInfoMapper;
    @Value(value="${LIMIT_SCORES:50000}")
    private BigDecimal LIMIT_SCORES;

    public void batchSelectActivityChangeUser(DycActivityChangeDO reqBo) {
        int i;
        Map<Long, ActivityChangeUserInfoPO> collectMap = null;
        ArrayList<ActivityChangeUserInfoPO> changeUserInfoPoList = new ArrayList<ActivityChangeUserInfoPO>();
        ActivityChangeUserInfoPO activityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        List<Long> collect = reqBo.getUserList().stream().map(DycActivityChangeUserInfo::getActUserId).collect(Collectors.toList());
        activityChangeUserInfoPo.setUserIdList(collect);
        activityChangeUserInfoPo.setChangeId(reqBo.getChangeId());
        List<ActivityChangeUserInfoPO> activityChangeUserInfoPoList = this.activityChangeUserInfoMapper.selectByConditionAll(activityChangeUserInfoPo);
        if (!CollectionUtils.isEmpty(activityChangeUserInfoPoList)) {
            collectMap = activityChangeUserInfoPoList.stream().collect(Collectors.toMap(ActivityChangeUserInfoPO::getUserId, o -> o));
        }
        for (DycActivityChangeUserInfo item : reqBo.getUserList()) {
            if (collectMap != null && collectMap.get(item.getActUserId()) != null) {
                ActivityChangeUserInfoPO activityChangeUserInfoPoUpdate = new ActivityChangeUserInfoPO();
                activityChangeUserInfoPoUpdate.setDelFlag(ActConstants.DelFlag.NOT_DEL);
                ActivityChangeUserInfoPO activityChangeUserInfoPoUpdateWhere = new ActivityChangeUserInfoPO();
                activityChangeUserInfoPoUpdateWhere.setId(collectMap.get(item.getActUserId()).getId());
                this.activityChangeUserInfoMapper.updateBy(activityChangeUserInfoPoUpdate, activityChangeUserInfoPoUpdateWhere);
                continue;
            }
            ActivityChangeUserInfoPO changeUser = new ActivityChangeUserInfoPO();
            BeanUtils.copyProperties((Object)item, (Object)changeUser);
            changeUser.setId(Sequence.getInstance().nextId());
            changeUser.setChangeId(reqBo.getChangeId());
            changeUser.setCreateUserId(reqBo.getCreateUserId());
            changeUser.setCreateUserName(reqBo.getCreateUserName());
            changeUser.setId(Sequence.getInstance().nextId());
            changeUser.setDelFlag(0);
            changeUser.setCreateTime(new Date());
            changeUser.setUserId(item.getActUserId());
            changeUser.setUserName(item.getActUserName());
            changeUser.setName(item.getActName());
            changeUser.setWorkNo(item.getActWorkNo());
            changeUser.setUserOrgId(item.getActUserOrgId());
            changeUser.setUserOrgName(item.getActUserOrgName());
            changeUser.setUpdateUserId(null);
            changeUser.setUpdateUserName(null);
            changeUser.setUpdateTime(null);
            changeUser.setUserCompanyId(item.getActUserCompanyId());
            changeUser.setUserCompanyName(item.getActUserCompanyName());
            changeUser.setUserOrgPath(item.getActUserOrgPath());
            changeUserInfoPoList.add(changeUser);
        }
        if (!CollectionUtils.isEmpty(changeUserInfoPoList) && (i = this.activityChangeUserInfoMapper.allInsert(changeUserInfoPoList)) != changeUserInfoPoList.size()) {
            throw new ZTBusinessException("\u53d8\u66f4\u7528\u6237\u6279\u91cf\u6dfb\u52a0\u5931\u8d25\uff01");
        }
    }

    public BasePageRspBo<ActivityChangeUserInfo> queryActivityChangeUserPageList(ActivityChangeUserInfoQryBO reqBo) {
        Page page;
        ActivityChangeUserInfoPO selectActivityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)selectActivityChangeUserInfoPo);
        ArrayList<ActivityChangeUserInfo> activityChangeUserInfoBoList = new ArrayList<ActivityChangeUserInfo>();
        BasePageRspBo rspPage = new BasePageRspBo();
        rspPage.setRespCode("0000");
        rspPage.setRespDesc("\u6210\u529f");
        if (reqBo.getPageNo() == -1 && reqBo.getPageSize() == -1) {
            rspPage.setPageNo(1);
            List<ActivityChangeUserInfoPO> list = this.activityChangeUserInfoMapper.selectByCondition(selectActivityChangeUserInfoPo);
            if (!CollectionUtils.isEmpty(list)) {
                this.makeChangeUserData(list, activityChangeUserInfoBoList);
                rspPage.setRows(activityChangeUserInfoBoList);
                rspPage.setRecordsTotal(activityChangeUserInfoBoList.size());
                rspPage.setTotal(1);
            } else {
                rspPage.setTotal(0);
                rspPage.setRecordsTotal(0);
            }
            rspPage.setRows(activityChangeUserInfoBoList);
        }
        if (!CollectionUtils.isEmpty((Collection)(page = PageHelper.startPage((int)reqBo.getPageNo(), (int)reqBo.getPageSize()).doSelectPage(() -> this.activityChangeUserInfoMapper.selectByCondition(selectActivityChangeUserInfoPo))).getResult())) {
            this.makeChangeUserData(page.getResult(), activityChangeUserInfoBoList);
        }
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityChangeUserInfoBoList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    private void makeChangeUserData(List<ActivityChangeUserInfoPO> list, List<ActivityChangeUserInfo> activityChangeUserInfoBoList) {
        for (ActivityChangeUserInfoPO activityChangeUserInfoPo : list) {
            ActivityChangeUserInfo activityChangeUserInfoBo = new ActivityChangeUserInfo();
            BeanUtils.copyProperties((Object)activityChangeUserInfoPo, (Object)activityChangeUserInfoBo);
            activityChangeUserInfoBo.setPhone(DesensitizedUtil.mobilePhone((String)activityChangeUserInfoBo.getPhone()));
            activityChangeUserInfoBoList.add(activityChangeUserInfoBo);
        }
    }

    public int batchRemoveActivityChangeUser(DycActivityChangeDO reqBo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)activityChangeUserInfoPo);
        activityChangeUserInfoPo.setUpdateTime(new Date());
        int i = this.activityChangeUserInfoMapper.updateBatchByUserId(reqBo.getUserIdList(), activityChangeUserInfoPo);
        if (i != reqBo.getUserIdList().size()) {
            throw new ZTBusinessException("\u5f53\u524d\u7528\u6237\u5df2\u6709\u4f7f\u7528\u79ef\u5206\uff0c\u4e0d\u53ef\u8fdb\u884c\u79fb\u9664\uff01");
        }
        return i;
    }

    public List<ActivityChangeUserInfo> queryChangeActivityUserList(DycActivityChangeDO dycActivityChangeDO) {
        ActivityChangeUserInfoPO activityChangeUserInfoPO = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPO.setChangeId(dycActivityChangeDO.getChangeId());
        if (!CollectionUtils.isEmpty((Collection)dycActivityChangeDO.getUserIdList())) {
            activityChangeUserInfoPO.setUserIdList(dycActivityChangeDO.getUserIdList());
        }
        List<ActivityChangeUserInfoPO> activityChangeUserInfoPOS = this.activityChangeUserInfoMapper.selectByCondition(activityChangeUserInfoPO);
        return JSON.parseArray((String)JSON.toJSONString(activityChangeUserInfoPOS), ActivityChangeUserInfo.class);
    }

    public int addChangeUser(DycActivityChangeDO dycActivityUserInfo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPO = (ActivityChangeUserInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)dycActivityUserInfo), ActivityChangeUserInfoPO.class);
        activityChangeUserInfoPO.setCreateTime(new Date());
        activityChangeUserInfoPO.setId(Sequence.getInstance().nextId());
        activityChangeUserInfoPO.setDelFlag(0);
        activityChangeUserInfoPO.setUserId(dycActivityUserInfo.getActUserId());
        activityChangeUserInfoPO.setUserName(dycActivityUserInfo.getActUserName());
        activityChangeUserInfoPO.setName(dycActivityUserInfo.getActName());
        activityChangeUserInfoPO.setWorkNo(dycActivityUserInfo.getActWorkNo());
        return this.activityChangeUserInfoMapper.insert(activityChangeUserInfoPO);
    }

    public void batchModifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDo) {
        BigDecimal balanceScores;
        ActivityChangeUserInfoPO activityChangeUserInfoPoModel;
        ActivityChangeUserInfoPO activityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPo.setChangeId(dycActivityChangeDo.getChangeId());
        if (dycActivityChangeDo.getUserId() != null) {
            activityChangeUserInfoPo.setUserId(dycActivityChangeDo.getUserId());
        }
        if ((activityChangeUserInfoPoModel = this.activityChangeUserInfoMapper.selectByConditionModel(activityChangeUserInfoPo)) == null) {
            throw new ZTBusinessException("\u6ca1\u6709\u9700\u8981\u4fee\u6539\u7684\u7528\u6237");
        }
        if (activityChangeUserInfoPoModel.getOriginalScores() != null) {
            balanceScores = activityChangeUserInfoPoModel.getOriginalScores().subtract(dycActivityChangeDo.getGiveScores());
            if (activityChangeUserInfoPoModel.getUsedScores() != null) {
                balanceScores = balanceScores.subtract(activityChangeUserInfoPoModel.getUsedScores());
            }
        } else {
            balanceScores = dycActivityChangeDo.getGiveScores();
        }
        if (balanceScores.compareTo(BigDecimal.ZERO) < 0) {
            throw new ZTBusinessException("\u79ef\u5206\u5206\u914d\u5931\u8d25\uff0c\u5269\u4f59\u91d1\u989d\u5c0f\u4e8e0");
        }
        ActivityChangeUserInfoPO activityChangeUserInfoPoUpdate = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPoUpdate.setId(activityChangeUserInfoPoModel.getId());
        activityChangeUserInfoPoUpdate.setBalanceScores(balanceScores);
        activityChangeUserInfoPoUpdate.setGiveScores(dycActivityChangeDo.getGiveScores());
        activityChangeUserInfoPoUpdate.setUpdateUserId(dycActivityChangeDo.getUpdateUserId());
        activityChangeUserInfoPoUpdate.setUpdateUserName(dycActivityChangeDo.getUpdateUserName());
        activityChangeUserInfoPoUpdate.setUpdateTime(new Date());
        this.activityChangeUserInfoMapper.update(activityChangeUserInfoPoUpdate);
    }

    public void batchModifyIntegralZeroClearance(DycActivityChangeDO dycActivityChangeDo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPo = (ActivityChangeUserInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dycActivityChangeDo), ActivityChangeUserInfoPO.class);
        this.activityChangeUserInfoMapper.batchModifyIntegralZeroClearance(activityChangeUserInfoPo);
    }

    public DycActivityChangeDO qryUserInfoLimitScore(DycActivityChangeDO dycActivityChangeDo) {
        DycActivityChangeDO dycActivityChangeDoModel = new DycActivityChangeDO();
        ActivityChangeUserInfoPO po = new ActivityChangeUserInfoPO();
        po.setChangeId(dycActivityChangeDo.getChangeId());
        po.setLimitScores(this.LIMIT_SCORES);
        ActivityChangeUserInfoPO activityChangeUserInfoPo = this.activityChangeUserInfoMapper.qryUserInfoLimitScore(po);
        if (activityChangeUserInfoPo == null) {
            dycActivityChangeDoModel.setLimitFlag(Boolean.valueOf(false));
            dycActivityChangeDoModel.setLimitFlagMessage(null);
        } else {
            dycActivityChangeDoModel.setLimitFlag(Boolean.valueOf(true));
            dycActivityChangeDoModel.setLimitFlagMessage("\u7528\u6237" + activityChangeUserInfoPo.getName() + "\u53d1\u653e\u7684\u79ef\u5206\u6570\u8d85" + this.LIMIT_SCORES + "\u4e86\uff0c\u8bf7\u786e\u8ba4\u6b63\u786e\u53d1\u653e\uff01");
        }
        return dycActivityChangeDoModel;
    }

    public void update(DycActivityChangeUserInfo dycActivityChangeUserInfo) {
        ActivityChangeUserInfoPO changeUser = (ActivityChangeUserInfoPO)ActRu.js((Object)dycActivityChangeUserInfo, ActivityChangeUserInfoPO.class);
        changeUser.setUserId(dycActivityChangeUserInfo.getActUserId());
        changeUser.setUserName(dycActivityChangeUserInfo.getActUserName());
        changeUser.setName(dycActivityChangeUserInfo.getActName());
        changeUser.setWorkNo(dycActivityChangeUserInfo.getActWorkNo());
        changeUser.setUserOrgId(dycActivityChangeUserInfo.getActUserOrgId());
        changeUser.setUserOrgName(dycActivityChangeUserInfo.getActUserOrgName());
        changeUser.setUserCompanyId(dycActivityChangeUserInfo.getActUserCompanyId());
        changeUser.setUserCompanyName(dycActivityChangeUserInfo.getActUserCompanyName());
        changeUser.setUserOrgPath(dycActivityChangeUserInfo.getActUserOrgPath());
        this.activityChangeUserInfoMapper.update(changeUser);
    }

    public List<ActivityChangeUserInfo> queryChangeActivityUserListAll(DycActivityChangeDO dycActivityChangeDO) {
        ActivityChangeUserInfoPO activityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPo.setChangeId(dycActivityChangeDO.getChangeId());
        if (!CollectionUtils.isEmpty((Collection)dycActivityChangeDO.getUserIdList())) {
            activityChangeUserInfoPo.setUserIdList(dycActivityChangeDO.getUserIdList());
        }
        List<ActivityChangeUserInfoPO> changeUserInfoPoList = this.activityChangeUserInfoMapper.selectByConditionAll(activityChangeUserInfoPo);
        return JSON.parseArray((String)JSON.toJSONString(changeUserInfoPoList), ActivityChangeUserInfo.class);
    }

    public int insertNew(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO insert = (ActivityChangeUserInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeUserInfoPO.class);
        return this.activityChangeUserInfoMapper.insertNew(insert);
    }

    public int updateByNew(DycActivityChangeUserInfo set, DycActivityChangeUserInfo where) {
        ActivityChangeUserInfoPO setPo = (ActivityChangeUserInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)set), ActivityChangeUserInfoPO.class);
        ActivityChangeUserInfoPO wherePo = (ActivityChangeUserInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)where), ActivityChangeUserInfoPO.class);
        return this.activityChangeUserInfoMapper.updateBy(setPo, wherePo);
    }

    public int getCheckByNew(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO insert = (ActivityChangeUserInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeUserInfoPO.class);
        return this.activityChangeUserInfoMapper.getCheckBy(insert);
    }

    public DycActivityChangeUserInfo getModelByNew(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO qryBo = (ActivityChangeUserInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeUserInfoPO.class);
        ActivityChangeUserInfoPO modelBy = this.activityChangeUserInfoMapper.getModelBy(qryBo);
        return (DycActivityChangeUserInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)modelBy), DycActivityChangeUserInfo.class);
    }

    public List<DycActivityChangeUserInfo> getListNew(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO qryBo = (ActivityChangeUserInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeUserInfoPO.class);
        List<ActivityChangeUserInfoPO> list = this.activityChangeUserInfoMapper.getList(qryBo);
        return JSONObject.parseArray((String)JSONObject.toJSONString(list), DycActivityChangeUserInfo.class);
    }

    public void insertBatchNew(List<DycActivityChangeUserInfo> list) {
        List listPo = JSONObject.parseArray((String)JSONObject.toJSONString(list), ActivityChangeUserInfoPO.class);
        this.activityChangeUserInfoMapper.insertBatch(listPo);
    }
}

