/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.DycActActivityApproveBaseInfo;
import com.tydic.dyc.act.model.bo.DycActiveBaseInfoSaveReqBO;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.repository.api.DycActActivityRepository;
import com.tydic.dyc.act.repository.dao.ActivityBaseInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoPO;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoTimePO;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class DycActActivityRepositoryImpl
implements DycActActivityRepository {
    private static final Logger log = LoggerFactory.getLogger(DycActActivityRepositoryImpl.class);
    @Autowired
    private ActivityBaseInfoMapper activityBaseInfoMapper;

    public BasePageRspBo<DycActivityBaseInfo> queryActivityPageList(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPO = new ActivityBaseInfoPO();
        BasePageRspBo rspPage = new BasePageRspBo();
        BeanUtils.copyProperties((Object)reqBO, (Object)selectActivityBaseInfoPO);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activityBaseInfoMapper.selectByTabId(selectActivityBaseInfoPO));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspPage.setRespCode("0000");
            rspPage.setRespDesc("\u6210\u529f");
            return rspPage;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<DycActivityBaseInfo> activityBaseInfoBOList = new ArrayList<DycActivityBaseInfo>();
        for (ActivityBaseInfoPO activityBaseInfoPO : page.getResult()) {
            DycActivityBaseInfo activityBaseInfoBO = new DycActivityBaseInfo();
            BeanUtils.copyProperties((Object)activityBaseInfoPO, (Object)activityBaseInfoBO);
            activityBaseInfoBO.setInvoiceClassStr(DycActivityTransFieldUtil.InvoiceClass((String)String.valueOf(activityBaseInfoBO.getInvoiceClass())));
            activityBaseInfoBO.setInvoiceTypeStr(DycActivityTransFieldUtil.ActivityType((String)String.valueOf(activityBaseInfoBO.getInvoiceType())));
            activityBaseInfoBO.setActivityTypeStr(DycActivityTransFieldUtil.ActivityType((String)String.valueOf(activityBaseInfoBO.getActivityType())));
            activityBaseInfoBO.setActivityPayModeStr(DycActivityTransFieldUtil.ActivityPayMode((String)String.valueOf(activityBaseInfoBO.getActivityPayMode())));
            activityBaseInfoBO.setActivityStateStr(DycActivityTransFieldUtil.ActivityState((String)activityBaseInfoBO.getActivityState()));
            activityBaseInfoBO.setCommodityRelaMethodStr(DycActivityTransFieldUtil.CommodityRelaMethodSTR((String)String.valueOf(activityBaseInfoBO.getCommodityRelaMethod())));
            String startTime = sdf.format(activityBaseInfoPO.getActivityStartTime());
            String endTime = sdf.format(activityBaseInfoPO.getActivityEndTime());
            activityBaseInfoBO.setActivityStartToEndTime(startTime + "-" + endTime);
            activityBaseInfoBO.setActivitySyncStateStr(DycActivityTransFieldUtil.ActivitySyncState((String)String.valueOf(activityBaseInfoPO.getActivitySyncState())));
            activityBaseInfoBOList.add(activityBaseInfoBO);
        }
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityBaseInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        rspPage.setRespCode("0000");
        rspPage.setRespDesc("\u6210\u529f");
        return rspPage;
    }

    public List<DycActivityBaseInfo> queryActivityList(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPo = new ActivityBaseInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)selectActivityBaseInfoPo);
        List<ActivityBaseInfoPO> activityBaseInfoPoList = this.activityBaseInfoMapper.selectByCondition(selectActivityBaseInfoPo);
        ArrayList<DycActivityBaseInfo> activityBaseInfoBOList = new ArrayList<DycActivityBaseInfo>();
        if (CollectionUtils.isEmpty(activityBaseInfoPoList)) {
            return new ArrayList<DycActivityBaseInfo>();
        }
        for (ActivityBaseInfoPO activityBaseInfoPo : activityBaseInfoPoList) {
            DycActivityBaseInfo activityBaseInfoBo = new DycActivityBaseInfo();
            BeanUtils.copyProperties((Object)activityBaseInfoPo, (Object)activityBaseInfoBo);
            activityBaseInfoBo.setActivityStateStr(DycActivityTransFieldUtil.ActivityState((String)activityBaseInfoPo.getActivityState()));
            activityBaseInfoBo.setActivityTypeStr(DycActivityTransFieldUtil.ActivityType((String)String.valueOf(activityBaseInfoPo.getActivityType())));
            activityBaseInfoBo.setActivityPayModeStr(DycActivityTransFieldUtil.ActivityPayMode((String)String.valueOf(activityBaseInfoPo.getActivityPayMode())));
            activityBaseInfoBo.setCommodityRelaMethodStr(DycActivityTransFieldUtil.CommodityRelaMethodSTR((String)String.valueOf(activityBaseInfoPo.getCommodityRelaMethod())));
            activityBaseInfoBOList.add(activityBaseInfoBo);
        }
        return activityBaseInfoBOList;
    }

    public DycActivityBaseInfo saveActiveBaseInfo(DycActiveBaseInfoSaveReqBO reqBO) {
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        if (null == reqBO.getActivityId()) {
            ActivityBaseInfoPO insertBO = new ActivityBaseInfoPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)insertBO);
            insertBO.setActivityId(Sequence.getInstance().nextId());
            insertBO.setActivityVersion(1);
            insertBO.setActivityState("1");
            insertBO.setDelFlag(0);
            insertBO.setCreateTime(new Date());
            this.activityBaseInfoMapper.insert(insertBO);
            rspBO.setActivityId(insertBO.getActivityId());
        } else {
            ActivityBaseInfoPO baseInfoPO = new ActivityBaseInfoPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)baseInfoPO);
            this.activityBaseInfoMapper.update(baseInfoPO);
        }
        return rspBO;
    }

    public int changeActivityState(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getActivityState())) {
            throw new ZTBusinessException("\u6d3b\u52a8\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActivityBaseInfoPO activityBaseInfoPO = (ActivityBaseInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        activityBaseInfoPO.setUpdateTime(new Date());
        return this.activityBaseInfoMapper.update(activityBaseInfoPO);
    }

    public int deleteActivity(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActivityBaseInfoPO infoPO = new ActivityBaseInfoPO();
        infoPO.setActivityId(reqBO.getActivityId());
        List<ActivityBaseInfoPO> infoPOS = this.activityBaseInfoMapper.selectByCondition(infoPO);
        if (!"1".equals(infoPOS.get(0).getActivityState()) && !"3".equals(infoPOS.get(0).getActivityState())) {
            throw new ZTBusinessException("\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        ActivityBaseInfoPO activityBaseInfoPO = (ActivityBaseInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        activityBaseInfoPO.setUpdateTime(new Date());
        return this.activityBaseInfoMapper.deleteActivity(activityBaseInfoPO);
    }

    public int autoEffectActivity(DycActivityDO reqBO) {
        ActivityBaseInfoPO activityBaseInfoPO = new ActivityBaseInfoPO();
        List<ActivityBaseInfoPO> list = this.activityBaseInfoMapper.selectAutoEffectActivity(activityBaseInfoPO);
        if (list.size() < 1) {
            return 0;
        }
        for (ActivityBaseInfoPO baseInfoPO : list) {
            baseInfoPO.setUpdateTime(new Date());
            baseInfoPO.setActivityState("5");
        }
        return this.activityBaseInfoMapper.batchUpdate(list);
    }

    public DycActivityBaseInfo autoLoseEffectActivity(DycActivityDO reqBO) {
        List<ActivityBaseInfoPO> activityBaseInfoPOS = this.activityBaseInfoMapper.autoLoseEffectActivity();
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        if (CollectionUtils.isEmpty(activityBaseInfoPOS)) {
            return rspBO;
        }
        activityBaseInfoPOS.forEach(item -> {
            item.setActivityState(String.valueOf(7));
            item.setUpdateTime(new Date());
        });
        this.activityBaseInfoMapper.batchUpdate(activityBaseInfoPOS);
        return rspBO;
    }

    public BasePageRspBo<DycActActivityApproveBaseInfo> queryActivityApprovePageList(DycProcessDO reqBO) {
        BasePageRspBo rspBo = new BasePageRspBo();
        ActivityBaseInfoTimePO activityBaseInfoTimePO = (ActivityBaseInfoTimePO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityBaseInfoTimePO.class);
        List status = DycActivityTransFieldUtil.TaskStatus((String)activityBaseInfoTimePO.getTabId());
        activityBaseInfoTimePO.setPendingAuditUserId(reqBO.getUserId());
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activityBaseInfoMapper.queryActivityApprovePageList(activityBaseInfoTimePO, status));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        List activityBaseInfoBOList = JSON.parseArray((String)JSON.toJSONString((Object)page.getResult()), DycActActivityApproveBaseInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(activityBaseInfoBOList);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int)page.getTotal());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public int updateActivityState(DycActivityDO reqBO) {
        ActivityBaseInfoPO infoPO = new ActivityBaseInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)infoPO);
        infoPO.setUpdateTime(new Date());
        return this.activityBaseInfoMapper.update(infoPO);
    }

    public DycActivityBaseInfo getActivityBaseInfoDetail(DycActivityDO dycActivityDO) {
        ActivityBaseInfoPO qryInfoPo = (ActivityBaseInfoPO)JUtil.js((Object)dycActivityDO, ActivityBaseInfoPO.class);
        ActivityBaseInfoPO activityBaseInfoPo = this.activityBaseInfoMapper.getActivityBaseInfoDetail(qryInfoPo);
        DycActivityBaseInfo dycActivityBaseInfo = null;
        if (activityBaseInfoPo != null) {
            dycActivityBaseInfo = (DycActivityBaseInfo)JUtil.js((Object)activityBaseInfoPo, DycActivityBaseInfo.class);
        }
        return dycActivityBaseInfo;
    }

    public DycActivityBaseInfo qryActiveBaseInfo(DycActivityDO reqBo) {
        ActivityBaseInfoPO infoPo = new ActivityBaseInfoPO();
        infoPo.setActivityId(reqBo.getActivityId());
        ActivityBaseInfoPO activityBaseInfoPo = this.activityBaseInfoMapper.qryActiveBaseInfo(infoPo);
        return (DycActivityBaseInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)activityBaseInfoPo), DycActivityBaseInfo.class);
    }

    public void insert(DycActiveBaseInfoSaveReqBO reqBo) {
        ActivityBaseInfoPO activityBaseInfoPo = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityBaseInfoPO.class);
        this.activityBaseInfoMapper.insert(activityBaseInfoPo);
    }

    public int insertNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityChangeInfoPo = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        return this.activityBaseInfoMapper.insertNew(activityChangeInfoPo);
    }

    public int updateByNew(DycActivityBaseInfo set, DycActivityBaseInfo where) {
        ActivityBaseInfoPO activityBaseInfoPoSet = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)set), ActivityBaseInfoPO.class);
        ActivityBaseInfoPO activityBaseInfoPoWhere = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)where), ActivityBaseInfoPO.class);
        return this.activityBaseInfoMapper.updateBy(activityBaseInfoPoSet, activityBaseInfoPoWhere);
    }

    public int getCheckByNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityChangeInfoPo = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        return this.activityBaseInfoMapper.getCheckBy(activityChangeInfoPo);
    }

    public DycActivityBaseInfo getModelByNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityBaseInfoPo = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        ActivityBaseInfoPO modelBy = this.activityBaseInfoMapper.getModelBy(activityBaseInfoPo);
        return (DycActivityBaseInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)modelBy), DycActivityBaseInfo.class);
    }

    public List<DycActivityBaseInfo> getListNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityBaseInfoPo = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        List<ActivityBaseInfoPO> list = this.activityBaseInfoMapper.getList(activityBaseInfoPo);
        return JSONObject.parseArray((String)JSONObject.toJSONString(list), DycActivityBaseInfo.class);
    }

    public void insertBatchNew(List<DycActivityBaseInfo> list) {
        List listPo = JSONObject.parseArray((String)JSONObject.toJSONString(list), ActivityBaseInfoPO.class);
        this.activityBaseInfoMapper.insertBatch(listPo);
    }
}

