/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActUpdateAlertInfo;
import com.tydic.dyc.act.model.bo.DycActDealOrderAlertDO;
import com.tydic.dyc.act.repository.api.DycActAlertInfoRepository;
import com.tydic.dyc.act.repository.dao.ActAlertInfoMapper;
import com.tydic.dyc.act.repository.po.ActAlertInfoPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycActAlertInfoRepositoryImpl
implements DycActAlertInfoRepository {
    @Autowired
    private ActAlertInfoMapper actAlertInfoMapper;

    public int saveAlertInfo(DycActDealOrderAlertDO reqBO) {
        List<ActAlertInfoPO> actAlertInfoPOS = new ArrayList<ActAlertInfoPO>();
        if (StringUtils.isNotBlank((String)reqBO.getOrderId())) {
            ActAlertInfoPO po = new ActAlertInfoPO();
            po.setId(Sequence.getInstance().nextId());
            po.setObjId(reqBO.getOrderId());
            po.setObjType(reqBO.getObjType());
            po.setAlertType(reqBO.getAlertType());
            po.setAlertState(reqBO.getAlertState());
            po.setCreateTime(new Date());
            actAlertInfoPOS.add(po);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            actAlertInfoPOS = reqBO.getOrderIds().stream().map(orderId -> {
                ActAlertInfoPO po = new ActAlertInfoPO();
                po.setId(Sequence.getInstance().nextId());
                po.setObjId((String)orderId);
                po.setObjType(reqBO.getObjType());
                po.setAlertType(reqBO.getAlertType());
                po.setAlertState(reqBO.getAlertState());
                po.setCreateTime(new Date());
                return po;
            }).collect(Collectors.toList());
        }
        return this.actAlertInfoMapper.allInsert(actAlertInfoPOS);
    }

    public int updateAlertInfo(DycActDealOrderAlertDO reqBO) {
        ActAlertInfoPO record = new ActAlertInfoPO();
        record.setAlertState(reqBO.getAlertState());
        record.setIds(reqBO.getUpdAlertInfoList().stream().map(ActUpdateAlertInfo::getId).collect(Collectors.toList()));
        return this.actAlertInfoMapper.batchUpdate(record);
    }
}

