/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceAmt;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceAmtDO;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceDO;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceInfo;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceItemDO;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceItemInfo;
import com.tydic.dyc.act.model.bo.DycActFscOrderInvoiceInfo;
import com.tydic.dyc.act.model.bo.DycActivityFileInfo;
import com.tydic.dyc.act.repository.api.DycActFscInvoiceRepository;
import com.tydic.dyc.act.repository.dao.ActFscInvoiceItemMapper;
import com.tydic.dyc.act.repository.dao.ActFscInvoiceMapper;
import com.tydic.dyc.act.repository.dao.ActFscOrderInvoiceMapper;
import com.tydic.dyc.act.repository.dao.ActivityFileInfoMapper;
import com.tydic.dyc.act.repository.po.ActFscInvoiceItemPO;
import com.tydic.dyc.act.repository.po.ActFscInvoicePO;
import com.tydic.dyc.act.repository.po.ActFscOrderInvoicePO;
import com.tydic.dyc.act.repository.po.ActivityFileInfoPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycActFscInvoiceRepositoryImpl
implements DycActFscInvoiceRepository {
    @Autowired
    private ActFscInvoiceItemMapper actFscInvoiceItemMapper;
    @Autowired
    private ActFscInvoiceMapper actFscInvoiceMapper;
    @Autowired
    private ActivityFileInfoMapper activityFileInfoMapper;
    @Autowired
    private ActFscOrderInvoiceMapper actFscOrderInvoiceMapper;

    public BasePageRspBo<DycActFscInvoiceItemInfo> qryInvoiceItemList(DycActFscInvoiceDO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        ActFscInvoiceItemPO record = new ActFscInvoiceItemPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        record.setInvoiceId(reqBO.getInvoiceId());
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.actFscInvoiceItemMapper.selectByCondition(record));
        ArrayList<DycActFscInvoiceItemInfo> fscInvoiceItemInfos = new ArrayList<DycActFscInvoiceItemInfo>();
        for (ActFscInvoiceItemPO invoiceItemPO : page.getResult()) {
            DycActFscInvoiceItemInfo dycActFscInvoiceItemInfo = new DycActFscInvoiceItemInfo();
            BeanUtils.copyProperties((Object)invoiceItemPO, (Object)dycActFscInvoiceItemInfo);
            dycActFscInvoiceItemInfo.setOrderId(invoiceItemPO.getOrderId().toString());
            dycActFscInvoiceItemInfo.setUnitName(invoiceItemPO.getUnit());
            fscInvoiceItemInfos.add(dycActFscInvoiceItemInfo);
        }
        BasePageRspBo rspPage = new BasePageRspBo();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(fscInvoiceItemInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    public DycActFscInvoiceInfo getInvoiceInfoByInvoiceNo(DycActFscInvoiceDO reqBO) {
        ActFscInvoicePO record = new ActFscInvoicePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        ActFscInvoicePO result = this.actFscInvoiceMapper.selectOneByCondition(record);
        return (DycActFscInvoiceInfo)JSON.parseObject((String)JSON.toJSONString((Object)result), DycActFscInvoiceInfo.class);
    }

    public BasePageRspBo<DycActFscInvoiceInfo> qryInvoiceList(DycActFscInvoiceDO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        ActFscInvoicePO record = new ActFscInvoicePO();
        record.setFscOrderId(reqBO.getFscOrderId());
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.actFscInvoiceMapper.selectByCondition(record));
        ArrayList<DycActFscInvoiceInfo> fscInvoiceInfos = new ArrayList<DycActFscInvoiceInfo>();
        for (ActFscInvoicePO invoicePO : page.getResult()) {
            DycActFscInvoiceInfo dycActFscInvoiceItemInfo = new DycActFscInvoiceInfo();
            BeanUtils.copyProperties((Object)invoicePO, (Object)dycActFscInvoiceItemInfo);
            fscInvoiceInfos.add(dycActFscInvoiceItemInfo);
        }
        BasePageRspBo rspPage = new BasePageRspBo();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(fscInvoiceInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    public List<DycActFscInvoiceAmt> getInvoiceAmtByFscOrderIds(DycActFscInvoiceAmtDO reqBO) {
        return this.actFscInvoiceMapper.getInvoiceAmtByFscOrderIds(reqBO);
    }

    public DycActFscInvoiceInfo getSumAmtByFscOrderId(DycActFscInvoiceDO reqBO) {
        ActFscInvoicePO actFscInvoicePO = new ActFscInvoicePO();
        actFscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        ActFscInvoicePO actFscInvoiceResult = this.actFscInvoiceMapper.getSumAmtByFscOrderId(actFscInvoicePO);
        return (DycActFscInvoiceInfo)JUtil.js((Object)actFscInvoiceResult, DycActFscInvoiceInfo.class);
    }

    public void deleteFscInvoice(DycActFscInvoiceDO reqBO) {
        ActFscInvoicePO record = new ActFscInvoicePO();
        record.setFscOrderId(reqBO.getFscOrderId());
        List<ActFscInvoicePO> actFscInvoicePOS = this.actFscInvoiceMapper.selectByCondition(record);
        if (!CollectionUtils.isEmpty(actFscInvoicePOS)) {
            List<Long> invoiceIds = actFscInvoicePOS.stream().map(ActFscInvoicePO::getInvoiceId).collect(Collectors.toList());
            ActivityFileInfoPO activityFileInfoPO = new ActivityFileInfoPO();
            activityFileInfoPO.setObjIds(invoiceIds);
            this.activityFileInfoMapper.delete(activityFileInfoPO);
            this.actFscInvoiceMapper.delete(record);
        }
        ActFscInvoiceItemPO itemRecord = new ActFscInvoiceItemPO();
        itemRecord.setFscOrderId(reqBO.getFscOrderId());
        List<ActFscInvoiceItemPO> actFscInvoiceItemPOS = this.actFscInvoiceItemMapper.selectByCondition(itemRecord);
        if (!CollectionUtils.isEmpty(actFscInvoiceItemPOS)) {
            this.actFscInvoiceItemMapper.delete(itemRecord);
        }
    }

    public void saveFscInvoices(DycActFscInvoiceDO reqBO) {
        ActFscOrderInvoicePO record = new ActFscOrderInvoicePO();
        record.setFscOrderId(reqBO.getFscOrderId());
        List<ActFscOrderInvoicePO> actFscOrderInvoicePOS = this.actFscOrderInvoiceMapper.selectByCondition(record);
        DycActFscOrderInvoiceInfo orderInvoiceInfo = (DycActFscOrderInvoiceInfo)JUtil.js((Object)actFscOrderInvoicePOS.get(0), DycActFscOrderInvoiceInfo.class);
        ArrayList<ActivityFileInfoPO> activityFileInfoPOS = new ArrayList<ActivityFileInfoPO>();
        List<ActFscInvoicePO> collect = reqBO.getDycActFscInvoiceListInfos().stream().map(item -> {
            ActFscInvoicePO actFscInvoicePO = new ActFscInvoicePO();
            BeanUtils.copyProperties((Object)item, (Object)actFscInvoicePO);
            actFscInvoicePO.setInvoiceId(Sequence.getInstance().nextId());
            actFscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
            actFscInvoicePO.setDelFlag(0);
            actFscInvoicePO.setBuyName(orderInvoiceInfo.getBuyName());
            actFscInvoicePO.setTaxNo(orderInvoiceInfo.getTaxNo());
            actFscInvoicePO.setAddress(orderInvoiceInfo.getAddress());
            actFscInvoicePO.setPhone(orderInvoiceInfo.getPhone());
            actFscInvoicePO.setBank(orderInvoiceInfo.getBank());
            actFscInvoicePO.setAccount(orderInvoiceInfo.getAccount());
            actFscInvoicePO.setInvoiceType(orderInvoiceInfo.getInvoiceType());
            actFscInvoicePO.setInvoiceCategory(orderInvoiceInfo.getInvoiceCategory());
            actFscInvoicePO.setInvoiceItemFlag(DycActivityConstants.FscInvoiceItemFlag.NO);
            actFscInvoicePO.setCreateTime(new Date());
            if (!CollectionUtils.isEmpty((Collection)item.getFileInfoList())) {
                for (DycActivityFileInfo fileInfo : item.getFileInfoList()) {
                    ActivityFileInfoPO fileInfoPO = new ActivityFileInfoPO();
                    fileInfoPO.setObjId(actFscInvoicePO.getInvoiceId());
                    fileInfoPO.setFileId(Sequence.getInstance().nextId());
                    fileInfoPO.setFileName(fileInfo.getFileName());
                    fileInfoPO.setFileUrl(fileInfo.getFileUrl());
                    fileInfoPO.setFileType("2");
                    fileInfoPO.setObjType(5);
                    fileInfoPO.setDelFlag(0);
                    activityFileInfoPOS.add(fileInfoPO);
                }
            }
            return actFscInvoicePO;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            this.actFscInvoiceMapper.allInsert(collect);
        }
        if (!CollectionUtils.isEmpty(activityFileInfoPOS)) {
            this.activityFileInfoMapper.allInsert(activityFileInfoPOS);
        }
    }

    public void deleteFscInvoiceItem(DycActFscInvoiceItemDO reqBO) {
        ActFscInvoiceItemPO itemRecord = new ActFscInvoiceItemPO();
        itemRecord.setFscOrderId(reqBO.getFscOrderId());
        itemRecord.setInvoiceId(reqBO.getInvoiceId());
        List<ActFscInvoiceItemPO> actFscInvoiceItemPOS = this.actFscInvoiceItemMapper.selectByCondition(itemRecord);
        if (!CollectionUtils.isEmpty(actFscInvoiceItemPOS)) {
            this.actFscInvoiceItemMapper.delete(itemRecord);
        }
    }

    public void saveFscInvoicesItem(DycActFscInvoiceItemDO reqBO) {
        List<ActFscInvoiceItemPO> collect = reqBO.getInvoiceItemList().stream().map(item -> {
            ActFscInvoiceItemPO actFscInvoiceItemPO = new ActFscInvoiceItemPO();
            BeanUtils.copyProperties((Object)item, (Object)actFscInvoiceItemPO);
            actFscInvoiceItemPO.setId(Sequence.getInstance().nextId());
            actFscInvoiceItemPO.setFscOrderId(reqBO.getFscOrderId());
            return actFscInvoiceItemPO;
        }).collect(Collectors.toList());
        this.actFscInvoiceItemMapper.allInsert(collect);
    }

    public int updateFscInvoiceFlag(DycActFscInvoiceItemDO reqBO) {
        ActFscInvoicePO record = new ActFscInvoicePO();
        record.setInvoiceItemFlag(DycActivityConstants.FscInvoiceItemFlag.YES);
        record.setInvoiceId(reqBO.getInvoiceId());
        record.setFscOrderId(reqBO.getFscOrderId());
        return this.actFscInvoiceMapper.update(record);
    }

    public int getCountUnGetItem(DycActFscInvoiceItemDO reqBO) {
        ActFscInvoicePO record = new ActFscInvoicePO();
        record.setFscOrderId(reqBO.getFscOrderId());
        record.setInvoiceItemFlag(reqBO.getInvoiceItemFlag());
        return this.actFscInvoiceMapper.getCountUnGetItem(record);
    }
}

