/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.dyc.act.model.bo.DycActFscOrderBatchInfoDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderQryDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderRelationDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderRelationInfo;
import com.tydic.dyc.act.model.bo.DycActFscOrderSaveDO;
import com.tydic.dyc.act.repository.api.DycActFscOrderRelationRepository;
import com.tydic.dyc.act.repository.dao.ActFscOrderBatchInfoMapper;
import com.tydic.dyc.act.repository.dao.ActFscOrderRelationHisMapper;
import com.tydic.dyc.act.repository.dao.ActFscOrderRelationMapper;
import com.tydic.dyc.act.repository.po.ActFscOrderBatchInfoPO;
import com.tydic.dyc.act.repository.po.ActFscOrderRelationHisPO;
import com.tydic.dyc.act.repository.po.ActFscOrderRelationPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycActFscOrderRelationRepositoryImpl
implements DycActFscOrderRelationRepository {
    @Autowired
    private ActFscOrderRelationMapper actFscOrderRelationMapper;
    @Autowired
    private ActFscOrderRelationHisMapper actFscOrderRelationHisMapper;
    @Autowired
    private ActFscOrderBatchInfoMapper actFscOrderBatchInfoMapper;

    public int getFscOrderNum(DycActFscOrderDO reqBO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        return this.actFscOrderRelationMapper.getFscOrderNum(record);
    }

    public int deleteFscOrdRelation(DycActFscOrderDO reqBO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        return this.actFscOrderRelationMapper.delete(record);
    }

    public int saveFscOrdRelationHis(DycActFscOrderDO reqBO) {
        ActFscOrderRelationHisPO record = new ActFscOrderRelationHisPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        return this.actFscOrderRelationHisMapper.insertHisData(record);
    }

    public int saveFscOrdRelation(DycActFscOrderSaveDO reqBO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        record.setActivityId(reqBO.getActivityId());
        return this.actFscOrderRelationMapper.insertSelectData(record);
    }

    public BasePageRspBo<DycActFscOrderRelationInfo> getFscOrderRelationList(DycActFscOrderQryDO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.actFscOrderRelationMapper.selectByCondition(record));
        List fscOrderInfos = page.getResult().stream().map(po -> {
            DycActFscOrderRelationInfo dycActFscOrderInfo = new DycActFscOrderRelationInfo();
            BeanUtils.copyProperties((Object)po, (Object)dycActFscOrderInfo);
            return dycActFscOrderInfo;
        }).collect(Collectors.toList());
        BasePageRspBo rspPage = new BasePageRspBo();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(fscOrderInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    public int updateRelationBatch(DycActFscOrderRelationDO reqBO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        record.setOrderIds(reqBO.getOrderIds());
        record.setFscOrderId(reqBO.getFscOrderId());
        record.setBatchId(reqBO.getBatchId());
        return this.actFscOrderRelationMapper.updateBatchId(record);
    }

    public int saveBatchInfo(DycActFscOrderBatchInfoDO reqBO) {
        ActFscOrderBatchInfoPO record = new ActFscOrderBatchInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        return this.actFscOrderBatchInfoMapper.insert(record);
    }

    public int updateBatchInfo(DycActFscOrderBatchInfoDO reqBO) {
        ActFscOrderBatchInfoPO record = new ActFscOrderBatchInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setPushInfo(reqBO.getFailInfo());
        return this.actFscOrderBatchInfoMapper.update(record);
    }

    public List<DycActFscOrderRelationInfo> getFscOrdRelationList(DycActFscOrderBatchInfoDO reqBO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        List<ActFscOrderRelationPO> orderRelationPOS = this.actFscOrderRelationMapper.selectByCondition(record);
        List<DycActFscOrderRelationInfo> fscOrderInfos = orderRelationPOS.stream().map(po -> {
            DycActFscOrderRelationInfo dycActFscOrderInfo = new DycActFscOrderRelationInfo();
            BeanUtils.copyProperties((Object)po, (Object)dycActFscOrderInfo);
            return dycActFscOrderInfo;
        }).collect(Collectors.toList());
        return fscOrderInfos;
    }

    public BigDecimal getCurrentAmt(DycActFscOrderBatchInfoDO reqBO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        return this.actFscOrderRelationMapper.getCurrentAmt(record);
    }
}

