/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.dyc.act.model.bo.ActAlertAfsOrderInfo;
import com.tydic.dyc.act.model.bo.ActAlertOrderInfo;
import com.tydic.dyc.act.model.bo.DycActDealAlertQryOrderDO;
import com.tydic.dyc.act.model.bo.DycActDealOrderAlertDO;
import com.tydic.dyc.act.model.bo.DycActOrderAfsInfo;
import com.tydic.dyc.act.model.bo.DycActOrderAfsQryDO;
import com.tydic.dyc.act.model.bo.DycActOrderInfo;
import com.tydic.dyc.act.model.bo.DycActOrderQryDO;
import com.tydic.dyc.act.repository.api.DycActOrderInfoRepository;
import com.tydic.dyc.act.repository.dao.ActOrderAfterInfoMapper;
import com.tydic.dyc.act.repository.dao.ActOrderInfoMapper;
import com.tydic.dyc.act.repository.dao.ActOrderInfoMapperUni;
import com.tydic.dyc.act.repository.po.ActOrderAfsUniInfo;
import com.tydic.dyc.act.repository.po.ActOrderAfterInfoPO;
import com.tydic.dyc.act.repository.po.ActOrderInfoPO;
import com.tydic.dyc.act.repository.po.ActOrderUniInfo;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycActOrderInfoRepositoryImpl
implements DycActOrderInfoRepository {
    @Autowired
    private ActOrderInfoMapperUni actOrderInfoMapperUni;
    @Autowired
    private ActOrderInfoMapper actOrderInfoMapper;
    @Autowired
    private ActOrderAfterInfoMapper actOrderAfterInfoMapper;

    public BasePageRspBo<DycActOrderInfo> qryOrdInfoPageList(DycActOrderQryDO dycActOrderQryDO) {
        if (dycActOrderQryDO.getPageNo() < 1) {
            dycActOrderQryDO.setPageNo(1);
        }
        if (dycActOrderQryDO.getPageSize() < 1) {
            dycActOrderQryDO.setPageSize(10);
        }
        Page page = PageHelper.startPage((int)dycActOrderQryDO.getPageNo(), (int)dycActOrderQryDO.getPageSize()).doSelectPage(() -> this.actOrderInfoMapperUni.selectOrdInfoPageByCond(dycActOrderQryDO));
        ArrayList<DycActOrderInfo> actOrderInfoBOList = new ArrayList<DycActOrderInfo>();
        for (ActOrderUniInfo actOrderInfoPO : page.getResult()) {
            DycActOrderInfo actOrderInfoBO = new DycActOrderInfo();
            BeanUtils.copyProperties((Object)actOrderInfoPO, (Object)actOrderInfoBO);
            actOrderInfoBOList.add(actOrderInfoBO);
        }
        BasePageRspBo rspPage = new BasePageRspBo();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actOrderInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    public BasePageRspBo<DycActOrderAfsInfo> qryOrdAfsInfoPageList(DycActOrderAfsQryDO dycActOrderAfsQryDO) {
        if (dycActOrderAfsQryDO.getPageNo() < 1) {
            dycActOrderAfsQryDO.setPageNo(1);
        }
        if (dycActOrderAfsQryDO.getPageSize() < 1) {
            dycActOrderAfsQryDO.setPageSize(10);
        }
        Page page = PageHelper.startPage((int)dycActOrderAfsQryDO.getPageNo(), (int)dycActOrderAfsQryDO.getPageSize()).doSelectPage(() -> this.actOrderInfoMapperUni.selectOrdAfsInfoPageByCond(dycActOrderAfsQryDO));
        ArrayList<DycActOrderAfsInfo> actOrderAfsInfoBOList = new ArrayList<DycActOrderAfsInfo>();
        for (ActOrderAfsUniInfo actOrderAfsInfoPO : page.getResult()) {
            DycActOrderAfsInfo actOrderAfsInfoBO = new DycActOrderAfsInfo();
            BeanUtils.copyProperties((Object)actOrderAfsInfoPO, (Object)actOrderAfsInfoBO);
            actOrderAfsInfoBO.setAfsOrderId(actOrderAfsInfoPO.getAfsServiceId());
            actOrderAfsInfoBO.setAfsDetailUrl(actOrderAfsInfoPO.getAfDetailUrl());
            actOrderAfsInfoBO.setCreateTime(actOrderAfsInfoPO.getAfsApplyTime());
            actOrderAfsInfoBO.setServState(actOrderAfsInfoPO.getAfsStep().toString());
            actOrderAfsInfoBO.setServStateStr(actOrderAfsInfoPO.getAfsStepName());
            actOrderAfsInfoBO.setServType(actOrderAfsInfoPO.getServType().toString());
            actOrderAfsInfoBO.setServTypeStr(actOrderAfsInfoPO.getServTypeName());
            actOrderAfsInfoBO.setReceiveTime(actOrderAfsInfoBO.getReceiveTime());
            actOrderAfsInfoBOList.add(actOrderAfsInfoBO);
        }
        BasePageRspBo rspPage = new BasePageRspBo();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actOrderAfsInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    public BigDecimal getTotalScoreByActivityId(Long activityId) {
        return this.actOrderInfoMapper.getTotalScoreByActivityId(activityId);
    }

    public List<String> qryAlertOrderList(DycActDealAlertQryOrderDO reqBO) {
        ActOrderInfoPO record = new ActOrderInfoPO();
        record.setOrderState(reqBO.getOrderState());
        record.setDayNum(reqBO.getDayNum());
        if (StringUtils.isNotBlank((String)reqBO.getOrderId())) {
            record.setOrderId(reqBO.getOrderId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            record.setOrderIds(reqBO.getOrderIds());
        }
        if ("1".equals(reqBO.getAlertFlag())) {
            return this.actOrderInfoMapper.qryUnSendOrderList(record);
        }
        if ("2".equals(reqBO.getAlertFlag())) {
            return this.actOrderInfoMapper.qryUnReceiveOrderList(record);
        }
        return null;
    }

    public void updateOrderAlertType(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        ActOrderInfoPO record = new ActOrderInfoPO();
        record.setOrderId(dycActDealOrderAlertDO.getOrderId());
        record.setOrderIds(dycActDealOrderAlertDO.getOrderIds());
        record.setAlertType(dycActDealOrderAlertDO.getAlertType());
        this.actOrderInfoMapper.updateAlertType(record);
    }

    public List<ActAlertOrderInfo> qryExistAlertOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        return this.actOrderInfoMapperUni.qryExistAlertOrderList(dycActDealAlertQryOrderDO);
    }

    public List<String> qryAlertAfsOrderList(DycActDealAlertQryOrderDO reqBO) {
        ActOrderAfterInfoPO record = new ActOrderAfterInfoPO();
        if (StringUtils.isNotBlank((String)reqBO.getAfsServiceId())) {
            record.setAfsServiceId(reqBO.getAfsServiceId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAfsServiceIds())) {
            record.setAfsServiceIds(reqBO.getAfsServiceIds());
        }
        record.setDayNum(reqBO.getDayNum());
        return this.actOrderAfterInfoMapper.qryUnRespOrderList(record);
    }

    public void updateAfsOrderAlertType(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        ActOrderAfterInfoPO record = new ActOrderAfterInfoPO();
        record.setAfsServiceId(dycActDealOrderAlertDO.getOrderId());
        record.setAfsServiceIds(dycActDealOrderAlertDO.getOrderIds());
        record.setAlertType(dycActDealOrderAlertDO.getAlertType());
        this.actOrderAfterInfoMapper.updateAlertType(record);
    }

    public List<ActAlertAfsOrderInfo> qryExistAlertAfsOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        return this.actOrderInfoMapperUni.qryExistAlertAfsOrderList(dycActDealAlertQryOrderDO);
    }
}

