/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.ActConstants;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.DycActActivityApproveBaseInfo;
import com.tydic.dyc.act.model.bo.DycActiveBaseInfoSaveReqBO;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.repository.api.DycActActivityRepository;
import com.tydic.dyc.act.repository.dao.ActivityBaseInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoPO;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoTimePO;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class DycActActivityRepositoryImpl
implements DycActActivityRepository {
    private static final Logger log = LoggerFactory.getLogger(DycActActivityRepositoryImpl.class);
    @Autowired
    private ActivityBaseInfoMapper activityBaseInfoMapper;
    @Value(value="${yYLastPayTime:59}")
    private String yYLastPayTime;
    private static final Integer OPER_TYPE_CHANGE = 2;
    private static final Integer OPER_TYPE = 1;

    public BasePageRspBo<DycActivityBaseInfo> queryActivityPageList(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPO = new ActivityBaseInfoPO();
        BasePageRspBo rspPage = new BasePageRspBo();
        BeanUtils.copyProperties((Object)reqBO, (Object)selectActivityBaseInfoPO);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activityBaseInfoMapper.selectByTabId(selectActivityBaseInfoPO));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspPage.setRespCode("0000");
            rspPage.setRespDesc("\u6210\u529f");
            return rspPage;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdfStr = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<DycActivityBaseInfo> activityBaseInfoBOList = new ArrayList<DycActivityBaseInfo>();
        for (ActivityBaseInfoPO activityBaseInfoPO : page.getResult()) {
            DycActivityBaseInfo activityBaseInfoBO = new DycActivityBaseInfo();
            BeanUtils.copyProperties((Object)activityBaseInfoPO, (Object)activityBaseInfoBO);
            activityBaseInfoBO.setInvoiceClassStr(DycActivityTransFieldUtil.InvoiceClass((String)String.valueOf(activityBaseInfoBO.getInvoiceClass())));
            activityBaseInfoBO.setInvoiceTypeStr(DycActivityTransFieldUtil.ActivityType((String)String.valueOf(activityBaseInfoBO.getInvoiceType())));
            activityBaseInfoBO.setActivityTypeStr(DycActivityTransFieldUtil.ActivityType((String)String.valueOf(activityBaseInfoBO.getActivityType())));
            activityBaseInfoBO.setActivityPayModeStr(DycActivityTransFieldUtil.ActivityPayMode((String)String.valueOf(activityBaseInfoBO.getActivityPayMode())));
            activityBaseInfoBO.setActivityStateStr(DycActivityTransFieldUtil.ActivityState((String)activityBaseInfoBO.getActivityState()));
            activityBaseInfoBO.setCommodityRelaMethodStr(DycActivityTransFieldUtil.CommodityRelaMethodSTR((String)String.valueOf(activityBaseInfoBO.getCommodityRelaMethod())));
            String startTime = sdf.format(activityBaseInfoPO.getActivityStartTime());
            String endTime = sdf.format(activityBaseInfoPO.getActivityEndTime());
            activityBaseInfoBO.setActivityStartToEndTime(startTime + "-" + endTime);
            activityBaseInfoBO.setActivitySyncStateStr(DycActivityTransFieldUtil.ActivitySyncState((String)String.valueOf(activityBaseInfoPO.getActivitySyncState())));
            if (null != activityBaseInfoPO.getLastPayTime()) {
                activityBaseInfoBO.setLastPayTimeStr(sdfStr.format(activityBaseInfoPO.getLastPayTime()));
            }
            if (null != activityBaseInfoPO.getYyLastPayTime()) {
                activityBaseInfoBO.setYyLastPayTimeStr(sdfStr.format(activityBaseInfoPO.getYyLastPayTime()));
            }
            activityBaseInfoBOList.add(activityBaseInfoBO);
        }
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityBaseInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        rspPage.setRespCode("0000");
        rspPage.setRespDesc("\u6210\u529f");
        return rspPage;
    }

    public List<DycActivityBaseInfo> queryActivityList(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPo = new ActivityBaseInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)selectActivityBaseInfoPo);
        List<ActivityBaseInfoPO> activityBaseInfoPoList = this.activityBaseInfoMapper.selectByCondition(selectActivityBaseInfoPo);
        ArrayList<DycActivityBaseInfo> activityBaseInfoBOList = new ArrayList<DycActivityBaseInfo>();
        if (CollectionUtils.isEmpty(activityBaseInfoPoList)) {
            return new ArrayList<DycActivityBaseInfo>();
        }
        for (ActivityBaseInfoPO activityBaseInfoPo : activityBaseInfoPoList) {
            DycActivityBaseInfo activityBaseInfoBo = new DycActivityBaseInfo();
            BeanUtils.copyProperties((Object)activityBaseInfoPo, (Object)activityBaseInfoBo);
            activityBaseInfoBo.setActivityStateStr(DycActivityTransFieldUtil.ActivityState((String)activityBaseInfoPo.getActivityState()));
            activityBaseInfoBo.setActivityTypeStr(DycActivityTransFieldUtil.ActivityType((String)String.valueOf(activityBaseInfoPo.getActivityType())));
            activityBaseInfoBo.setActivityPayModeStr(DycActivityTransFieldUtil.ActivityPayMode((String)String.valueOf(activityBaseInfoPo.getActivityPayMode())));
            activityBaseInfoBo.setCommodityRelaMethodStr(DycActivityTransFieldUtil.CommodityRelaMethodSTR((String)String.valueOf(activityBaseInfoPo.getCommodityRelaMethod())));
            activityBaseInfoBOList.add(activityBaseInfoBo);
        }
        return activityBaseInfoBOList;
    }

    public DycActivityBaseInfo saveActiveBaseInfo(DycActiveBaseInfoSaveReqBO reqBO) {
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        if (null == reqBO.getActivityId()) {
            ActivityBaseInfoPO insertBO = new ActivityBaseInfoPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)insertBO);
            insertBO.setActivityId(Sequence.getInstance().nextId());
            insertBO.setActivityVersion(1);
            insertBO.setActivityState("1");
            insertBO.setDelFlag(0);
            insertBO.setCreateTime(new Date());
            insertBO.setCreateCompanyId(reqBO.getCompanyId());
            insertBO.setCreateCompanyName(reqBO.getCompanyName());
            insertBO.setCreateOrgId(reqBO.getOrgId());
            insertBO.setCreateOrgName(reqBO.getOrgName());
            insertBO.setCreateOrgTreePath(reqBO.getOrgTreePathIn());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(reqBO.getActivityStartTime());
            calendar.add(5, Integer.parseInt(this.yYLastPayTime));
            Date later = calendar.getTime();
            insertBO.setYyLastPayTime(later);
            if (StringUtils.hasText((String)reqBO.getJnPayDay())) {
                Calendar calendarLast = Calendar.getInstance();
                calendar.setTime(insertBO.getYyLastPayTime());
                calendarLast.add(5, -Integer.parseInt(reqBO.getJnPayDay()));
                Date laterLast = calendar.getTime();
                insertBO.setLastPayTime(laterLast);
            }
            this.activityBaseInfoMapper.insert(insertBO);
            rspBO.setActivityId(insertBO.getActivityId());
        } else {
            ActivityBaseInfoPO baseInfoPO = new ActivityBaseInfoPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)baseInfoPO);
            baseInfoPO.setCreateUserId(null);
            baseInfoPO.setCreateUserName(null);
            baseInfoPO.setCreateOrgId(null);
            baseInfoPO.setCreateCompanyId(null);
            baseInfoPO.setCreateOrgTreePath(null);
            baseInfoPO.setCreateOrgName(null);
            baseInfoPO.setCreateCompanyName(null);
            baseInfoPO.setUpdateTime(new Date());
            baseInfoPO.setUpdateUserId(reqBO.getCreateUserId());
            baseInfoPO.setUpdateUserName(reqBO.getCreateUserName());
            this.activityBaseInfoMapper.update(baseInfoPO);
        }
        return rspBO;
    }

    public int changeActivityState(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getActivityState())) {
            throw new ZTBusinessException("\u6d3b\u52a8\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActivityBaseInfoPO activityBaseInfoPO = (ActivityBaseInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        activityBaseInfoPO.setUpdateTime(new Date());
        return this.activityBaseInfoMapper.update(activityBaseInfoPO);
    }

    public int deleteActivity(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActivityBaseInfoPO infoPO = new ActivityBaseInfoPO();
        infoPO.setActivityId(reqBO.getActivityId());
        List<ActivityBaseInfoPO> infoPOS = this.activityBaseInfoMapper.selectByCondition(infoPO);
        if (!"1".equals(infoPOS.get(0).getActivityState()) && !"3".equals(infoPOS.get(0).getActivityState())) {
            throw new ZTBusinessException("\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        ActivityBaseInfoPO activityBaseInfoPO = (ActivityBaseInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        activityBaseInfoPO.setUpdateTime(new Date());
        return this.activityBaseInfoMapper.deleteActivity(activityBaseInfoPO);
    }

    public List<Long> autoEffectActivity(DycActivityDO reqBO) {
        ActivityBaseInfoPO activityBaseInfoPO = new ActivityBaseInfoPO();
        Date now = new Date();
        activityBaseInfoPO.setActivityState("4");
        activityBaseInfoPO.setActivitySyncState(DycActivityConstants.ActivitySyncState.SUCCESS);
        activityBaseInfoPO.setActivityEndTimeStart(now);
        activityBaseInfoPO.setActivityStartTimeEnd(now);
        activityBaseInfoPO.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        List<ActivityBaseInfoPO> list = this.activityBaseInfoMapper.getList(activityBaseInfoPO);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<Long>(0);
        }
        for (ActivityBaseInfoPO baseInfoPO : list) {
            baseInfoPO.setUpdateTime(new Date());
            baseInfoPO.setUpdateUserId(1L);
            baseInfoPO.setUpdateUserName("\u7cfb\u7edf\u81ea\u52a8");
            baseInfoPO.setActivityState("5");
        }
        try {
            this.activityBaseInfoMapper.batchUpdate(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseBusinessException("8888", "\u4fee\u6539\u6d3b\u52a8\u72b6\u6001\u4e3a\u5df2\u751f\u6548\u5931\u8d25\uff01");
        }
        return list.stream().map(ActivityBaseInfoPO::getActivityId).distinct().collect(Collectors.toList());
    }

    public DycActivityBaseInfo autoLoseEffectActivity(DycActivityDO reqBO) {
        ActivityBaseInfoPO activityBaseInfoPO = new ActivityBaseInfoPO();
        activityBaseInfoPO.setActivityEndTimeEnd(new Date());
        activityBaseInfoPO.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        activityBaseInfoPO.setActivityStateList(Arrays.asList("5", "6"));
        List<ActivityBaseInfoPO> activityBaseInfoPOS = this.activityBaseInfoMapper.getList(activityBaseInfoPO);
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        if (CollectionUtils.isEmpty(activityBaseInfoPOS)) {
            return rspBO;
        }
        activityBaseInfoPOS.forEach(item -> {
            if (item.getActivityCycleType() == null || DycActivityConstants.ActivityCycleType.FINITUDE.equals(item.getActivityCycleType())) {
                item.setActivityState("7");
                item.setUpdateUserId(1L);
                item.setUpdateUserName("\u7cfb\u7edf\u81ea\u52a8");
                item.setUpdateTime(new Date());
            }
        });
        this.activityBaseInfoMapper.batchUpdate(activityBaseInfoPOS);
        return rspBO;
    }

    public BasePageRspBo<DycActActivityApproveBaseInfo> queryActivityApprovePageList(DycProcessDO reqBO) {
        BasePageRspBo rspBo = new BasePageRspBo();
        ActivityBaseInfoTimePO activityBaseInfoTimePO = (ActivityBaseInfoTimePO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityBaseInfoTimePO.class);
        List status = DycActivityTransFieldUtil.TaskStatus((String)activityBaseInfoTimePO.getTabId());
        activityBaseInfoTimePO.setPendingAuditUserId(reqBO.getUserId());
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activityBaseInfoMapper.queryActivityApprovePageList(activityBaseInfoTimePO, status));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        List activityBaseInfoBOList = JSON.parseArray((String)JSON.toJSONString((Object)page.getResult()), DycActActivityApproveBaseInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(activityBaseInfoBOList);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int)page.getTotal());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public int updateActivityState(DycActivityDO reqBO) {
        Date date = new Date();
        ActivityBaseInfoPO infoPO = new ActivityBaseInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)infoPO);
        infoPO.setUpdateTime(date);
        if (ActConstants.SyncState.SUCCESS.equals(reqBO.getActivitySyncState())) {
            ActivityBaseInfoPO modelBy = this.getActivityBaseInfoPo(reqBO);
            this.dealState(reqBO, date, infoPO, modelBy);
        }
        return this.activityBaseInfoMapper.update(infoPO);
    }

    private void dealState(DycActivityDO reqBO, Date date, ActivityBaseInfoPO infoPO, ActivityBaseInfoPO modelBy) {
        if (OPER_TYPE.equals(reqBO.getOperTypeSync()) && date.compareTo(modelBy.getActivityEndTime()) <= 0 && date.compareTo(modelBy.getActivityStartTime()) >= 0) {
            infoPO.setActivityState("5");
        } else if (OPER_TYPE_CHANGE.equals(reqBO.getOperTypeSync()) && date.compareTo(modelBy.getActivityEndTime()) <= 0 && date.compareTo(modelBy.getActivityStartTime()) >= 0) {
            infoPO.setActivityState("5");
        } else if (OPER_TYPE_CHANGE.equals(reqBO.getOperTypeSync()) && date.compareTo(modelBy.getActivityEndTime()) > 0) {
            infoPO.setActivityState("7");
        }
    }

    private ActivityBaseInfoPO getActivityBaseInfoPo(DycActivityDO reqBO) {
        ActivityBaseInfoPO activityBaseInfoPo = new ActivityBaseInfoPO();
        activityBaseInfoPo.setActivityId(reqBO.getActivityId());
        ActivityBaseInfoPO modelBy = this.activityBaseInfoMapper.getModelBy(activityBaseInfoPo);
        if (modelBy == null) {
            throw new BaseBusinessException("8888", "\u67e5\u8be2\u6d3b\u52a8\u5355\u636e\u4e3a\u7a7a\uff01");
        }
        return modelBy;
    }

    public DycActivityBaseInfo getActivityBaseInfoDetail(DycActivityDO dycActivityDO) {
        ActivityBaseInfoPO qryInfoPo = (ActivityBaseInfoPO)JUtil.js((Object)dycActivityDO, ActivityBaseInfoPO.class);
        ActivityBaseInfoPO activityBaseInfoPo = this.activityBaseInfoMapper.getActivityBaseInfoDetail(qryInfoPo);
        DycActivityBaseInfo dycActivityBaseInfo = null;
        if (activityBaseInfoPo != null) {
            dycActivityBaseInfo = (DycActivityBaseInfo)JUtil.js((Object)activityBaseInfoPo, DycActivityBaseInfo.class);
        }
        return dycActivityBaseInfo;
    }

    public DycActivityBaseInfo qryActiveBaseInfo(DycActivityDO reqBo) {
        ActivityBaseInfoPO infoPo = new ActivityBaseInfoPO();
        infoPo.setActivityId(reqBo.getActivityId());
        ActivityBaseInfoPO activityBaseInfoPo = this.activityBaseInfoMapper.qryActiveBaseInfo(infoPo);
        return (DycActivityBaseInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)activityBaseInfoPo), DycActivityBaseInfo.class);
    }

    public void insert(DycActiveBaseInfoSaveReqBO reqBo) {
        ActivityBaseInfoPO activityBaseInfoPo = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityBaseInfoPO.class);
        this.activityBaseInfoMapper.insert(activityBaseInfoPo);
    }

    public int insertNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityChangeInfoPo = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        return this.activityBaseInfoMapper.insertNew(activityChangeInfoPo);
    }

    public int updateByNew(DycActivityBaseInfo set, DycActivityBaseInfo where) {
        ActivityBaseInfoPO activityBaseInfoPoSet = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)set), ActivityBaseInfoPO.class);
        ActivityBaseInfoPO activityBaseInfoPoWhere = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)where), ActivityBaseInfoPO.class);
        return this.activityBaseInfoMapper.updateBy(activityBaseInfoPoSet, activityBaseInfoPoWhere);
    }

    public int getCheckByNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityChangeInfoPo = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        return this.activityBaseInfoMapper.getCheckBy(activityChangeInfoPo);
    }

    public DycActivityBaseInfo getModelByNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityBaseInfoPo = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        ActivityBaseInfoPO modelBy = this.activityBaseInfoMapper.getModelBy(activityBaseInfoPo);
        return (DycActivityBaseInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)modelBy), DycActivityBaseInfo.class);
    }

    public List<DycActivityBaseInfo> getListNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityBaseInfoPo = (ActivityBaseInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        List<ActivityBaseInfoPO> list = this.activityBaseInfoMapper.getList(activityBaseInfoPo);
        return JSONObject.parseArray((String)JSONObject.toJSONString(list), DycActivityBaseInfo.class);
    }

    public void insertBatchNew(List<DycActivityBaseInfo> list) {
        List listPo = JSONObject.parseArray((String)JSONObject.toJSONString(list), ActivityBaseInfoPO.class);
        this.activityBaseInfoMapper.insertBatch(listPo);
    }
}

