/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfo;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfoAddBatchBO;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfoDeleteBatchBO;
import com.tydic.dyc.act.repository.api.DycActActivitySupplierRepository;
import com.tydic.dyc.act.repository.dao.ActivitySupplierInfoMapper;
import com.tydic.dyc.act.repository.dao.ActivitySupplierPoolMapper;
import com.tydic.dyc.act.repository.po.ActivitySupplierInfoPO;
import com.tydic.dyc.act.repository.po.ActivitySupplierPoolPO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycActActivitySupplierRepositoryImpl
implements DycActActivitySupplierRepository {
    @Autowired
    private ActivitySupplierInfoMapper activitySupplierInfoMapper;
    @Autowired
    private ActivitySupplierPoolMapper activitySupplierPoolMapper;

    public BasePageRspBo<DycActivitySupplierInfo> queryActivityUnselectSupplierPageList(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BasePageRspBo rspBo = new BasePageRspBo();
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activitySupplierPoolMapper.queryActivityUnselectSupplierPageList(reqBO.getSupplierIds()));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        rspBo.setRows(JSON.parseArray((String)JSON.toJSONString((Object)page.getResult()), DycActivitySupplierInfo.class));
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int)page.getTotal());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public DycActivitySupplierInfo addBatchActiveSupplier(DycActivitySupplierInfoAddBatchBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u6dfb\u52a0\u4f9b\u5e94\u5546\u6570\u636e\u4e3a\u7a7a\u6216\u8005\u6d3b\u52a8id\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSupplierList())) {
            throw new ZTBusinessException("\u6dfb\u52a0\u4f9b\u5e94\u5546,\u4f9b\u5e94\u5546\u4e3a\u7a7a\uff01");
        }
        List<ActivitySupplierInfoPO> collect = reqBO.getSupplierList().stream().map(item -> {
            ActivitySupplierInfoPO activitySupplierInfoPO = new ActivitySupplierInfoPO();
            item.setId(Long.valueOf(Sequence.getInstance().nextId()));
            BeanUtils.copyProperties((Object)item, (Object)activitySupplierInfoPO);
            activitySupplierInfoPO.setActivityId(reqBO.getActivityId());
            return activitySupplierInfoPO;
        }).collect(Collectors.toList());
        int i = this.activitySupplierInfoMapper.allInsert(collect);
        if (i != reqBO.getSupplierList().size()) {
            throw new ZTBusinessException("\u6d3b\u52a8\u4f9b\u5e94\u5546\u63d2\u5165\u5931\u8d25\uff01");
        }
        DycActivitySupplierInfo rspBO = new DycActivitySupplierInfo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public DycActivitySupplierInfo deleteActiveSupplier(DycActivitySupplierInfoDeleteBatchBO reqBO) {
        ActivitySupplierInfoPO infoPO = new ActivitySupplierInfoPO();
        infoPO.setActivityId(reqBO.getActivityId());
        this.activitySupplierInfoMapper.delete(infoPO);
        return new DycActivitySupplierInfo();
    }

    public DycActivitySupplierInfo deleteBatchActiveSupplier(DycActivitySupplierInfoDeleteBatchBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO) || CollectionUtils.isEmpty((Collection)reqBO.getSupplierIdList()) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u5220\u9664\u4f9b\u5e94\u5546\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        this.activitySupplierInfoMapper.deleteBatchByActivityId(reqBO.getSupplierIdList(), reqBO.getActivityId());
        DycActivitySupplierInfo rspBO = new DycActivitySupplierInfo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public BasePageRspBo<DycActivitySupplierInfo> queryActiveSupplierList(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BasePageRspBo rspBo = new BasePageRspBo();
        ActivitySupplierInfoPO activitySupplierInfoPO = new ActivitySupplierInfoPO();
        activitySupplierInfoPO.setActivityId(reqBO.getActivityId());
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activitySupplierInfoMapper.selectByCondition(activitySupplierInfoPO));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        rspBo.setRows(JSON.parseArray((String)JSON.toJSONString((Object)page.getResult()), DycActivitySupplierInfo.class));
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int)page.getTotal());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public List<DycActivitySupplierInfo> queryActiveSupplierAllList(DycActivityDO reqBO) {
        List<Object> rspList = new ArrayList<DycActivitySupplierInfo>();
        ActivitySupplierPoolPO activitySupplierInfoPO = new ActivitySupplierPoolPO();
        List<ActivitySupplierPoolPO> activitySupplierInfoPOS = this.activitySupplierPoolMapper.selectByCondition(activitySupplierInfoPO);
        if (activitySupplierInfoPOS.size() < 0) {
            return rspList;
        }
        rspList = JSON.parseArray((String)JSON.toJSONString(activitySupplierInfoPOS), DycActivitySupplierInfo.class);
        return rspList;
    }

    public int insertNew(DycActivitySupplierInfo reqBo) {
        ActivitySupplierInfoPO insert = (ActivitySupplierInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivitySupplierInfoPO.class);
        return this.activitySupplierInfoMapper.insertNew(insert);
    }

    public int updateByNew(DycActivitySupplierInfo set, DycActivitySupplierInfo where) {
        ActivitySupplierInfoPO setPo = (ActivitySupplierInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)set), ActivitySupplierInfoPO.class);
        ActivitySupplierInfoPO wherePo = (ActivitySupplierInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)where), ActivitySupplierInfoPO.class);
        return this.activitySupplierInfoMapper.updateBy(setPo, wherePo);
    }

    public int getCheckByNew(DycActivitySupplierInfo reqBo) {
        ActivitySupplierInfoPO insert = (ActivitySupplierInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivitySupplierInfoPO.class);
        return this.activitySupplierInfoMapper.getCheckBy(insert);
    }

    public DycActivitySupplierInfo getModelByNew(DycActivitySupplierInfo reqBo) {
        ActivitySupplierInfoPO qryBo = (ActivitySupplierInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivitySupplierInfoPO.class);
        ActivitySupplierInfoPO modelBy = this.activitySupplierInfoMapper.getModelBy(qryBo);
        return (DycActivitySupplierInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)modelBy), DycActivitySupplierInfo.class);
    }

    public List<DycActivitySupplierInfo> getListNew(DycActivitySupplierInfo reqBo) {
        ActivitySupplierInfoPO qryBo = (ActivitySupplierInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivitySupplierInfoPO.class);
        List<ActivitySupplierInfoPO> list = this.activitySupplierInfoMapper.getList(qryBo);
        return JSONObject.parseArray((String)JSONObject.toJSONString(list), DycActivitySupplierInfo.class);
    }

    public void insertBatchNew(List<DycActivitySupplierInfo> list) {
        List listPo = JSONObject.parseArray((String)JSONObject.toJSONString(list), ActivitySupplierInfoPO.class);
        this.activitySupplierInfoMapper.insertBatch(listPo);
    }

    public List<DycActivitySupplierInfo> batchQrySupplier(DycActivitySupplierInfo reqBo) {
        ActivitySupplierInfoPO qryBo = (ActivitySupplierInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivitySupplierInfoPO.class);
        return JSON.parseArray((String)JSON.toJSONString(this.activitySupplierInfoMapper.batchQrySupplier(qryBo)), DycActivitySupplierInfo.class);
    }
}

