/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.bo.ActAlertAfsOrderInfo;
import com.tydic.dyc.act.model.bo.ActAlertOrderInfo;
import com.tydic.dyc.act.model.bo.ActOrderAfterInfo;
import com.tydic.dyc.act.model.bo.ActOrderAfterItemDO;
import com.tydic.dyc.act.model.bo.ActOrderItemInfoDO;
import com.tydic.dyc.act.model.bo.DycActDealAlertQryOrderDO;
import com.tydic.dyc.act.model.bo.DycActDealOrderAlertDO;
import com.tydic.dyc.act.model.bo.DycActOrderAfsInfo;
import com.tydic.dyc.act.model.bo.DycActOrderAfsQryDO;
import com.tydic.dyc.act.model.bo.DycActOrderInfo;
import com.tydic.dyc.act.model.bo.DycActOrderQryDO;
import com.tydic.dyc.act.repository.api.DycActOrderInfoRepository;
import com.tydic.dyc.act.repository.dao.ActOrderAfterInfoMapper;
import com.tydic.dyc.act.repository.dao.ActOrderAfterItemMapper;
import com.tydic.dyc.act.repository.dao.ActOrderInfoMapper;
import com.tydic.dyc.act.repository.dao.ActOrderInfoMapperUni;
import com.tydic.dyc.act.repository.dao.ActOrderItemInfoMapper;
import com.tydic.dyc.act.repository.po.ActOrderAfsUniInfo;
import com.tydic.dyc.act.repository.po.ActOrderAfterInfoPO;
import com.tydic.dyc.act.repository.po.ActOrderAfterInfoQryPO;
import com.tydic.dyc.act.repository.po.ActOrderAfterItemPO;
import com.tydic.dyc.act.repository.po.ActOrderInfoPO;
import com.tydic.dyc.act.repository.po.ActOrderInfoQryPO;
import com.tydic.dyc.act.repository.po.ActOrderItemInfoPO;
import com.tydic.dyc.act.repository.po.ActOrderUniInfo;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycActOrderInfoRepositoryImpl
implements DycActOrderInfoRepository {
    @Autowired
    private ActOrderInfoMapperUni actOrderInfoMapperUni;
    @Autowired
    private ActOrderInfoMapper actOrderInfoMapper;
    @Autowired
    private ActOrderAfterInfoMapper actOrderAfterInfoMapper;
    @Autowired
    private ActOrderAfterItemMapper actOrderAfterItemMapper;
    @Autowired
    private ActOrderItemInfoMapper actOrderItemInfoMapper;

    public BasePageRspBo<DycActOrderInfo> qryOrdInfoPageList(DycActOrderQryDO dycActOrderQryDO) {
        if (dycActOrderQryDO.getPageNo() < 1) {
            dycActOrderQryDO.setPageNo(1);
        }
        if (dycActOrderQryDO.getPageSize() < 1) {
            dycActOrderQryDO.setPageSize(10);
        }
        Page page = "1".equals(dycActOrderQryDO.getQryCheckFlag()) ? PageHelper.startPage((int)dycActOrderQryDO.getPageNo(), (int)dycActOrderQryDO.getPageSize()).doSelectPage(() -> this.actOrderInfoMapperUni.selectOrdCheckInfoPageByCond(dycActOrderQryDO)) : PageHelper.startPage((int)dycActOrderQryDO.getPageNo(), (int)dycActOrderQryDO.getPageSize()).doSelectPage(() -> this.actOrderInfoMapperUni.selectOrdInfoPageByCond(dycActOrderQryDO));
        ArrayList<DycActOrderInfo> actOrderInfoBOList = new ArrayList<DycActOrderInfo>();
        for (ActOrderUniInfo actOrderInfoPO : page.getResult()) {
            DycActOrderInfo actOrderInfoBO = new DycActOrderInfo();
            BeanUtils.copyProperties((Object)actOrderInfoPO, (Object)actOrderInfoBO);
            actOrderInfoBO.setCheckState(actOrderInfoPO.getStatus());
            actOrderInfoBOList.add(actOrderInfoBO);
        }
        BasePageRspBo rspPage = new BasePageRspBo();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actOrderInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    public BasePageRspBo<DycActOrderAfsInfo> qryOrdAfsInfoPageList(DycActOrderAfsQryDO dycActOrderAfsQryDO) {
        if (dycActOrderAfsQryDO.getPageNo() < 1) {
            dycActOrderAfsQryDO.setPageNo(1);
        }
        if (dycActOrderAfsQryDO.getPageSize() < 1) {
            dycActOrderAfsQryDO.setPageSize(10);
        }
        Page page = PageHelper.startPage((int)dycActOrderAfsQryDO.getPageNo(), (int)dycActOrderAfsQryDO.getPageSize()).doSelectPage(() -> this.actOrderInfoMapperUni.selectOrdAfsInfoPageByCond(dycActOrderAfsQryDO));
        ArrayList<DycActOrderAfsInfo> actOrderAfsInfoBOList = new ArrayList<DycActOrderAfsInfo>();
        for (ActOrderAfsUniInfo actOrderAfsInfoPO : page.getResult()) {
            DycActOrderAfsInfo actOrderAfsInfoBO = new DycActOrderAfsInfo();
            BeanUtils.copyProperties((Object)actOrderAfsInfoPO, (Object)actOrderAfsInfoBO);
            actOrderAfsInfoBO.setAfsOrderId(actOrderAfsInfoPO.getAfsServiceId());
            actOrderAfsInfoBO.setAfsDetailUrl(actOrderAfsInfoPO.getAfDetailUrl());
            actOrderAfsInfoBO.setCreateTime(actOrderAfsInfoPO.getAfsApplyTime());
            actOrderAfsInfoBO.setServState(actOrderAfsInfoPO.getAfsStep().toString());
            actOrderAfsInfoBO.setServStateStr(actOrderAfsInfoPO.getAfsStepName());
            actOrderAfsInfoBO.setServType(actOrderAfsInfoPO.getServType().toString());
            actOrderAfsInfoBO.setServTypeStr(actOrderAfsInfoPO.getServTypeName());
            actOrderAfsInfoBO.setReceiveTime(actOrderAfsInfoBO.getReceiveTime());
            actOrderAfsInfoBOList.add(actOrderAfsInfoBO);
        }
        BasePageRspBo rspPage = new BasePageRspBo();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actOrderAfsInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    public BigDecimal getTotalScoreByActivityId(Long activityId) {
        return this.actOrderInfoMapper.getTotalScoreByActivityId(activityId);
    }

    public List<String> qryAlertOrderList(DycActDealAlertQryOrderDO reqBO) {
        ActOrderInfoPO updatePo = new ActOrderInfoPO();
        updatePo.setAlertType(Integer.parseInt(reqBO.getAlertFlag()));
        this.actOrderInfoMapper.clearAlertType(updatePo);
        ActOrderInfoPO record = new ActOrderInfoPO();
        record.setOrderState(reqBO.getOrderState());
        record.setDayNum(reqBO.getDayNum());
        if (StringUtils.isNotBlank((String)reqBO.getOrderId())) {
            record.setOrderId(reqBO.getOrderId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            record.setOrderIds(reqBO.getOrderIds());
        }
        if ("1".equals(reqBO.getAlertFlag())) {
            return this.actOrderInfoMapper.qryUnSendOrderList(record);
        }
        if ("2".equals(reqBO.getAlertFlag())) {
            return this.actOrderInfoMapper.qryUnReceiveOrderList(record);
        }
        return null;
    }

    public void updateOrderAlertType(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        ActOrderInfoPO record = new ActOrderInfoPO();
        record.setOrderId(dycActDealOrderAlertDO.getOrderId());
        record.setOrderIds(dycActDealOrderAlertDO.getOrderIds());
        record.setAlertType(dycActDealOrderAlertDO.getAlertType());
        this.actOrderInfoMapper.updateAlertType(record);
    }

    public List<ActAlertOrderInfo> qryExistAlertOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        return this.actOrderInfoMapperUni.qryExistAlertOrderList(dycActDealAlertQryOrderDO);
    }

    public List<String> qryAlertAfsOrderList(DycActDealAlertQryOrderDO reqBO) {
        ActOrderAfterInfoPO updatePo = new ActOrderAfterInfoPO();
        updatePo.setAlertType(Integer.parseInt(reqBO.getAlertFlag()));
        this.actOrderAfterInfoMapper.clearAlertType(updatePo);
        ActOrderAfterInfoPO record = new ActOrderAfterInfoPO();
        if (StringUtils.isNotBlank((String)reqBO.getAfsServiceId())) {
            record.setAfsServiceId(reqBO.getAfsServiceId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAfsServiceIds())) {
            record.setAfsServiceIds(reqBO.getAfsServiceIds());
        }
        record.setDayNum(reqBO.getDayNum());
        return this.actOrderAfterInfoMapper.qryUnRespOrderList(record);
    }

    public void updateAfsOrderAlertType(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        ActOrderAfterInfoPO record = new ActOrderAfterInfoPO();
        record.setAfsServiceId(dycActDealOrderAlertDO.getOrderId());
        record.setAfsServiceIds(dycActDealOrderAlertDO.getOrderIds());
        record.setAlertType(dycActDealOrderAlertDO.getAlertType());
        this.actOrderAfterInfoMapper.updateAlertType(record);
    }

    public List<ActAlertAfsOrderInfo> qryExistAlertAfsOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        return this.actOrderInfoMapperUni.qryExistAlertAfsOrderList(dycActDealAlertQryOrderDO);
    }

    public List<DycActOrderInfo> qryActSum(List<Long> reqBO) {
        if (CollectionUtils.isEmpty(reqBO)) {
            return new ArrayList<DycActOrderInfo>();
        }
        List<ActOrderInfoPO> infoPOS = this.actOrderInfoMapper.qryActSum(reqBO);
        return JSON.parseArray((String)JSON.toJSONString(infoPOS), DycActOrderInfo.class);
    }

    public List<DycActOrderInfo> getWarnIngOrderList(DycActDealAlertQryOrderDO dycActDealAlertQryOrderDO) {
        ActOrderInfoQryPO actOrderInfoQryPO = (ActOrderInfoQryPO)ActRu.js((Object)dycActDealAlertQryOrderDO, ActOrderInfoQryPO.class);
        List<ActOrderInfoPO> warnIngOrderList = this.actOrderInfoMapper.getWarnIngOrderList(actOrderInfoQryPO);
        return ActRu.jsl(warnIngOrderList, DycActOrderInfo.class);
    }

    public List<ActOrderAfterInfo> getOrderAfterWaring(DycActOrderAfsQryDO qryDO) {
        ActOrderAfterInfoQryPO qryPO = (ActOrderAfterInfoQryPO)ActRu.js((Object)qryDO, ActOrderAfterInfoQryPO.class);
        List<ActOrderAfterInfoPO> orderAfterWaring = this.actOrderAfterInfoMapper.getOrderAfterWaring(qryPO);
        return ActRu.jsl(orderAfterWaring, ActOrderAfterInfo.class);
    }

    public String getUnFinishOrderId(DycActOrderQryDO reqBO) {
        ActOrderInfoPO record = new ActOrderInfoPO();
        record.setActivityId(reqBO.getActivityId());
        return this.actOrderInfoMapper.getUnFinishOrderId(record);
    }

    public DycActOrderInfo queryOrderDetail(DycActOrderQryDO qryDO) {
        ActOrderUniInfo actOrderUniInfo = this.actOrderInfoMapperUni.selectOrdInfoByCond(qryDO);
        return (DycActOrderInfo)ActRu.js((Object)actOrderUniInfo, DycActOrderInfo.class);
    }

    public List<ActOrderItemInfoDO> qryOrderItemInfoList(DycActOrderQryDO qryDO) {
        ActOrderItemInfoPO qryPO = new ActOrderItemInfoPO();
        qryPO.setOrderId(qryPO.getOrderId());
        List<ActOrderItemInfoPO> orderItemInfoPOS = this.actOrderItemInfoMapper.selectByCondition(qryPO);
        return ActRu.jsl(orderItemInfoPOS, ActOrderItemInfoDO.class);
    }

    public DycActOrderAfsInfo queryAfsOrderDetail(DycActOrderAfsQryDO qryDO) {
        ActOrderAfterInfoPO qryPO = new ActOrderAfterInfoPO();
        qryPO.setAfsServiceId(qryDO.getAfsServiceId());
        List<ActOrderAfterInfoPO> actOrderAfterInfoList = this.actOrderAfterInfoMapper.selectByCondition(qryPO);
        if (actOrderAfterInfoList.size() == 1) {
            return (DycActOrderAfsInfo)ActRu.js((Object)actOrderAfterInfoList.get(0), DycActOrderAfsInfo.class);
        }
        if (actOrderAfterInfoList.size() > 1) {
            throw new ZTBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        throw new ZTBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
    }

    public List<ActOrderAfterItemDO> qryAfsOrderItemInfoList(DycActOrderAfsQryDO qryDO) {
        ActOrderAfterItemPO qryPO = new ActOrderAfterItemPO();
        qryPO.setAfsServiceId(qryPO.getAfsServiceId());
        List<ActOrderAfterItemPO> orderAfterItemPOS = this.actOrderAfterItemMapper.selectByCondition(qryPO);
        return ActRu.jsl(orderAfterItemPOS, ActOrderAfterItemDO.class);
    }
}

