/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.ActSkuPoolBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolReqBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolRspBO;
import com.tydic.dyc.act.repository.api.DycActSkuPoolRepository;
import com.tydic.dyc.act.repository.dao.ActRelSkuPoolMapper;
import com.tydic.dyc.act.repository.dao.ActRelSourcePoolMapper;
import com.tydic.dyc.act.repository.dao.ActSkuInfoMapper;
import com.tydic.dyc.act.repository.dao.ActSkuPoolMapper;
import com.tydic.dyc.act.repository.po.ActRelSkuPoolPO;
import com.tydic.dyc.act.repository.po.ActRelSourcePoolExtPO;
import com.tydic.dyc.act.repository.po.ActRelSourcePoolPO;
import com.tydic.dyc.act.repository.po.ActSkuInfoExtPO;
import com.tydic.dyc.act.repository.po.ActSkuInfoPO;
import com.tydic.dyc.act.repository.po.ActSkuPoolExtPO;
import com.tydic.dyc.act.repository.po.ActSkuPoolPO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRspBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actSkuPoolService")
public class DycActSkuPoolRepositoryImpl
implements DycActSkuPoolRepository {
    @Autowired
    ActSkuPoolMapper actSkuPoolMapper;
    @Autowired
    private ActRelSkuPoolMapper actRelSkuPoolMapper;
    @Autowired
    private ActSkuInfoMapper actSkuInfoMapper;
    @Autowired
    private ActRelSourcePoolMapper actRelSourcePoolMapper;

    public DycActQuerySkuPoolRspBO queryActSkuPoolSingle(DycActQuerySkuPoolReqBO actSkuPoolReqBO) {
        DycActQuerySkuPoolRspBO rspBO = new DycActQuerySkuPoolRspBO();
        ActSkuPoolExtPO selectActSkuPoolPO = new ActSkuPoolExtPO();
        BeanUtils.copyProperties((Object)actSkuPoolReqBO, (Object)selectActSkuPoolPO);
        List<ActSkuPoolPO> actSkuPoolList = this.actSkuPoolMapper.selectByCondition(selectActSkuPoolPO);
        if (actSkuPoolList.size() == 1) {
            List<ActSkuInfoPO> actSkuInfoPOS;
            ActSkuInfoExtPO extPO;
            rspBO = (DycActQuerySkuPoolRspBO)JUtil.js((Object)actSkuPoolList.get(0), DycActQuerySkuPoolRspBO.class);
            ActRelSourcePoolExtPO relSourcePoolPO = new ActRelSourcePoolExtPO();
            relSourcePoolPO.setPoolId(actSkuPoolReqBO.getPoolId());
            List<ActRelSourcePoolPO> actRelSourcePoolPOS = this.actRelSourcePoolMapper.selectByCondition(relSourcePoolPO);
            if (DycActivityConstants.PoolType.SUPPLIER == actSkuPoolList.get(0).getPoolType()) {
                rspBO.setPoolTypeDesc("\u4f9b\u5e94\u5546");
                if (CollectionUtils.isEmpty(actRelSourcePoolPOS)) {
                    rspBO.setSkuNum(Integer.valueOf(0));
                } else {
                    extPO = new ActSkuInfoExtPO();
                    List<Long> supplierIds = actRelSourcePoolPOS.stream().map(a -> a.getSourceId()).collect(Collectors.toList());
                    extPO.setSupplierIdList(supplierIds);
                    actSkuInfoPOS = this.actSkuInfoMapper.selectByCondition(extPO);
                    rspBO.setSkuNum(Integer.valueOf(actSkuInfoPOS.size()));
                }
            }
            if (DycActivityConstants.PoolType.COMMODITY == actSkuPoolList.get(0).getPoolType()) {
                rspBO.setPoolTypeDesc("\u5546\u54c1");
                ActRelSkuPoolPO relSkuPoolPO = new ActRelSkuPoolPO();
                relSkuPoolPO.setPoolId(actSkuPoolReqBO.getPoolId());
                List<ActRelSkuPoolPO> actRelSkuPoolPOS = this.actRelSkuPoolMapper.selectByCondition(relSkuPoolPO);
                if (CollectionUtils.isEmpty(actRelSkuPoolPOS)) {
                    rspBO.setSkuNum(Integer.valueOf(0));
                } else {
                    rspBO.setSkuNum(Integer.valueOf(actRelSkuPoolPOS.size()));
                }
            }
            if (DycActivityConstants.PoolType.CATALOG == actSkuPoolList.get(0).getPoolType()) {
                rspBO.setPoolTypeDesc("\u5546\u54c1\u7c7b\u76ee");
                if (CollectionUtils.isEmpty(actRelSourcePoolPOS)) {
                    rspBO.setSkuNum(Integer.valueOf(0));
                } else {
                    extPO = new ActSkuInfoExtPO();
                    List<Long> guideIds = actRelSourcePoolPOS.stream().map(a -> a.getSourceId()).collect(Collectors.toList());
                    extPO.setGuideIdList(guideIds);
                    actSkuInfoPOS = this.actSkuInfoMapper.selectByCondition(extPO);
                    rspBO.setSkuNum(Integer.valueOf(actSkuInfoPOS.size()));
                }
            }
        } else {
            if (actSkuPoolList.size() > 1) {
                throw new ZTBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new ZTBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        return rspBO;
    }

    public ActSkuPoolListRspBO queryActSkuPoolList(ActSkuPoolReqBO actSkuPoolReqBO) {
        ActSkuPoolListRspBO rspBO = new ActSkuPoolListRspBO();
        ActSkuPoolExtPO selectActSkuPoolPO = new ActSkuPoolExtPO();
        BeanUtils.copyProperties((Object)actSkuPoolReqBO, (Object)selectActSkuPoolPO);
        List<ActSkuPoolPO> actSkuPoolPOList = this.actSkuPoolMapper.selectByCondition(selectActSkuPoolPO);
        ArrayList<ActSkuPoolBO> actSkuPoolBOList = new ArrayList<ActSkuPoolBO>();
        for (ActSkuPoolPO actSkuPoolPO : actSkuPoolPOList) {
            ActSkuPoolBO actSkuPoolBO = new ActSkuPoolBO();
            BeanUtils.copyProperties((Object)actSkuPoolPO, (Object)actSkuPoolBO);
            actSkuPoolBOList.add(actSkuPoolBO);
        }
        rspBO.setData(actSkuPoolBOList);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public RspPage<ActSkuPoolBO> queryActSkuPoolListPage(ActSkuPoolReqBO actSkuPoolReqBO) {
        if (actSkuPoolReqBO.getPageNo() < 1) {
            actSkuPoolReqBO.setPageNo(1);
        }
        if (actSkuPoolReqBO.getPageSize() < 1) {
            actSkuPoolReqBO.setPageSize(10);
        }
        ActSkuPoolExtPO selectActSkuPoolPO = new ActSkuPoolExtPO();
        BeanUtils.copyProperties((Object)actSkuPoolReqBO, (Object)selectActSkuPoolPO);
        Page page = PageHelper.startPage((int)actSkuPoolReqBO.getPageNo(), (int)actSkuPoolReqBO.getPageSize()).doSelectPage(() -> this.actSkuPoolMapper.selectByCondition(selectActSkuPoolPO));
        ArrayList<ActSkuPoolBO> actSkuPoolBOList = new ArrayList<ActSkuPoolBO>();
        for (ActSkuPoolPO actSkuPoolPO : page.getResult()) {
            ActSkuPoolBO actSkuPoolBO = new ActSkuPoolBO();
            BeanUtils.copyProperties((Object)actSkuPoolPO, (Object)actSkuPoolBO);
            actSkuPoolBOList.add(actSkuPoolBO);
        }
        RspPage rspPage = new RspPage();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actSkuPoolBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    public ActSkuPoolRspBO addActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO) {
        ActSkuPoolRspBO rspBO = new ActSkuPoolRspBO();
        ActSkuPoolExtPO extPO = new ActSkuPoolExtPO();
        extPO.setPoolName(actSkuPoolReqBO.getPoolName());
        List<ActSkuPoolPO> actSkuPoolPOS = this.actSkuPoolMapper.selectByCondition(extPO);
        if (!CollectionUtils.isEmpty(actSkuPoolPOS)) {
            throw new ZTBusinessException("\u65b0\u589e\u4fe1\u606f\u5931\u8d25\uff1a\u5546\u54c1\u6c60\u540d\u79f0\u91cd\u590d");
        }
        ActSkuPoolPO insertActSkuPoolPO = new ActSkuPoolPO();
        long id = Sequence.getInstance().nextId();
        insertActSkuPoolPO.setPoolId(id);
        insertActSkuPoolPO.setPoolCode(actSkuPoolReqBO.getPoolCode());
        insertActSkuPoolPO.setPoolName(actSkuPoolReqBO.getPoolName());
        insertActSkuPoolPO.setPoolType(actSkuPoolReqBO.getPoolType());
        insertActSkuPoolPO.setRemark(actSkuPoolReqBO.getRemark());
        insertActSkuPoolPO.setCreateTime(new Date());
        insertActSkuPoolPO.setCreateOperName(actSkuPoolReqBO.getName());
        int num = this.actSkuPoolMapper.insert(insertActSkuPoolPO);
        if (num != 1) {
            throw new ZTBusinessException("\u65b0\u589e\u4fe1\u606f\u5931\u8d25\uff1a\u65b0\u589e\u4fe1\u606f\u5931\u8d25");
        }
        ActSkuPoolBO ActSkuPoolBO2 = new ActSkuPoolBO();
        BeanUtils.copyProperties((Object)insertActSkuPoolPO, (Object)ActSkuPoolBO2);
        rspBO.setData(ActSkuPoolBO2);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public ActSkuPoolListRspBO addListActSkuPool(List<ActSkuPoolReqBO> actSkuPoolReqBO) {
        ActSkuPoolListRspBO rspBO = new ActSkuPoolListRspBO();
        for (int i = 0; i < actSkuPoolReqBO.size(); ++i) {
            long id = Sequence.getInstance().nextId();
            actSkuPoolReqBO.get(i).setPoolId(Long.valueOf(id));
        }
        List insertActSkuPoolPO = JSONObject.parseArray((String)JSONObject.toJSONString(actSkuPoolReqBO), ActSkuPoolPO.class);
        int num = this.actSkuPoolMapper.allInsert(insertActSkuPoolPO);
        if (num != actSkuPoolReqBO.size()) {
            throw new ZTBusinessException("\u65b0\u589e\u4fe1\u606f\u5931\u8d25\uff1a\u65b0\u589e\u4fe1\u606f\u5931\u8d25");
        }
        List lActSkuPoolBO = JSONObject.parseArray((String)JSONObject.toJSONString((Object)insertActSkuPoolPO), ActSkuPoolBO.class);
        rspBO.setData(lActSkuPoolBO);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public ActSkuPoolRspBO updateActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO) {
        ActSkuPoolPO updateActSkuPoolPO;
        ActSkuPoolRspBO rspBO = new ActSkuPoolRspBO();
        ActSkuPoolExtPO selectActSkuPoolPO = new ActSkuPoolExtPO();
        selectActSkuPoolPO.setPoolId(actSkuPoolReqBO.getPoolId());
        List<ActSkuPoolPO> actSkuPoolList = this.actSkuPoolMapper.selectByCondition(selectActSkuPoolPO);
        if (actSkuPoolList.size() == 1) {
            updateActSkuPoolPO = new ActSkuPoolPO();
            BeanUtils.copyProperties((Object)actSkuPoolReqBO, (Object)updateActSkuPoolPO);
            int num = this.actSkuPoolMapper.update(updateActSkuPoolPO);
            if (num != 1) {
                throw new ZTBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (actSkuPoolList.size() > 1) {
                throw new ZTBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new ZTBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        ActSkuPoolBO actSkuPoolBO = new ActSkuPoolBO();
        BeanUtils.copyProperties((Object)updateActSkuPoolPO, (Object)actSkuPoolBO);
        rspBO.setData(actSkuPoolBO);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public ActSkuPoolRspBO saveActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO) {
        if (actSkuPoolReqBO.getPoolId() == null) {
            return this.addActSkuPool(actSkuPoolReqBO);
        }
        return this.updateActSkuPool(actSkuPoolReqBO);
    }

    public ActSkuPoolRspBO deleteActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO) {
        ActSkuPoolRspBO rspBO = new ActSkuPoolRspBO();
        ActSkuPoolExtPO selectActSkuPoolPO = new ActSkuPoolExtPO();
        selectActSkuPoolPO.setPoolId(actSkuPoolReqBO.getPoolId());
        List<ActSkuPoolPO> actSkuPoolList = this.actSkuPoolMapper.selectByCondition(selectActSkuPoolPO);
        if (actSkuPoolList.size() == 1) {
            ActSkuPoolPO deleteActSkuPoolPO = new ActSkuPoolPO();
            BeanUtils.copyProperties((Object)actSkuPoolReqBO, (Object)deleteActSkuPoolPO);
            int num = this.actSkuPoolMapper.delete(deleteActSkuPoolPO);
            if (num != 1) {
                throw new ZTBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u5220\u9664\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (actSkuPoolList.size() > 1) {
                throw new ZTBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new ZTBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public RspPage<ActSkuPoolBO> querySkuPoolPageList(ActSkuPoolReqBO actSkuPoolReqBO) {
        if (actSkuPoolReqBO.getPageNo() < 1) {
            actSkuPoolReqBO.setPageNo(1);
        }
        if (actSkuPoolReqBO.getPageSize() < 1) {
            actSkuPoolReqBO.setPageSize(10);
        }
        ActSkuPoolExtPO qryPO = (ActSkuPoolExtPO)ActRu.js((Object)actSkuPoolReqBO, ActSkuPoolExtPO.class);
        Page page = PageHelper.startPage((int)actSkuPoolReqBO.getPageNo(), (int)actSkuPoolReqBO.getPageSize()).doSelectPage(() -> this.actSkuPoolMapper.getListPage(qryPO));
        RspPage rspPage = new RspPage();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        if (!CollectionUtils.isEmpty((Collection)page.getResult())) {
            Map<Integer, List<ActSkuPoolExtPO>> poolTypeMap = page.getResult().stream().collect(Collectors.groupingBy(ActSkuPoolPO::getPoolType));
            Iterator<Map.Entry<Integer, List<ActSkuPoolExtPO>>> iterator = poolTypeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Integer poolType = iterator.next().getKey();
                List<Long> poolIdList = poolTypeMap.get(poolType).stream().map(ActSkuPoolPO::getPoolId).collect(Collectors.toList());
                ActSkuPoolExtPO poolExtPO = new ActSkuPoolExtPO();
                poolExtPO.setPoolType(poolType);
                poolExtPO.setPoolIdList(poolIdList);
                List<ActSkuPoolExtPO> skuPoolExtPOS = this.actSkuPoolMapper.getSkuNum(poolExtPO);
                if (CollectionUtils.isEmpty(skuPoolExtPOS)) continue;
                Map<Long, Integer> poolToSkuNumMap = skuPoolExtPOS.stream().collect(Collectors.toMap(ActSkuPoolPO::getPoolId, ActSkuPoolExtPO::getSkuNum));
                for (ActSkuPoolExtPO extPO : poolTypeMap.get(poolType)) {
                    if (!poolToSkuNumMap.containsKey(extPO.getPoolId())) continue;
                    extPO.setSkuNum(poolToSkuNumMap.get(extPO.getPoolId()));
                }
            }
            rspPage.setRows(ActRu.jsl((List)page.getResult(), ActSkuPoolBO.class));
        }
        return rspPage;
    }
}

