/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActActivityChangeCommodityInfoQryDO;
import com.tydic.dyc.act.model.bo.ActivityChangeRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityPoolInfo;
import com.tydic.dyc.act.repository.api.DycActActivityChangeCommodityRepository;
import com.tydic.dyc.act.repository.dao.ActSkuInfoMapper;
import com.tydic.dyc.act.repository.dao.ActivityChangeRelaCommodityCatalogMapper;
import com.tydic.dyc.act.repository.dao.ActivityChangeRelaCommodityMapper;
import com.tydic.dyc.act.repository.dao.ActivityChangeRelaCommodityPoolMapper;
import com.tydic.dyc.act.repository.po.ActActivityChangeCommodityInfoQryPO;
import com.tydic.dyc.act.repository.po.ActSkuInfoPO;
import com.tydic.dyc.act.repository.po.ActivityChangeRelaCommodityCatalogPO;
import com.tydic.dyc.act.repository.po.ActivityChangeRelaCommodityExtPO;
import com.tydic.dyc.act.repository.po.ActivityChangeRelaCommodityPO;
import com.tydic.dyc.act.repository.po.ActivityChangeRelaCommodityPoolPO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycActActivityChangeCommodityRepositoryImpl
implements DycActActivityChangeCommodityRepository {
    @Autowired
    private ActivityChangeRelaCommodityCatalogMapper activityChangeRelaCommodityCatalogMapper;
    @Autowired
    private ActivityChangeRelaCommodityPoolMapper activityChangeRelaCommodityPoolMapper;
    @Autowired
    private ActivityChangeRelaCommodityMapper activityChangeRelaCommodityMapper;
    @Autowired
    private ActSkuInfoMapper actSkuInfoMapper;

    public BasePageRspBo<DycActivityChangeRelaCommodityCatalogInfo> queryActivityChangeSelectedCommodityCatalogPageList(DycActivityChangeDO reqBo) {
        BasePageRspBo rspBo = new BasePageRspBo();
        ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPo = (ActivityChangeRelaCommodityCatalogPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), ActivityChangeRelaCommodityCatalogPO.class);
        Page page = PageHelper.startPage((int)reqBo.getPageNo(), (int)reqBo.getPageSize()).doSelectPage(() -> this.activityChangeRelaCommodityCatalogMapper.selectByCondition(activityChangeRelaCommodityCatalogPo));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        List rows = JSON.parseArray((String)JSON.toJSONString((Object)page.getResult()), DycActivityChangeRelaCommodityCatalogInfo.class);
        List<Long> threeCatalogIds = rows.stream().map(DycActivityChangeRelaCommodityCatalogInfo::getThreeCatalogId).filter(StringUtils::isNotBlank).map(Convert::toLong).distinct().collect(Collectors.toList());
        Map<Object, Object> guideIdMap = new HashMap(16);
        if (!CollectionUtils.isEmpty(threeCatalogIds)) {
            ActSkuInfoPO qryActSkuInfoPo = new ActSkuInfoPO();
            qryActSkuInfoPo.setGuideIds(threeCatalogIds);
            qryActSkuInfoPo.setAgreementPriceMin(reqBo.getAgreementPriceMin());
            qryActSkuInfoPo.setAgreementPriceMax(reqBo.getAgreementPriceMax());
            List<ActSkuInfoPO> actSkuInfoPos = this.actSkuInfoMapper.selectSkuCountByCondition(qryActSkuInfoPo);
            if (!CollectionUtils.isEmpty(actSkuInfoPos)) {
                guideIdMap = actSkuInfoPos.stream().collect(Collectors.groupingBy(ActSkuInfoPO::getGuideId));
            }
        }
        for (DycActivityChangeRelaCommodityCatalogInfo row : rows) {
            List actSkuInfoPos;
            row.setTotalCommodity(Integer.valueOf(0));
            if (StringUtils.isBlank((CharSequence)row.getThreeCatalogId())) continue;
            if (!MapUtil.isEmpty(guideIdMap) && !CollectionUtils.isEmpty((Collection)(actSkuInfoPos = (List)guideIdMap.get(Long.parseLong(row.getThreeCatalogId()))))) {
                row.setTotalCommodity(((ActSkuInfoPO)actSkuInfoPos.get(0)).getSkuCount());
            }
            row.setCatalogStr(row.getFirstCatalogName() + ">" + row.getSecondCatalogName() + ">" + row.getThreeCatalogName());
        }
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(rows);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int)page.getTotal());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public BasePageRspBo<DycActivityChangeRelaCommodityPoolInfo> queryActivityChangeCommodityPoolPageList(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getChangeId()) {
            throw new ZTBusinessException("\u53d8\u66f4\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActivityChangeRelaCommodityPoolPO selectActivityChangeRelaCommodityPoolPO = new ActivityChangeRelaCommodityPoolPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)selectActivityChangeRelaCommodityPoolPO);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activityChangeRelaCommodityPoolMapper.selectByCondition(selectActivityChangeRelaCommodityPoolPO));
        ArrayList<DycActivityChangeRelaCommodityPoolInfo> activityChangeRelaCommodityPoolBOList = new ArrayList<DycActivityChangeRelaCommodityPoolInfo>();
        for (ActivityChangeRelaCommodityPoolPO activityChangeRelaCommodityPoolPO : page.getResult()) {
            DycActivityChangeRelaCommodityPoolInfo activityChangeRelaCommodityPoolBO = new DycActivityChangeRelaCommodityPoolInfo();
            BeanUtils.copyProperties((Object)activityChangeRelaCommodityPoolPO, (Object)activityChangeRelaCommodityPoolBO);
            activityChangeRelaCommodityPoolBOList.add(activityChangeRelaCommodityPoolBO);
        }
        BasePageRspBo rspPage = new BasePageRspBo();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityChangeRelaCommodityPoolBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        rspPage.setRespCode("0000");
        rspPage.setRespDesc("\u6210\u529f");
        return rspPage;
    }

    public DycActivityChangeRelaCommodityPoolInfo batchSelectActivityChangeCommodityPool(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO) || null == reqBO.getChangeId()) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u53d8\u66f4\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityPoolList())) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List commodityPoolPOS = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getCommodityPoolList()), ActivityChangeRelaCommodityPoolPO.class);
        commodityPoolPOS.forEach(item -> {
            item.setRelaId(Sequence.getInstance().nextId());
            item.setChangeId(reqBO.getChangeId());
            item.setDelFlag(0);
            item.setCreateTime(new Date());
            item.setCreateUserId(reqBO.getCreateUserId());
            item.setCreateUserName(reqBO.getCreateUserName());
            item.setUpdateTime(null);
            item.setUpdateUserId(null);
            item.setUpdateUserName(null);
        });
        int i = this.activityChangeRelaCommodityPoolMapper.allInsert(commodityPoolPOS);
        if (reqBO.getCommodityPoolList().size() != i) {
            throw new ZTBusinessException("\u6d3b\u52a8\u53d8\u66f4\u5546\u54c1\u6c60\u9009\u62e9\uff08\u6279\u91cf\uff09\u670d\u52a1\u5931\u8d25\uff01");
        }
        return new DycActivityChangeRelaCommodityPoolInfo();
    }

    public DycActivityChangeRelaCommodityPoolInfo batchRemoveActivityChangeCommodityPool(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO) || null == reqBO.getChangeId()) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u53d8\u66f4\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityPoolIdList())) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60Id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActivityChangeRelaCommodityPoolPO commodityPoolPO = new ActivityChangeRelaCommodityPoolPO();
        commodityPoolPO.setChangeId(reqBO.getChangeId());
        commodityPoolPO.setUpdateTime(new Date());
        commodityPoolPO.setUpdateUserId(reqBO.getUpdateUserId());
        commodityPoolPO.setUpdateUserName(reqBO.getUpdateUserName());
        int i = this.activityChangeRelaCommodityPoolMapper.updateBatchById(reqBO.getCommodityPoolIdList(), commodityPoolPO);
        if (i != reqBO.getCommodityPoolIdList().size()) {
            throw new ZTBusinessException("\u6d3b\u52a8\u53d8\u66f4\u5546\u54c1\u6c60\u79fb\u9664\uff08\u6279\u91cf\uff09\u670d\u52a1\u5931\u8d25\uff01");
        }
        return new DycActivityChangeRelaCommodityPoolInfo();
    }

    public int batchSelectActivityChangeCommodity(DycActivityChangeDO reqBo) {
        if (ObjectUtils.isEmpty((Object)reqBo) || null == reqBo.getChangeId()) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u53d8\u66f4\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getCommodityList())) {
            throw new ZTBusinessException("\u5546\u54c1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List commodityPoList = JSON.parseArray((String)JSON.toJSONString((Object)reqBo.getCommodityList()), ActivityChangeRelaCommodityPO.class);
        commodityPoList.forEach(item -> {
            item.setRelaId(Sequence.getInstance().nextId());
            item.setChangeId(reqBo.getChangeId());
            item.setDelFlag(0);
            item.setCreateTime(new Date());
            if (item.getFavorableRate() != null) {
                BigDecimal bigDecimal = BigDecimal.valueOf(item.getFavorableRate());
                item.setFavorableRate(bigDecimal.setScale(2, RoundingMode.HALF_UP).doubleValue());
            }
            item.setCreateUserId(reqBo.getCreateUserId());
            item.setCreateUserName(reqBo.getCreateUserName());
            item.setUpdateTime(null);
            item.setUpdateUserId(null);
            item.setUpdateUserName(null);
        });
        int i = this.activityChangeRelaCommodityMapper.allInsert(commodityPoList);
        if (reqBo.getCommodityList().size() != i) {
            throw new ZTBusinessException("\u6d3b\u52a8\u53d8\u66f4\u5546\u54c1\u9009\u62e9\uff08\u6279\u91cf\uff09\u670d\u52a1\u5931\u8d25\uff01");
        }
        return i;
    }

    public int batchSelectActivityChangeCommodityCatalog(DycActivityChangeDO reqBo) {
        if (ObjectUtils.isEmpty((Object)reqBo) || null == reqBo.getChangeId()) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u53d8\u66f4\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getCommodityCatalogList())) {
            throw new ZTBusinessException("\u5546\u54c1\u7c7b\u578b\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List commodityPoList = JSON.parseArray((String)JSON.toJSONString((Object)reqBo.getCommodityCatalogList()), ActivityChangeRelaCommodityCatalogPO.class);
        commodityPoList.forEach(item -> {
            item.setRelaId(Sequence.getInstance().nextId());
            item.setChangeId(reqBo.getChangeId());
            item.setDelFlag(0);
            item.setCreateTime(new Date());
            item.setCreateUserId(reqBo.getCreateUserId());
            item.setCreateUserName(reqBo.getCreateUserName());
            item.setUpdateTime(null);
            item.setUpdateUserId(null);
            item.setUpdateUserName(null);
        });
        int i = this.activityChangeRelaCommodityCatalogMapper.allInsert(commodityPoList);
        if (reqBo.getCommodityCatalogList().size() != i) {
            throw new ZTBusinessException("\u6d3b\u52a8\u53d8\u66f4\u5546\u54c1\u7c7b\u578b\u9009\u62e9\uff08\u6279\u91cf\uff09\u670d\u52a1\u5931\u8d25\uff01");
        }
        return i;
    }

    public int batchRemoveActivityChangeCommodityCatalog(DycActivityChangeDO reqBO) {
        ArrayList<ActivityChangeRelaCommodityCatalogPO> list = new ArrayList<ActivityChangeRelaCommodityCatalogPO>();
        for (Long aLong : reqBO.getRelaIdList()) {
            ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPo = new ActivityChangeRelaCommodityCatalogPO();
            activityChangeRelaCommodityCatalogPo.setChangeId(reqBO.getChangeId());
            activityChangeRelaCommodityCatalogPo.setUpdateTime(new Date());
            activityChangeRelaCommodityCatalogPo.setUpdateUserId(reqBO.getUpdateUserId());
            activityChangeRelaCommodityCatalogPo.setUpdateUserName(reqBO.getUpdateUserName());
            activityChangeRelaCommodityCatalogPo.setRelaId(aLong);
            list.add(activityChangeRelaCommodityCatalogPo);
        }
        return this.activityChangeRelaCommodityCatalogMapper.batchRemoveActivityChangeCommodityCatalog(list);
    }

    public BasePageRspBo<ActivityChangeRelaCommodityInfo> queryActivityChangeCommodityPageList(ActActivityChangeCommodityInfoQryDO qryDo) {
        BasePageRspBo rspBo = new BasePageRspBo();
        ActActivityChangeCommodityInfoQryPO qryPo = (ActActivityChangeCommodityInfoQryPO)JSON.parseObject((String)JSON.toJSONString((Object)qryDo), ActActivityChangeCommodityInfoQryPO.class);
        Page page = PageHelper.startPage((int)qryDo.getPageNo(), (int)qryDo.getPageSize()).doSelectPage(() -> this.activityChangeRelaCommodityMapper.selectByCondition(qryPo));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        List rows = JSON.parseArray((String)JSON.toJSONString((Object)page.getResult()), ActivityChangeRelaCommodityInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(rows);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int)page.getTotal());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            for (ActivityChangeRelaCommodityInfo info : rspBo.getRows()) {
                info.setCatalogNameStr(info.getFirstCatalogName() + ">" + info.getSecondCatalogName() + ">" + info.getThreeCatalogName());
                if (info.getFavorableRate() != null) {
                    if (info.getFavorableRate() % (double)info.getFavorableRate().intValue() == 0.0) {
                        info.setFavorableRateStr(info.getFavorableRate().intValue() + "%");
                        continue;
                    }
                    info.setFavorableRateStr(info.getFavorableRate() + "%");
                    continue;
                }
                info.setFavorableRateStr("-");
            }
        }
        return rspBo;
    }

    public int batchRemoveActivityChangeCommodity(DycActivityChangeDO reqBO) {
        ActivityChangeRelaCommodityExtPO activityChangeRelaCommodityPo = new ActivityChangeRelaCommodityExtPO();
        activityChangeRelaCommodityPo.setChangeId(reqBO.getChangeId());
        activityChangeRelaCommodityPo.setUpdateTime(new Date());
        activityChangeRelaCommodityPo.setUpdateUserId(reqBO.getUpdateUserId());
        activityChangeRelaCommodityPo.setUpdateUserName(reqBO.getUpdateUserName());
        activityChangeRelaCommodityPo.setSkuIdList(reqBO.getSkuIdList());
        return this.activityChangeRelaCommodityMapper.batchRemoveActivityChangeCommodity(activityChangeRelaCommodityPo);
    }

    public void delete(ActivityChangeRelaCommodityInfo activityChangeRelaCommodityInfo) {
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPO = (ActivityChangeRelaCommodityPO)ActRu.js((Object)activityChangeRelaCommodityInfo, ActivityChangeRelaCommodityPO.class);
        this.activityChangeRelaCommodityMapper.delete(activityChangeRelaCommodityPO);
    }

    public List<ActivityChangeRelaCommodityInfo> getList(ActivityChangeRelaCommodityInfo reqBO) {
        ActActivityChangeCommodityInfoQryPO qryPO = (ActActivityChangeCommodityInfoQryPO)ActRu.js((Object)reqBO, ActActivityChangeCommodityInfoQryPO.class);
        List<ActivityChangeRelaCommodityPO> activityChangeRelaCommodityPOS = this.activityChangeRelaCommodityMapper.selectByCondition(qryPO);
        return ActRu.jsl(activityChangeRelaCommodityPOS, ActivityChangeRelaCommodityInfo.class);
    }

    public void update(ActivityChangeRelaCommodityInfo reqBO) {
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPO = (ActivityChangeRelaCommodityPO)ActRu.js((Object)reqBO, ActivityChangeRelaCommodityPO.class);
        this.activityChangeRelaCommodityMapper.update(activityChangeRelaCommodityPO);
    }

    public List<DycActivityChangeRelaCommodityCatalogInfo> getListCatalog(DycActivityChangeDO reqBo) {
        ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPo = new ActivityChangeRelaCommodityCatalogPO();
        activityChangeRelaCommodityCatalogPo.setChangeId(reqBo.getChangeId());
        List<ActivityChangeRelaCommodityCatalogPO> activityChangeRelaCommodityCatalogPoList = this.activityChangeRelaCommodityCatalogMapper.selectByCondition(activityChangeRelaCommodityCatalogPo);
        return JSONObject.parseArray((String)JSONObject.toJSONString(activityChangeRelaCommodityCatalogPoList), DycActivityChangeRelaCommodityCatalogInfo.class);
    }

    public int insertNew(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo = (ActivityChangeRelaCommodityPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeRelaCommodityPO.class);
        return this.activityChangeRelaCommodityMapper.insertNew(activityChangeRelaCommodityPo);
    }

    public int updateByNew(DycActivityChangeRelaCommodityInfo set, DycActivityChangeRelaCommodityInfo where) {
        ActivityChangeRelaCommodityPO setPo = (ActivityChangeRelaCommodityPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)set), ActivityChangeRelaCommodityPO.class);
        ActivityChangeRelaCommodityPO wherePo = (ActivityChangeRelaCommodityPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)where), ActivityChangeRelaCommodityPO.class);
        return this.activityChangeRelaCommodityMapper.updateBy(setPo, wherePo);
    }

    public int getCheckByNew(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo = (ActivityChangeRelaCommodityPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeRelaCommodityPO.class);
        return this.activityChangeRelaCommodityMapper.getCheckBy(activityChangeRelaCommodityPo);
    }

    public DycActivityChangeRelaCommodityInfo getModelByNew(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo = (ActivityChangeRelaCommodityPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeRelaCommodityPO.class);
        ActivityChangeRelaCommodityPO modelBy = this.activityChangeRelaCommodityMapper.getModelBy(activityChangeRelaCommodityPo);
        return (DycActivityChangeRelaCommodityInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)modelBy), DycActivityChangeRelaCommodityInfo.class);
    }

    public List<DycActivityChangeRelaCommodityInfo> getListNew(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPo = (ActivityChangeRelaCommodityPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeRelaCommodityPO.class);
        List<ActivityChangeRelaCommodityPO> list = this.activityChangeRelaCommodityMapper.getList(activityChangeRelaCommodityPo);
        return JSONObject.parseArray((String)JSONObject.toJSONString(list), DycActivityChangeRelaCommodityInfo.class);
    }

    public void insertBatchNew(List<DycActivityChangeRelaCommodityInfo> list) {
        List listPo = JSONObject.parseArray((String)JSONObject.toJSONString(list), ActivityChangeRelaCommodityPO.class);
        this.activityChangeRelaCommodityMapper.insertBatch(listPo);
    }

    public int count(DycActivityChangeRelaCommodityInfo relaCommodityInfo) {
        ActivityChangeRelaCommodityPO activityChangeRelaCommodityPO = (ActivityChangeRelaCommodityPO)ActRu.js((Object)relaCommodityInfo, ActivityChangeRelaCommodityPO.class);
        return this.activityChangeRelaCommodityMapper.count(activityChangeRelaCommodityPO);
    }
}

