/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.DycActActivityChangeApproveBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeInfo;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.repository.api.DycActActivityChangeRepository;
import com.tydic.dyc.act.repository.dao.ActivityChangeInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityChangeInfoPO;
import com.tydic.dyc.act.repository.po.ActivityChangeInfoTimePO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycActActivityChangeRepositoryImpl
implements DycActActivityChangeRepository {
    @Autowired
    private ActivityChangeInfoMapper activityChangeInfoMapper;

    public DycActivityChangeInfo queryActivityChangeBaseInfo(DycActivityChangeDO reqBo) {
        if (ObjectUtils.isEmpty((Object)reqBo) || null == reqBo.getChangeId()) {
            throw new ZTBusinessException("\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u53d8\u66f4id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DycActivityChangeInfo rspBo = new DycActivityChangeInfo();
        ActivityChangeInfoPO selectActivityChangeInfoPo = new ActivityChangeInfoPO();
        selectActivityChangeInfoPo.setChangeId(reqBo.getChangeId());
        List<ActivityChangeInfoPO> activityChangeInfoList = this.activityChangeInfoMapper.selectByCondition(selectActivityChangeInfoPo);
        if (activityChangeInfoList.size() > 1) {
            throw new ZTBusinessException("\u5f53\u524did\u5b58\u5728\u591a\u4e2a\u53d8\u66f4\u5355\uff01");
        }
        if (activityChangeInfoList.size() < 1) {
            throw new ZTBusinessException("\u5f53\u524did\u4e0d\u5b58\u5728\u53d8\u66f4\u5355\uff01");
        }
        BeanUtils.copyProperties((Object)activityChangeInfoList.get(0), (Object)rspBo);
        return rspBo;
    }

    public DycActivityChangeInfo saveActiveChangeBaseInfo(DycActivityChangeDO reqBO) {
        ActivityChangeInfoPO changeInfoPO = new ActivityChangeInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)changeInfoPO);
        changeInfoPO.setChangeId(Sequence.getInstance().nextId());
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String formattedDateTime = now.format(formatter);
        Random random = new Random();
        int randomNum = random.nextInt(900) + 100;
        String activityCode = "FLHD" + formattedDateTime + randomNum;
        String changeCode = "HDBGD" + formattedDateTime + randomNum;
        changeInfoPO.setChangeCode(changeCode);
        changeInfoPO.setChangeState(String.valueOf(0));
        changeInfoPO.setDelFlag(0);
        changeInfoPO.setCreateTime(new Date());
        changeInfoPO.setNewActivityCode(activityCode);
        int i = this.activityChangeInfoMapper.insert(changeInfoPO);
        if (1 != i) {
            throw new ZTBusinessException("\u65b0\u589e\u53d8\u66f4\u5355\u5931\u8d25\uff01");
        }
        DycActivityChangeInfo rspBO = new DycActivityChangeInfo();
        rspBO.setChangeId(changeInfoPO.getChangeId());
        return rspBO;
    }

    public DycActivityChangeInfo changeActivityChangeState(DycActivityChangeDO reqBO) {
        ActivityChangeInfoPO changeInfoPO = new ActivityChangeInfoPO();
        changeInfoPO.setChangeId(reqBO.getChangeId());
        changeInfoPO.setUpdateTime(new Date());
        changeInfoPO.setUpdateUserId(reqBO.getUserId());
        changeInfoPO.setUpdateUserName(reqBO.getName());
        changeInfoPO.setChangeState(reqBO.getChangeState());
        this.activityChangeInfoMapper.update(changeInfoPO);
        return new DycActivityChangeInfo();
    }

    public BasePageRspBo<DycActivityChangeInfo> queryActivityChangePageList(DycActivityChangeDO reqBO) {
        BasePageRspBo rspBo = new BasePageRspBo();
        ActivityChangeInfoTimePO activityChangeInfoTimePO = (ActivityChangeInfoTimePO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityChangeInfoTimePO.class);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activityChangeInfoMapper.queryActivityChangePageList(activityChangeInfoTimePO));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        ArrayList<DycActivityChangeInfo> activityChangeInfoList = new ArrayList<DycActivityChangeInfo>();
        for (ActivityChangeInfoPO activityChangeInfoPO : page.getResult()) {
            DycActivityChangeInfo dycActivityChangeInfo = new DycActivityChangeInfo();
            BeanUtils.copyProperties((Object)activityChangeInfoPO, (Object)dycActivityChangeInfo);
            dycActivityChangeInfo.setChangeStateStr(DycActivityTransFieldUtil.ChangeState((String)String.valueOf(dycActivityChangeInfo.getChangeState())));
            dycActivityChangeInfo.setActivityTypeDesc(DycActivityTransFieldUtil.ActivityType((String)String.valueOf(dycActivityChangeInfo.getActivityType())));
            activityChangeInfoList.add(dycActivityChangeInfo);
        }
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(activityChangeInfoList);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int)page.getTotal());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public BasePageRspBo<DycActActivityChangeApproveBaseInfo> queryActivityChangeApprovePageList(DycProcessDO reqBO) {
        Page page;
        BasePageRspBo rspBo = new BasePageRspBo();
        ActivityChangeInfoTimePO activityBaseInfoTimePO = (ActivityChangeInfoTimePO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityChangeInfoTimePO.class);
        if (!StringUtils.isEmpty((CharSequence)activityBaseInfoTimePO.getTabId())) {
            ArrayList<Integer> taskStateList = new ArrayList<Integer>();
            if ("1".equals(activityBaseInfoTimePO.getTabId())) {
                taskStateList.add(1);
            } else if ("2".equals(activityBaseInfoTimePO.getTabId())) {
                taskStateList.add(2);
                taskStateList.add(3);
            }
            activityBaseInfoTimePO.setTaskStateList(taskStateList);
            Page page2 = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activityChangeInfoMapper.queryActivityChangeApprovePageListByApprove(activityBaseInfoTimePO));
            if (ObjectUtils.isEmpty((Object)page2)) {
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
                return rspBo;
            }
            System.out.println(page2);
            List activityBaseInfoBOList = JSON.parseArray((String)JSON.toJSONString((Object)page2.getResult()), DycActActivityChangeApproveBaseInfo.class);
            rspBo.setPageNo(page2.getPageNum());
            rspBo.setRows(activityBaseInfoBOList);
            rspBo.setTotal(page2.getPages());
            rspBo.setRecordsTotal((int)page2.getTotal());
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        if (StringUtils.isEmpty((CharSequence)activityBaseInfoTimePO.getTabId())) {
            activityBaseInfoTimePO.setUserId(null);
        }
        if (ObjectUtils.isEmpty((Object)(page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activityChangeInfoMapper.queryActivityChangeApprovePageList(activityBaseInfoTimePO))))) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        System.out.println(page);
        List activityBaseInfoBOList = JSON.parseArray((String)JSON.toJSONString((Object)page.getResult()), DycActActivityChangeApproveBaseInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(activityBaseInfoBOList);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int)page.getTotal());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public List<DycActivityChangeInfo> getList(DycActivityChangeInfo dycActivityChangeInfo) {
        ActivityChangeInfoPO selectActivityChangeInfoPo = (ActivityChangeInfoPO)ActRu.js((Object)dycActivityChangeInfo, ActivityChangeInfoPO.class);
        List<ActivityChangeInfoPO> activityChangeInfoList = this.activityChangeInfoMapper.selectByCondition(selectActivityChangeInfoPo);
        return ActRu.jsl(activityChangeInfoList, DycActivityChangeInfo.class);
    }

    public void updateByCondition(DycActivityChangeDO reqBo) {
        ActivityChangeInfoPO activityChangeInfoPo = (ActivityChangeInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeInfoPO.class);
        this.activityChangeInfoMapper.update(activityChangeInfoPo);
    }

    public int insertNew(DycActivityChangeInfo reqBo) {
        ActivityChangeInfoPO activityChangeInfoPo = (ActivityChangeInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeInfoPO.class);
        return this.activityChangeInfoMapper.insertNew(activityChangeInfoPo);
    }

    public int updateByNew(DycActivityChangeInfo set, DycActivityChangeInfo where) {
        ActivityChangeInfoPO activityChangeInfoPoSet = (ActivityChangeInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)set), ActivityChangeInfoPO.class);
        ActivityChangeInfoPO activityChangeInfoPoWhere = (ActivityChangeInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)where), ActivityChangeInfoPO.class);
        return this.activityChangeInfoMapper.updateBy(activityChangeInfoPoSet, activityChangeInfoPoWhere);
    }

    public int getCheckByNew(DycActivityChangeInfo reqBo) {
        ActivityChangeInfoPO activityChangeInfoPo = (ActivityChangeInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeInfoPO.class);
        return this.activityChangeInfoMapper.getCheckBy(activityChangeInfoPo);
    }

    public DycActivityChangeInfo getModelByNew(DycActivityChangeInfo reqBo) {
        ActivityChangeInfoPO activityChangeInfoPo = (ActivityChangeInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeInfoPO.class);
        ActivityChangeInfoPO modelBy = this.activityChangeInfoMapper.getModelBy(activityChangeInfoPo);
        return (DycActivityChangeInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)modelBy), DycActivityChangeInfo.class);
    }

    public List<DycActivityChangeInfo> getListNew(DycActivityChangeInfo reqBo) {
        ActivityChangeInfoPO activityChangeInfoPo = (ActivityChangeInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeInfoPO.class);
        List<ActivityChangeInfoPO> list = this.activityChangeInfoMapper.getList(activityChangeInfoPo);
        return JSONObject.parseArray((String)JSONObject.toJSONString(list), DycActivityChangeInfo.class);
    }

    public List<DycActivityChangeInfo> getListActivityId(DycActivityChangeInfo reqBo) {
        ActivityChangeInfoPO activityChangeInfoPo = (ActivityChangeInfoPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), ActivityChangeInfoPO.class);
        List<ActivityChangeInfoPO> list = this.activityChangeInfoMapper.getListActivityId(activityChangeInfoPo);
        return JSONObject.parseArray((String)JSONObject.toJSONString(list), DycActivityChangeInfo.class);
    }

    public void insertBatchNew(List<DycActivityChangeInfo> list) {
        List listPo = JSONObject.parseArray((String)JSONObject.toJSONString(list), ActivityChangeInfoPO.class);
        this.activityChangeInfoMapper.insertBatch(listPo);
    }

    public List<DycActivityChangeInfo> qrySum(List<String> reqBO) {
        if (CollectionUtils.isEmpty(reqBO)) {
            return new ArrayList<DycActivityChangeInfo>();
        }
        List<ActivityChangeInfoPO> infoPOS = this.activityChangeInfoMapper.qryActSum(reqBO);
        return JSON.parseArray((String)JSON.toJSONString(infoPOS), DycActivityChangeInfo.class);
    }
}

