/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.ActAlertOrderInfo;
import com.tydic.dyc.act.model.bo.ActUpdateAlertInfo;
import com.tydic.dyc.act.model.bo.DycActDealOrderAlertDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActOrderQryDO;
import com.tydic.dyc.act.repository.api.DycActAlertInfoRepository;
import com.tydic.dyc.act.repository.dao.ActAlertInfoMapper;
import com.tydic.dyc.act.repository.dao.ActFscOrderMapper;
import com.tydic.dyc.act.repository.dao.ActOrderInfoMapper;
import com.tydic.dyc.act.repository.dao.ActOrderInfoMapperUni;
import com.tydic.dyc.act.repository.dao.ActivityBaseInfoMapper;
import com.tydic.dyc.act.repository.po.ActAfsOrdInfoUni;
import com.tydic.dyc.act.repository.po.ActAlertInfoPO;
import com.tydic.dyc.act.repository.po.ActFscOrderPO;
import com.tydic.dyc.act.repository.po.ActOrderInfoPO;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoPO;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycActAlertInfoRepositoryImpl
implements DycActAlertInfoRepository {
    @Autowired
    private ActAlertInfoMapper actAlertInfoMapper;
    @Autowired
    private ActOrderInfoMapper actOrderInfoMapper;
    @Autowired
    private ActFscOrderMapper actFscOrderMapper;
    @Autowired
    private ActOrderInfoMapperUni actOrderInfoMapperUni;
    @Autowired
    private ActivityBaseInfoMapper activityBaseInfoMapper;

    public void saveAlertInfo(DycActDealOrderAlertDO reqBO) {
        ActAlertInfoPO qryAlertPO = new ActAlertInfoPO();
        qryAlertPO.setAlertState(DycActivityConstants.AlertState.DEALING);
        qryAlertPO.setObjId(reqBO.getOrderId());
        qryAlertPO.setAlertType(reqBO.getAlertType());
        qryAlertPO.setObjType(reqBO.getObjType());
        List<ActAlertInfoPO> qryResults = this.actAlertInfoMapper.selectByCondition(qryAlertPO);
        if (!CollectionUtils.isEmpty(qryResults)) {
            ActAlertInfoPO updatePO = new ActAlertInfoPO();
            updatePO.setId(qryResults.get(0).getId());
            updatePO.setAlertState(DycActivityConstants.AlertState.UN_DEAL);
            updatePO.setUpdateTime(new Date());
            this.actAlertInfoMapper.update(updatePO);
        } else {
            ArrayList<ActAlertInfoPO> actAlertInfoPOS = new ArrayList<ActAlertInfoPO>();
            if (StringUtils.isNotBlank((String)reqBO.getOrderId())) {
                ActAlertInfoPO po = new ActAlertInfoPO();
                this.setObjOrgInfo(reqBO.getOrderId(), reqBO.getObjType(), po);
                po.setId(Sequence.getInstance().nextId());
                po.setObjId(reqBO.getOrderId());
                po.setObjType(reqBO.getObjType());
                po.setAlertState(reqBO.getAlertState());
                po.setCreateTime(new Date());
                po.setAlertType(reqBO.getAlertType());
                actAlertInfoPOS.add(po);
                this.actAlertInfoMapper.allInsert(actAlertInfoPOS);
            }
        }
    }

    public int updateAlertInfo(DycActDealOrderAlertDO reqBO) {
        ActAlertInfoPO record = new ActAlertInfoPO();
        record.setAlertState(reqBO.getAlertState());
        record.setIds(reqBO.getUpdAlertInfoList().stream().map(ActUpdateAlertInfo::getId).collect(Collectors.toList()));
        return this.actAlertInfoMapper.batchUpdate(record);
    }

    public ActAlertOrderInfo getAlertInfo(DycActFscOrderDO reqBO) {
        ActAlertInfoPO record = new ActAlertInfoPO();
        record.setObjId(reqBO.getFscOrderId().toString());
        record.setAlertType(reqBO.getOldAlertType());
        record.setAlertState(DycActivityConstants.AlertState.UN_DEAL);
        List<ActAlertInfoPO> actAlertInfoPOS = this.actAlertInfoMapper.selectByCondition(record);
        if (!CollectionUtils.isEmpty(actAlertInfoPOS)) {
            ActAlertOrderInfo actAlertOrderInfo = new ActAlertOrderInfo();
            actAlertOrderInfo.setId(actAlertInfoPOS.get(0).getId());
            actAlertOrderInfo.setOrderId(actAlertInfoPOS.get(0).getObjId());
            return actAlertOrderInfo;
        }
        return null;
    }

    public int updateExpAlertInfo(DycActDealOrderAlertDO reqBO) {
        ActAlertInfoPO actAlertInfoPO = new ActAlertInfoPO();
        actAlertInfoPO.setOldAlertState(reqBO.getAlertState());
        actAlertInfoPO.setAlertState(DycActivityConstants.AlertState.DEALED);
        actAlertInfoPO.setAlertType(reqBO.getAlertType());
        return this.actAlertInfoMapper.updateAlertState(actAlertInfoPO);
    }

    public int updateAlert(DycActDealOrderAlertDO set, DycActDealOrderAlertDO where) {
        ActAlertInfoPO setPo = (ActAlertInfoPO)JUtil.js((Object)set, ActAlertInfoPO.class);
        ActAlertInfoPO wherePo = (ActAlertInfoPO)JUtil.js((Object)where, ActAlertInfoPO.class);
        return this.actAlertInfoMapper.updateBy(setPo, wherePo);
    }

    private void setObjOrgInfo(String objId, Integer objType, ActAlertInfoPO po) {
        if (objType == 1) {
            ActOrderInfoPO actOrderInfoPO = new ActOrderInfoPO();
            actOrderInfoPO.setOrderId(objId);
            actOrderInfoPO = this.actOrderInfoMapper.getCreateInfo(actOrderInfoPO);
            if (!Objects.isNull(actOrderInfoPO)) {
                BeanUtils.copyProperties((Object)actOrderInfoPO, (Object)po);
            }
        } else if (objType == 2) {
            DycActOrderQryDO dycActOrderQryDO = new DycActOrderQryDO();
            dycActOrderQryDO.setAfsServiceId(objId);
            ActAfsOrdInfoUni actAfsOrdInfoUni = this.actOrderInfoMapperUni.selectAfsOrdCreateInfo(dycActOrderQryDO);
            if (!Objects.isNull(actAfsOrdInfoUni)) {
                BeanUtils.copyProperties((Object)actAfsOrdInfoUni, (Object)po);
            }
        } else if (objType == 3) {
            ActFscOrderPO actFscOrderPO = new ActFscOrderPO();
            actFscOrderPO.setFscOrderId(Long.parseLong(objId));
            actFscOrderPO = this.actFscOrderMapper.getActivityCreateInfo(actFscOrderPO);
            if (!Objects.isNull(actFscOrderPO)) {
                BeanUtils.copyProperties((Object)actFscOrderPO, (Object)po);
            }
        } else if (objType == 4) {
            ActivityBaseInfoPO record = new ActivityBaseInfoPO();
            record.setActivityId(Long.parseLong(objId));
            record = this.activityBaseInfoMapper.getActivityBaseInfoDetail(record);
            if (!Objects.isNull(record)) {
                BeanUtils.copyProperties((Object)record, (Object)po);
                po.setCreateOrgPath(record.getCreateOrgTreePath());
            }
        }
    }
}

