/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.ActBatchInfoQryDO;
import com.tydic.dyc.act.model.bo.ActFscOrderBatchInfo;
import com.tydic.dyc.act.model.bo.DycActDealAlertQryOrderDO;
import com.tydic.dyc.act.model.bo.DycActDealOrderAlertDO;
import com.tydic.dyc.act.model.bo.DycActFscOrdSaveInfo;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderFileInfo;
import com.tydic.dyc.act.model.bo.DycActFscOrderFileQryDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderInfo;
import com.tydic.dyc.act.model.bo.DycActFscOrderLogisticsInfoDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderQryDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderSaveDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderSignDO;
import com.tydic.dyc.act.repository.api.DycActFscOrderRepository;
import com.tydic.dyc.act.repository.dao.ActAlertInfoMapper;
import com.tydic.dyc.act.repository.dao.ActFscOrderBatchInfoMapper;
import com.tydic.dyc.act.repository.dao.ActFscOrderMapper;
import com.tydic.dyc.act.repository.dao.ActFscOrderRelationMapper;
import com.tydic.dyc.act.repository.dao.ActivityFileInfoMapper;
import com.tydic.dyc.act.repository.po.ActAlertInfoPO;
import com.tydic.dyc.act.repository.po.ActFscOrderBatchInfoPO;
import com.tydic.dyc.act.repository.po.ActFscOrderPO;
import com.tydic.dyc.act.repository.po.ActFscOrderQryPO;
import com.tydic.dyc.act.repository.po.ActFscOrderRelationPO;
import com.tydic.dyc.act.repository.po.ActivityFileInfoPO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycActFscOrderRepositoryImpl
implements DycActFscOrderRepository {
    @Autowired
    private ActFscOrderMapper actFscOrderMapper;
    @Autowired
    private ActivityFileInfoMapper activityFileInfoMapper;
    @Autowired
    private ActFscOrderBatchInfoMapper actFscOrderBatchInfoMapper;
    @Autowired
    private ActFscOrderRelationMapper actFscOrderRelationMapper;
    @Autowired
    private ActAlertInfoMapper actAlertInfoMapper;

    public int dealPayOrderState(DycActFscOrderDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        int i = this.actFscOrderMapper.update(record);
        return i;
    }

    public int dealSignOrderState(DycActFscOrderSignDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        int i = this.actFscOrderMapper.update(record);
        return i;
    }

    public DycActFscOrderInfo getFscOrderOne(DycActFscOrderDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        ActFscOrderPO actFscOrderPO = this.actFscOrderMapper.getFscOrderOne(record);
        return (DycActFscOrderInfo)JSON.parseObject((String)JSON.toJSONString((Object)actFscOrderPO), DycActFscOrderInfo.class);
    }

    public BasePageRspBo<DycActFscOrderInfo> selectByCondition(DycActFscOrderQryDO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.actFscOrderMapper.selectByCondition(record));
        ArrayList<DycActFscOrderInfo> fscOrderInfos = new ArrayList<DycActFscOrderInfo>();
        for (ActFscOrderPO fscOrderPO : page.getResult()) {
            DycActFscOrderInfo dycActFscOrderInfo = new DycActFscOrderInfo();
            BeanUtils.copyProperties((Object)fscOrderPO, (Object)dycActFscOrderInfo);
            fscOrderInfos.add(dycActFscOrderInfo);
        }
        BasePageRspBo rspPage = new BasePageRspBo();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(fscOrderInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    public List<DycActFscOrderFileInfo> selectFileListByIds(DycActFscOrderFileQryDO reqBO) {
        List<Object> rspBO = new ArrayList<DycActFscOrderFileInfo>();
        ActivityFileInfoPO record = new ActivityFileInfoPO();
        record.setOrderIds(reqBO.getFscOrderIds());
        record.setObjIds(reqBO.getObjIds());
        List<ActivityFileInfoPO> activityFileInfoPOS = this.activityFileInfoMapper.selectByCondition(record);
        if (!CollectionUtils.isEmpty(activityFileInfoPOS)) {
            rspBO = JSON.parseArray((String)JSON.toJSONString(activityFileInfoPOS), DycActFscOrderFileInfo.class);
        }
        return rspBO;
    }

    public int dealOrderState(DycActFscOrderDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        int i = this.actFscOrderMapper.update(record);
        return i;
    }

    public int updateLogisticsInfo(DycActFscOrderLogisticsInfoDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        int i = this.actFscOrderMapper.update(record);
        return i;
    }

    public DycActFscOrdSaveInfo saveFscOrder(DycActFscOrderSaveDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setFscOrderId(Sequence.getInstance().nextId());
        record.setCreateCompanyId(reqBO.getCompanyId());
        record.setCreateCompanyName(reqBO.getCompanyName());
        record.setCreateOperName(reqBO.getName());
        record.setCreateUserId(reqBO.getUserId());
        record.setCreateOrgId(reqBO.getOrgId());
        record.setCreateOrgName(reqBO.getOrgName());
        record.setCreateOrgPath(reqBO.getOrgPath());
        record.setBuildAction(0);
        record.setPayeeId(reqBO.getSupplierId());
        record.setPayeeName(reqBO.getSupplierName());
        record.setPayerId(reqBO.getCompanyId());
        record.setPayerName(reqBO.getCompanyName());
        this.actFscOrderMapper.insert(record);
        DycActFscOrdSaveInfo dycActFscOrdSaveInfo = new DycActFscOrdSaveInfo();
        dycActFscOrdSaveInfo.setFscOrderId(record.getFscOrderId());
        return dycActFscOrdSaveInfo;
    }

    public int getFscPushFailNum(DycActFscOrderDO reqBO) {
        ActFscOrderBatchInfoPO record = new ActFscOrderBatchInfoPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        return this.actFscOrderBatchInfoMapper.getFscPushFailNum(record);
    }

    public List<Long> qryAlertFscOrderList(DycActDealAlertQryOrderDO reqBO) {
        ActFscOrderPO updatePo = new ActFscOrderPO();
        updatePo.setAlertType(Integer.parseInt(reqBO.getAlertFlag()));
        this.actFscOrderMapper.clearAlertType(updatePo);
        ActAlertInfoPO actAlertInfoPO = new ActAlertInfoPO();
        actAlertInfoPO.setAlertType(Integer.parseInt(reqBO.getAlertFlag()));
        actAlertInfoPO.setAlertState(DycActivityConstants.AlertState.DEALING);
        actAlertInfoPO.setOldAlertState(DycActivityConstants.AlertState.UN_DEAL);
        this.actAlertInfoMapper.updateAlertState(actAlertInfoPO);
        ActFscOrderPO record = new ActFscOrderPO();
        if (reqBO.getFscOrderId() != null) {
            record.setFscOrderId(reqBO.getFscOrderId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            record.setFscOrderIds(reqBO.getFscOrderIds());
        }
        record.setDayNum(reqBO.getDayNum());
        if (DycActivityConstants.AlertType.UN_SIGN.equals(Integer.parseInt(reqBO.getAlertFlag()))) {
            return this.actFscOrderMapper.getUnSignFscOrder(record);
        }
        if (DycActivityConstants.AlertType.UN_PAY.equals(Integer.parseInt(reqBO.getAlertFlag()))) {
            return this.actFscOrderMapper.getUnPayFscOrder(record);
        }
        return null;
    }

    public void updateOrderAlertType(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        ActFscOrderPO record = new ActFscOrderPO();
        record.setFscOrderId(Long.parseLong(dycActDealOrderAlertDO.getOrderId()));
        record.setAlertType(dycActDealOrderAlertDO.getAlertType());
        this.actFscOrderMapper.update(record);
    }

    public void updateFscOrderAlertType(DycActFscOrderDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        record.setAlertType(reqBO.getAlertType());
        this.actFscOrderMapper.updateAlertType(record);
    }

    public List<DycActFscOrderDO> getFscOrderWarning(DycActFscOrderQryDO qryDO) {
        ActFscOrderQryPO actFscOrderQryPO = (ActFscOrderQryPO)ActRu.js((Object)qryDO, ActFscOrderQryPO.class);
        List<ActFscOrderPO> fscOrderWarning = this.actFscOrderMapper.getFscOrderWarning(actFscOrderQryPO);
        return ActRu.jsl(fscOrderWarning, DycActFscOrderDO.class);
    }

    public List<DycActFscOrderInfo> queryFscOrderList(DycActFscOrderQryDO qryDo) {
        ActFscOrderPO actFscOrderPo = (ActFscOrderPO)ActRu.js((Object)qryDo, ActFscOrderPO.class);
        List<ActFscOrderPO> actFscOrderPos = this.actFscOrderMapper.selectByCondition(actFscOrderPo);
        return ActRu.jsl(actFscOrderPos, DycActFscOrderInfo.class);
    }

    public List<ActFscOrderBatchInfo> qryBatchInfoList(ActBatchInfoQryDO qryDO) {
        ActFscOrderBatchInfoPO record = new ActFscOrderBatchInfoPO();
        record.setFscOrderId(qryDO.getFscOrderId());
        record.setBatchId(qryDO.getBatchId());
        record.setPushResult(qryDO.getPushResult());
        List<ActFscOrderBatchInfoPO> actFscOrderBatchInfoPOS = this.actFscOrderBatchInfoMapper.selectByCondition(record);
        return JUtil.jsl(actFscOrderBatchInfoPOS, ActFscOrderBatchInfo.class);
    }

    public List<String> qryBatchOrderIds(ActBatchInfoQryDO qryDO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        record.setFscOrderId(qryDO.getFscOrderId());
        record.setBatchId(qryDO.getBatchId());
        List<ActFscOrderRelationPO> actFscOrderRelationPOS = this.actFscOrderRelationMapper.selectByCondition(record);
        return actFscOrderRelationPOS.stream().map(o -> o.getOrderId().toString()).collect(Collectors.toList());
    }
}

