/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.ActSkuCheckInfoBO;
import com.tydic.dyc.act.model.bo.ActSkuCheckInfoRspBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoDO;
import com.tydic.dyc.act.model.bo.ActSkuInfoListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryRspBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoReqBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoRspBO;
import com.tydic.dyc.act.repository.api.DycActSkuInfoRepository;
import com.tydic.dyc.act.repository.dao.ActSkuDetailMapper;
import com.tydic.dyc.act.repository.dao.ActSkuInfoMapper;
import com.tydic.dyc.act.repository.dao.ActSkuPicMapper;
import com.tydic.dyc.act.repository.dao.ActSkuPoolMapper;
import com.tydic.dyc.act.repository.dao.ActSkuVendorMapper;
import com.tydic.dyc.act.repository.po.ActSkuDetailPO;
import com.tydic.dyc.act.repository.po.ActSkuInfoExtPO;
import com.tydic.dyc.act.repository.po.ActSkuInfoPO;
import com.tydic.dyc.act.repository.po.ActSkuPicPO;
import com.tydic.dyc.act.repository.po.ActSkuPoolExtPO;
import com.tydic.dyc.act.repository.po.ActSkuPoolPO;
import com.tydic.dyc.act.repository.po.ActSkuVendorExtPO;
import com.tydic.dyc.act.repository.po.ActSkuVendorPO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actSkuInfoService")
public class DycActSkuInfoRepositoryImpl
implements DycActSkuInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(DycActSkuInfoRepositoryImpl.class);
    @Autowired
    ActSkuInfoMapper actSkuInfoMapper;
    @Autowired
    private ActSkuPoolMapper actSkuPoolMapper;
    @Autowired
    private ActSkuDetailMapper actSkuDetailMapper;
    @Autowired
    private ActSkuPicMapper actSkuPicMapper;
    @Autowired
    private ActSkuVendorMapper actSkuVendorMapper;

    public ActSkuInfoRspBO queryActSkuInfoSingle(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();
        ActSkuInfoExtPO selectActSkuInfoPO = new ActSkuInfoExtPO();
        BeanUtils.copyProperties((Object)actSkuInfoReqBO, (Object)selectActSkuInfoPO);
        List<ActSkuInfoPO> actSkuInfoList = this.actSkuInfoMapper.selectByConditionAll(selectActSkuInfoPO);
        if (actSkuInfoList.size() != 1) {
            if (actSkuInfoList.size() > 1) {
                throw new ZTBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new ZTBusinessException("\u67e5\u8be2\u4fe1\u606f\uff08\u5355\u4e2a\uff09\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        ActSkuInfoBO actSkuInfoBO = new ActSkuInfoBO();
        BeanUtils.copyProperties((Object)actSkuInfoList.get(0), (Object)actSkuInfoBO);
        rspBO.setData(actSkuInfoBO);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public ActSkuInfoListRspBO queryActSkuInfoList(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoListRspBO rspBO = new ActSkuInfoListRspBO();
        ActSkuInfoExtPO selectActSkuInfoPO = new ActSkuInfoExtPO();
        BeanUtils.copyProperties((Object)actSkuInfoReqBO, (Object)selectActSkuInfoPO);
        List<ActSkuInfoPO> actSkuInfoPOList = this.actSkuInfoMapper.selectByCondition(selectActSkuInfoPO);
        ArrayList<ActSkuInfoBO> actSkuInfoBOList = new ArrayList<ActSkuInfoBO>();
        for (ActSkuInfoPO actSkuInfoPO : actSkuInfoPOList) {
            ActSkuInfoBO actSkuInfoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties((Object)actSkuInfoPO, (Object)actSkuInfoBO);
            actSkuInfoBOList.add(actSkuInfoBO);
        }
        rspBO.setData(actSkuInfoBOList);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public ActSkuInfoRspBO addActSkuInfo(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();
        ActSkuInfoPO insertActSkuInfoPO = new ActSkuInfoPO();
        BeanUtils.copyProperties((Object)actSkuInfoReqBO, (Object)insertActSkuInfoPO);
        long id = Sequence.getInstance().nextId();
        insertActSkuInfoPO.setSkuId(id);
        int num = this.actSkuInfoMapper.insert(insertActSkuInfoPO);
        if (num != 1) {
            throw new ZTBusinessException("\u65b0\u589e\u4fe1\u606f\u5931\u8d25\uff1a\u65b0\u589e\u4fe1\u606f\u5931\u8d25");
        }
        ActSkuInfoBO ActSkuInfoBO2 = new ActSkuInfoBO();
        BeanUtils.copyProperties((Object)insertActSkuInfoPO, (Object)ActSkuInfoBO2);
        rspBO.setData(ActSkuInfoBO2);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public ActSkuInfoListRspBO addListActSkuInfo(List<ActSkuInfoReqBO> actSkuInfoReqBO) {
        ActSkuInfoListRspBO rspBO = new ActSkuInfoListRspBO();
        for (int i = 0; i < actSkuInfoReqBO.size(); ++i) {
            long id = Sequence.getInstance().nextId();
            actSkuInfoReqBO.get(i).setSkuId(Long.valueOf(id));
        }
        List insertActSkuInfoPO = JSONObject.parseArray((String)JSONObject.toJSONString(actSkuInfoReqBO), ActSkuInfoPO.class);
        int num = this.actSkuInfoMapper.allInsert(insertActSkuInfoPO);
        if (num != actSkuInfoReqBO.size()) {
            throw new ZTBusinessException("\u65b0\u589e\u4fe1\u606f\u5931\u8d25\uff1a\u65b0\u589e\u4fe1\u606f\u5931\u8d25");
        }
        List lActSkuInfoBO = JSONObject.parseArray((String)JSONObject.toJSONString((Object)insertActSkuInfoPO), ActSkuInfoBO.class);
        rspBO.setData(lActSkuInfoBO);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public ActSkuInfoRspBO updateActSkuInfo(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoPO updateActSkuInfoPO;
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();
        ActSkuInfoExtPO selectActSkuInfoPO = new ActSkuInfoExtPO();
        selectActSkuInfoPO.setSkuId(actSkuInfoReqBO.getSkuId());
        List<ActSkuInfoPO> actSkuInfoList = this.actSkuInfoMapper.selectByCondition(selectActSkuInfoPO);
        if (actSkuInfoList.size() == 1) {
            updateActSkuInfoPO = new ActSkuInfoPO();
            BeanUtils.copyProperties((Object)actSkuInfoReqBO, (Object)updateActSkuInfoPO);
            int num = this.actSkuInfoMapper.update(updateActSkuInfoPO);
            if (num != 1) {
                throw new ZTBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (actSkuInfoList.size() > 1) {
                throw new ZTBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new ZTBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        ActSkuInfoBO actSkuInfoBO = new ActSkuInfoBO();
        BeanUtils.copyProperties((Object)updateActSkuInfoPO, (Object)actSkuInfoBO);
        rspBO.setData(actSkuInfoBO);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public ActSkuInfoRspBO saveActSkuInfo(ActSkuInfoReqBO actSkuInfoReqBO) {
        if (actSkuInfoReqBO.getSkuId() == null) {
            return this.addActSkuInfo(actSkuInfoReqBO);
        }
        return this.updateActSkuInfo(actSkuInfoReqBO);
    }

    public ActSkuInfoRspBO deleteActSkuInfo(ActSkuInfoReqBO actSkuInfoReqBO) {
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();
        ActSkuInfoExtPO selectActSkuInfoPO = new ActSkuInfoExtPO();
        selectActSkuInfoPO.setSkuId(actSkuInfoReqBO.getSkuId());
        List<ActSkuInfoPO> actSkuInfoList = this.actSkuInfoMapper.selectByCondition(selectActSkuInfoPO);
        if (actSkuInfoList.size() == 1) {
            ActSkuInfoPO deleteActSkuInfoPO = new ActSkuInfoPO();
            BeanUtils.copyProperties((Object)actSkuInfoReqBO, (Object)deleteActSkuInfoPO);
            int num = this.actSkuInfoMapper.delete(deleteActSkuInfoPO);
            if (num != 1) {
                throw new ZTBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u5220\u9664\u4fe1\u606f\u5931\u8d25");
            }
        } else {
            if (actSkuInfoList.size() > 1) {
                throw new ZTBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u5b58\u5728\u591a\u6761\u5bf9\u5e94\u7684\u4fe1\u606f");
            }
            throw new ZTBusinessException("\u5220\u9664\u4fe1\u606f\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public Map<Long, ActSkuInfoBO> queryActSkuInfoByIdList(List<Long> skuIds) {
        List<ActSkuInfoExtPO> rspBO = this.actSkuInfoMapper.selectBySkuIdsCondition(skuIds);
        List<ActSkuPoolExtPO> actSkuPoolExtPOS = this.actSkuPoolMapper.selectBySkuIdsCondition(skuIds);
        Map<Object, Object> poolMap = new HashMap();
        if (!CollectionUtils.isEmpty(actSkuPoolExtPOS)) {
            poolMap = actSkuPoolExtPOS.stream().collect(Collectors.groupingBy(ActSkuPoolExtPO::getSkuId));
        }
        HashMap<Long, ActSkuInfoBO> map = new HashMap<Long, ActSkuInfoBO>();
        for (ActSkuInfoExtPO item : rspBO) {
            ActSkuInfoBO infoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties((Object)item, (Object)infoBO);
            if (!poolMap.isEmpty() && poolMap.containsKey(item.getSkuId())) {
                List poolList = (List)poolMap.get(item.getSkuId());
                List poolNameList = poolList.stream().map(ActSkuPoolPO::getPoolName).distinct().collect(Collectors.toList());
                String poolNames = String.join((CharSequence)",", poolNameList);
                infoBO.setPoolNames(poolNames);
            }
            map.put(item.getSkuId(), infoBO);
        }
        return map;
    }

    public ActSkuInfoQryRspBO querySkuPageList(ActSkuInfoQryBO qryBO) {
        ActSkuInfoExtPO qryPO = (ActSkuInfoExtPO)ActRu.js((Object)qryBO, ActSkuInfoExtPO.class);
        Page page = PageHelper.startPage((int)qryBO.getPageNo(), (int)qryBO.getPageSize()).doSelectPage(() -> this.actSkuInfoMapper.getListPage(qryPO));
        if (qryBO.getQryExtMain().booleanValue() && !CollectionUtils.isEmpty((Collection)page.getResult())) {
            List<ActSkuPoolExtPO> skuPoolRelSourceList;
            List<Long> supplierIds = page.getResult().stream().map(ActSkuInfoExtPO::getSupplierId).collect(Collectors.toList());
            List<Long> skuIds = page.getResult().stream().map(ActSkuInfoExtPO::getSkuId).collect(Collectors.toList());
            List guideIds = page.getResult().stream().map(ActSkuInfoExtPO::getGuideId).collect(Collectors.toList());
            ActSkuVendorExtPO vendorExtPO = new ActSkuVendorExtPO();
            vendorExtPO.setVendorIdList(supplierIds);
            List<ActSkuVendorPO> actSkuVendorPOS = this.actSkuVendorMapper.selectByCondition(vendorExtPO);
            Map<Object, Object> supIdToCode = new HashMap();
            if (!CollectionUtils.isEmpty(actSkuVendorPOS)) {
                supIdToCode = actSkuVendorPOS.stream().collect(Collectors.toMap(ActSkuVendorPO::getVendorId, ActSkuVendorPO::getVendorCode));
            }
            ActSkuDetailPO detailPO = new ActSkuDetailPO();
            detailPO.setSkuIds(skuIds);
            List<ActSkuDetailPO> actSkuDetailPOS = this.actSkuDetailMapper.selectByCondition(detailPO);
            Map<Object, Object> detailIdToUrl = new HashMap();
            if (!CollectionUtils.isEmpty(actSkuDetailPOS)) {
                detailIdToUrl = actSkuDetailPOS.stream().collect(Collectors.toMap(ActSkuDetailPO::getSkuId, ActSkuDetailPO::getSkuPcDetailUrl));
            }
            ActSkuPicPO skuPicPO = new ActSkuPicPO();
            skuPicPO.setSkuIds(skuIds);
            skuPicPO.setPicType(1);
            List<ActSkuPicPO> actSkuPicPOS = this.actSkuPicMapper.selectByCondition(skuPicPO);
            Map<Object, Object> picIdToPicUrl = new HashMap();
            if (!CollectionUtils.isEmpty(actSkuPicPOS)) {
                picIdToPicUrl = actSkuPicPOS.stream().collect(Collectors.toMap(ActSkuPicPO::getSkuId, ActSkuPicPO::getSkuPicUrl));
            }
            ArrayList<ActSkuPoolExtPO> actSkuPoolExtPOS = new ArrayList<ActSkuPoolExtPO>();
            ActSkuPoolExtPO actSkuPoolExtPO = new ActSkuPoolExtPO();
            actSkuPoolExtPO.setSkuIdList(skuIds);
            List<ActSkuPoolExtPO> skuPoolRelSkuList = this.actSkuPoolMapper.getListSkuPoolRelSku(actSkuPoolExtPO);
            if (!CollectionUtils.isEmpty(skuPoolRelSkuList)) {
                actSkuPoolExtPOS.addAll(skuPoolRelSkuList);
            }
            if (!CollectionUtils.isEmpty(skuPoolRelSourceList = this.actSkuPoolMapper.getListSkuPoolRelSource(actSkuPoolExtPO))) {
                actSkuPoolExtPOS.addAll(skuPoolRelSourceList);
            }
            log.info("\u5546\u54c1\u6c60\u540d\u79f0\u96c6\u5408\uff1a{}", (Object)JSON.toJSONString(actSkuPoolExtPOS));
            Map<Object, Object> skuIdToPoolName = new HashMap();
            if (!CollectionUtils.isEmpty(actSkuPoolExtPOS)) {
                skuIdToPoolName = actSkuPoolExtPOS.stream().collect(Collectors.groupingBy(ActSkuPoolExtPO::getSkuId));
            }
            for (ActSkuInfoExtPO actSkuInfoExtPO : page.getResult()) {
                if (supIdToCode.containsKey(actSkuInfoExtPO.getSupplierId())) {
                    actSkuInfoExtPO.setSupplierCode((String)supIdToCode.get(actSkuInfoExtPO.getSupplierId()));
                }
                if (detailIdToUrl.containsKey(actSkuInfoExtPO.getSkuId())) {
                    actSkuInfoExtPO.setSkuPcDetailUrl((String)detailIdToUrl.get(actSkuInfoExtPO.getSkuId()));
                }
                if (picIdToPicUrl.containsKey(actSkuInfoExtPO.getSkuId())) {
                    actSkuInfoExtPO.setPicUrl((String)picIdToPicUrl.get(actSkuInfoExtPO.getSkuId()));
                }
                if (!skuIdToPoolName.containsKey(actSkuInfoExtPO.getSkuId())) continue;
                List poolList = (List)skuIdToPoolName.get(actSkuInfoExtPO.getSkuId());
                List poolNameList = poolList.stream().map(ActSkuPoolPO::getPoolName).distinct().collect(Collectors.toList());
                String poolNames = String.join((CharSequence)",", poolNameList);
                actSkuInfoExtPO.setSkuPools(poolNames);
            }
        }
        ActSkuInfoQryRspBO rspBo = new ActSkuInfoQryRspBO();
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int)page.getTotal());
        rspBo.setRows(!CollectionUtils.isEmpty((Collection)page.getResult()) ? ActRu.jsl((List)page.getResult(), ActSkuInfoDO.class) : new ArrayList(0));
        return rspBo;
    }

    public Map<String, ActSkuInfoBO> queryActSkuInfoByCodeList(List<String> extSkuIds) {
        List<ActSkuPoolExtPO> skuPoolRelSourceList;
        List<ActSkuInfoExtPO> rspBO = this.actSkuInfoMapper.selectBySkuCodesCondition(extSkuIds);
        if (CollectionUtils.isEmpty(rspBO)) {
            return new HashMap<String, ActSkuInfoBO>();
        }
        List<Long> skuIds = rspBO.stream().map(ActSkuInfoExtPO::getSkuId).collect(Collectors.toList());
        Long start = System.currentTimeMillis();
        ArrayList<ActSkuPoolExtPO> actSkuPoolExtPOS = new ArrayList<ActSkuPoolExtPO>();
        ActSkuPoolExtPO actSkuPoolExtPO = new ActSkuPoolExtPO();
        actSkuPoolExtPO.setSkuIdList(skuIds);
        List<ActSkuPoolExtPO> skuPoolRelSkuList = this.actSkuPoolMapper.getListSkuPoolRelSku(actSkuPoolExtPO);
        if (!CollectionUtils.isEmpty(skuPoolRelSkuList)) {
            actSkuPoolExtPOS.addAll(skuPoolRelSkuList);
        }
        if (!CollectionUtils.isEmpty(skuPoolRelSourceList = this.actSkuPoolMapper.getListSkuPoolRelSource(actSkuPoolExtPO))) {
            actSkuPoolExtPOS.addAll(skuPoolRelSourceList);
        }
        log.info("\u67e5\u8be2\u5546\u54c1\u6c60\u6240\u82b1\u65f6\u95f4{}", (Object)(System.currentTimeMillis() - start));
        log.info("\u67e5\u8be2\u5546\u54c1\u6c60\u51fa\u53c2{}", (Object)JSONObject.toJSONString(actSkuPoolExtPOS));
        ActSkuDetailPO actSkuDetailPO = new ActSkuDetailPO();
        actSkuDetailPO.setSkuIds(skuIds);
        List<ActSkuDetailPO> actSkuDetailPOS = this.actSkuDetailMapper.selectByCondition(actSkuDetailPO);
        Map<Object, Object> detailMap = new HashMap();
        if (!CollectionUtils.isEmpty(actSkuDetailPOS)) {
            detailMap = actSkuDetailPOS.stream().collect(Collectors.groupingBy(ActSkuDetailPO::getSkuId));
        }
        ActSkuPicPO actSkuPicPO = new ActSkuPicPO();
        actSkuPicPO.setSkuIds(skuIds);
        actSkuPicPO.setPicType(DycActivityConstants.PicType.CZG);
        List<ActSkuPicPO> actSkuPicPOS = this.actSkuPicMapper.selectByCondition(actSkuPicPO);
        Map<Object, Object> picMap = new HashMap();
        if (!CollectionUtils.isEmpty(actSkuPicPOS)) {
            picMap = actSkuPicPOS.stream().collect(Collectors.groupingBy(ActSkuPicPO::getSkuId));
        }
        Map<Object, Object> poolMap = new HashMap();
        if (!CollectionUtils.isEmpty(actSkuPoolExtPOS)) {
            poolMap = actSkuPoolExtPOS.stream().collect(Collectors.groupingBy(ActSkuPoolExtPO::getSkuId));
        }
        HashMap<String, ActSkuInfoBO> map = new HashMap<String, ActSkuInfoBO>();
        for (ActSkuInfoExtPO item : rspBO) {
            ActSkuInfoBO infoBO = new ActSkuInfoBO();
            BeanUtils.copyProperties((Object)item, (Object)infoBO);
            if (poolMap.containsKey(item.getSkuId())) {
                List poolList = (List)poolMap.get(item.getSkuId());
                List poolNameList = poolList.stream().map(ActSkuPoolPO::getPoolName).distinct().collect(Collectors.toList());
                String poolNames = String.join((CharSequence)",", poolNameList);
                infoBO.setPoolNames(poolNames);
            }
            if (picMap.containsKey(item.getSkuId())) {
                List picList = (List)picMap.get(item.getSkuId());
                infoBO.setSkuUrl(((ActSkuPicPO)picList.get(0)).getSkuPicUrl());
            }
            if (detailMap.containsKey(item.getSkuId())) {
                List detailList = (List)detailMap.get(item.getSkuId());
                infoBO.setSkuPcDetailUrl(((ActSkuDetailPO)detailList.get(0)).getSkuPcDetailUrl());
            }
            map.put(item.getExtSkuId(), infoBO);
        }
        return map;
    }

    public ActSkuInfoQryRspBO qrySkuPushInfo(List<Long> skuIds) {
        List<ActSkuInfoExtPO> actSkuInfoExtPOS = this.actSkuInfoMapper.selectSkuInfoByIds(skuIds);
        List rows = JUtil.jsl(actSkuInfoExtPOS, ActSkuInfoDO.class);
        ActSkuInfoQryRspBO rspBO = new ActSkuInfoQryRspBO();
        rspBO.setRows(rows);
        return rspBO;
    }

    public ActSkuCheckInfoRspBO qryCheckSkuInfo(List<Long> skuIds) {
        List<ActSkuInfoExtPO> actSkuInfoExtPOS = this.actSkuInfoMapper.qrySkuCheckInfoByIds(skuIds);
        List rows = JUtil.jsl(actSkuInfoExtPOS, ActSkuCheckInfoBO.class);
        for (ActSkuCheckInfoBO row : rows) {
            if (DycActivityConstants.SkuStatue.ON_SALE.equals(row.getSkuStatus())) {
                row.setSkuState("\u5df2\u4e0a\u67b6");
                continue;
            }
            if (DycActivityConstants.SkuStatue.WITHDRAWN.equals(row.getSkuStatus())) {
                row.setSkuState("\u5df2\u4e0b\u67b6");
                continue;
            }
            if (!DycActivityConstants.SkuStatue.DELETE.equals(row.getSkuStatus())) continue;
            row.setSkuState("\u5df2\u5220\u9664");
        }
        ActSkuCheckInfoRspBO rspBO = new ActSkuCheckInfoRspBO();
        rspBO.setRows(rows);
        return rspBO;
    }

    public ActSkuInfoRspBO modifySkuCheckInfo(ActSkuInfoReqBO reqBO) {
        ActSkuInfoExtPO extPO = new ActSkuInfoExtPO();
        extPO.setSkuIds(reqBO.getSkuIds());
        extPO.setIsAnomalousPic(reqBO.getIsAnomalousPic());
        extPO.setIsAnomalousPrice(reqBO.getIsAnomalousPrice());
        this.actSkuInfoMapper.updateSkuInfo(extPO);
        ActSkuInfoRspBO rspBO = new ActSkuInfoRspBO();
        return rspBO;
    }
}

