package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActOfflineInvoiceItemPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName ActOfflineInvoiceTaskMapper
 * @Author 14051
 * @Date 2024/8/10 14:45
 * @Version 1.0
 **/
@Mapper
@Repository
public interface ActOfflineInvoiceItemMapper {
    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int insert(ActOfflineInvoiceItemPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int allInsert(List<ActOfflineInvoiceItemPO> record);

    /**
     * 根据条件查询指定条件下的外部单号
     * @param record
     * @return
     */
    List<ActOfflineInvoiceItemPO> qryExtOrderByCondition(ActOfflineInvoiceItemPO record);

    /**
     * 按条件更新
     * @param record
     * @return
     */
    int updateByCondition(ActOfflineInvoiceItemPO record);

    /**
     * 查询单条信息
     * @param record
     * @return
     */
    ActOfflineInvoiceItemPO getModelBy(ActOfflineInvoiceItemPO record);

    /**
     * 按条件查询
     * @return
     */
    List<ActOfflineInvoiceItemPO> getList(ActOfflineInvoiceItemPO record);
}
