package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActOrderAfterInfoPO;
import com.tydic.dyc.act.repository.po.ActOrderAfterInfoQryPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActOrderAfterInfoMapper
 * @Description: ActOrderAfterInfoMapper
 * @author: liaoyang
 * @date: 2024年04月02日10:25:15
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActOrderAfterInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActOrderAfterInfoPO>
     * @author: liaoyang
     * @date: 2024年04月02日10:25:15
     */
    List<ActOrderAfterInfoPO> selectByCondition(ActOrderAfterInfoPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日10:25:15
     */
    int delete(ActOrderAfterInfoPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日10:25:15
     */
    int insert(ActOrderAfterInfoPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日10:25:15
     */
    int allInsert(List<ActOrderAfterInfoPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: liaoyang
     * @date: 2024年04月02日10:25:15
     */
    int update(ActOrderAfterInfoPO record);
    /**
     * 查询未响应的服务单列表
     * @param record
     * @return
     */
    List<String> qryUnRespOrderList(ActOrderAfterInfoPO record);

    /**
     * 更新服务单预警类型
     * @param record
     * @return
     */
    int updateAlertType(ActOrderAfterInfoPO record);

    /**
     * 查询预警售后单
     * @param record
     * @return
     */
    List<ActOrderAfterInfoPO> getOrderAfterWaring(ActOrderAfterInfoQryPO record);

    int clearAlertType(ActOrderAfterInfoPO record);

    String getUnFinishAfsOrderId(ActOrderAfterInfoPO record);
}
