package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActPerformanceRiskControlPo;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题：ActPerformanceRiskControlMapper
 * 说明：履约风控统计mapper
 * 时间：2024/5/7
 *
 * @author zhoujie
 */
@Mapper
@Repository
public interface ActPerformanceRiskControlMapper {
    /**
     * 查询福利活动数量
     * @param actPerformanceRiskControlPo 入参
     * @return
     */
    int getActivityBaseInfoCount(ActPerformanceRiskControlPo actPerformanceRiskControlPo);

    /**
     * 查询采购商品数量
     * @param actPerformanceRiskControlPo 入参
     * @return
     */
    Integer getActivitySkuCount(ActPerformanceRiskControlPo actPerformanceRiskControlPo);

    /**
     * 查询福利订单
     * @param actPerformanceRiskControlPo 入参
     * @return
     */
    int getActivityOrderCount(ActPerformanceRiskControlPo actPerformanceRiskControlPo);

    /**
     * 查询预警条数
     * @param qryActPerformanceRiskControlPo 入参
     * @return
     */
    List<ActPerformanceRiskControlPo> qryActAlertInfoCountList(ActPerformanceRiskControlPo qryActPerformanceRiskControlPo);
}
