package com.tydic.dyc.act.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.act.repository.po.ActSkuInfoExtPO;
import com.tydic.dyc.act.repository.po.ActSkuInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActSkuInfoMapper
 * @Description: ActSkuInfoMapper
 * @author: zhouhaifeng
 * @date: 2024年04月02日14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActSkuInfoMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActSkuInfoPO>
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    List<ActSkuInfoPO> selectByCondition(ActSkuInfoExtPO record);

    List<ActSkuInfoPO> selectByConditionAll(ActSkuInfoExtPO record);

    List<ActSkuInfoExtPO> selectByConditionExt(ActSkuInfoExtPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int delete(ActSkuInfoPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int insert(ActSkuInfoPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int allInsert(List<ActSkuInfoPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int update(ActSkuInfoPO record);

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActSkuInfoPO>
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    List<ActSkuInfoExtPO> selectBySkuIdsCondition(@Param("skuIds") List<Long> skuIds);

    List<ActSkuInfoExtPO> selectSkuInfoByIds(@Param("skuIds") List<Long> skuIds);

    List<ActSkuInfoExtPO> qrySkuCheckInfoByIds(@Param("skuIds") List<Long> skuIds);


    /**
     * 根据外部商品id查询商品
     * @param extSkuIds
     * @return
     */
    List<ActSkuInfoExtPO> selectBySkuCodesCondition(@Param("extSkuIds") List<String> extSkuIds);

    List<ActSkuInfoExtPO> getListPage(ActSkuInfoExtPO qryPO);

    List<ActSkuInfoExtPO> getListPageByLowestPrice(ActSkuInfoExtPO qryPO);

    List<ActSkuInfoExtPO> selectByCatalogIds(@Param("catalogIds") List<Long> catalogIds);

    List<ActSkuInfoPO> selectSkuCountByCondition(ActSkuInfoPO qryActSkuInfoPo);

    int updateSkuInfo(ActSkuInfoExtPO record);
}
