package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActSkuPicPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActSkuPicMapper
 * @Description: ActSkuPicMapper
 * @author: zhouhaifeng
 * @date: 2024年04月02日14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActSkuPicMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActSkuPicPO>
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    List<ActSkuPicPO> selectByCondition(ActSkuPicPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int delete(ActSkuPicPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int insert(ActSkuPicPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int allInsert(List<ActSkuPicPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int update(ActSkuPicPO record);
	
}
