package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActSkuPriceLogExtPO;
import com.tydic.dyc.act.repository.po.ActSkuPriceLogPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActSkuPriceLogMapper
 * @Description: ActSkuPriceLogMapper
 * @author: zhouhaifeng
 * @date: 2024年04月02日14:48:30
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActSkuPriceLogMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActSkuPriceLogPO>
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    List<ActSkuPriceLogPO> selectByCondition(ActSkuPriceLogPO record);

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActSkuPriceLogPO>
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    List<ActSkuPriceLogExtPO> selectByConditionExt(ActSkuPriceLogExtPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int delete(ActSkuPriceLogPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int insert(ActSkuPriceLogPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int allInsert(List<ActSkuPriceLogPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhouhaifeng
     * @date: 2024年04月02日14:48:30
     */
    int update(ActSkuPriceLogPO record);

    /**
     * 统计关联方式为商品方式的生效活动中，商品价格变更的数量
     * @param priceLogExtPO
     * @return
     */
    int qryPriceChangeCountByComm(ActSkuPriceLogExtPO priceLogExtPO);


    /**
     * 统计关联方式为类目方式的生效活动中，商品价格变更的数量
     * @param priceLogExtPO
     * @return
     */
    int qryPriceChangeCountByGuide(ActSkuPriceLogExtPO priceLogExtPO);

    List<ActSkuPriceLogPO> qrySkuPriceLog(ActSkuPriceLogExtPO po);
}
