package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActivityChangeRelaCommodityCatalogPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivityChangeRelaCommodityCatalogMapper
 * @Description: ActivityChangeRelaCommodityCatalogMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:43:59
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityChangeRelaCommodityCatalogMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityChangeRelaCommodityCatalogPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    List<ActivityChangeRelaCommodityCatalogPO> selectByCondition(ActivityChangeRelaCommodityCatalogPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int delete(ActivityChangeRelaCommodityCatalogPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int insert(ActivityChangeRelaCommodityCatalogPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int allInsert(List<ActivityChangeRelaCommodityCatalogPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int update(ActivityChangeRelaCommodityCatalogPO record);

    /**
     * 活动变更商品类型移除（批量）服务
     * @param list
     * @return
     */
    int batchRemoveActivityChangeCommodityCatalog(List<ActivityChangeRelaCommodityCatalogPO> list);

    /**
     * 插入单条数据
     *
     * @param activityChangeRelaCommodityCatalogPo 参数对象
     * @return int 影响数量
     */
    int insertNew(ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPo);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") ActivityChangeRelaCommodityCatalogPO set, @Param("where") ActivityChangeRelaCommodityCatalogPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param activityChangeRelaCommodityCatalogPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPo);

    /**
     * 根据条件查询单条数据
     *
     * @param activityChangeRelaCommodityCatalogPo 参数对象
     * @return ActActivityChangeRelaCommodityCatalogPO 结果对象
     */
    ActivityChangeRelaCommodityCatalogPO getModelBy(ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPo);

    /**
     * 根据条件查询列表数据
     *
     * @param activityChangeRelaCommodityCatalogPo 参数对象
     * @return List<ActActivityChangeRelaCommodityCatalogPO> 结果对象
     */
    List<ActivityChangeRelaCommodityCatalogPO> getList(ActivityChangeRelaCommodityCatalogPO activityChangeRelaCommodityCatalogPo);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<ActivityChangeRelaCommodityCatalogPO> list);
}
