package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActivityRelaCommodityCatalogInComExtPO;
import com.tydic.dyc.act.repository.po.ActivityRelaCommodityCatalogInComPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivityRelaCommodityMapper
 * @Description: ActivityRelaCommodityMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:44:00
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityRelaCommodityCatalogInComMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityRelaCommodityCatalogInComPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    List<ActivityRelaCommodityCatalogInComPO> selectByCondition(ActivityRelaCommodityCatalogInComPO record);


    void updateBatch(List<ActivityRelaCommodityCatalogInComPO> list);

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityRelaCommodityCatalogInComPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    List<ActivityRelaCommodityCatalogInComPO> selectByOnShelf(ActivityRelaCommodityCatalogInComPO record);

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityRelaCommodityCatalogInComPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    List<ActivityRelaCommodityCatalogInComPO> selectByOnAll(ActivityRelaCommodityCatalogInComPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int delete(ActivityRelaCommodityCatalogInComPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int insert(ActivityRelaCommodityCatalogInComPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int allInsert(List<ActivityRelaCommodityCatalogInComPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:44:00
     */
    int update(ActivityRelaCommodityCatalogInComPO record);
    int updateByThreeCatalogIds(ActivityRelaCommodityCatalogInComPO record);

    /**
     * 批量删除数据（根据商品id和活动id）
     *
     * @param record
     * @return
     */
    int batchRemoveActivityCommodity(ActivityRelaCommodityCatalogInComExtPO record);

    int selectCountCommodity(ActivityRelaCommodityCatalogInComPO record);

    /**
     * 插入单条数据
     *
     * @param ActivityRelaCommodityCatalogInComPO 参数对象
     * @return int 影响数量
     */
    int insertNew(ActivityRelaCommodityCatalogInComPO ActivityRelaCommodityCatalogInComPO);

    /**
     * 根据条件更新数据
     *
     * @param set   set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") ActivityRelaCommodityCatalogInComPO set, @Param("where") ActivityRelaCommodityCatalogInComPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param ActivityRelaCommodityCatalogInComPO 参数对象
     * @return int 总数量
     */
    int getCheckBy(ActivityRelaCommodityCatalogInComPO ActivityRelaCommodityCatalogInComPO);

    /**
     * 根据条件查询单条数据
     *
     * @param ActivityRelaCommodityCatalogInComPO 参数对象
     * @return ActActivityRelaCommodityCatalogInComPO 结果对象
     */
    ActivityRelaCommodityCatalogInComPO getModelBy(ActivityRelaCommodityCatalogInComPO ActivityRelaCommodityCatalogInComPO);

    /**
     * 根据条件查询列表数据
     *
     * @param ActivityRelaCommodityCatalogInComPO 参数对象
     * @return List<ActActivityRelaCommodityCatalogInComPO> 结果对象
     */
    List<ActivityRelaCommodityCatalogInComPO> getList(ActivityRelaCommodityCatalogInComPO ActivityRelaCommodityCatalogInComPO);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<ActivityRelaCommodityCatalogInComPO> list);

    int updateCommodityState(ActivityRelaCommodityCatalogInComPO record);

    List<ActivityRelaCommodityCatalogInComExtPO> querySkuToActivityBySku(ActivityRelaCommodityCatalogInComExtPO commodityExtPO);

    List<ActivityRelaCommodityCatalogInComExtPO> querySkuToActivityByGuide(ActivityRelaCommodityCatalogInComExtPO commodityExtPO);

    int count(ActivityRelaCommodityCatalogInComExtPO record);


    List<ActivityRelaCommodityCatalogInComExtPO> querySyncFail(ActivityRelaCommodityCatalogInComExtPO commodityExtPO);

    List<ActivityRelaCommodityCatalogInComPO> getComCount(ActivityRelaCommodityCatalogInComPO ActivityRelaCommodityCatalogInComPO);
    List<ActivityRelaCommodityCatalogInComPO> getCatalogTree(ActivityRelaCommodityCatalogInComPO ActivityRelaCommodityCatalogInComPO);

}
