package com.tydic.dyc.act.repository.dao;

import com.tydic.dyc.act.repository.po.ActivityTokenMoneyPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: ActivityTokenMoneyMapper
 * @Description: ActivityTokenMoneyMapper
 * @author: zhoulu
 * @date: 2023年12月11日16:43:59
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Mapper
@Repository
public interface ActivityTokenMoneyMapper {

    /**
     * 描述: 根据条件查询
     *
     * @throws
     * @param: po
     * @return: List<ActivityTokenMoneyPO>
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    List<ActivityTokenMoneyPO> selectByCondition(ActivityTokenMoneyPO record);

    /**
     * 描述: 根据条件删除
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int delete(ActivityTokenMoneyPO record);

    /**
     * 描述: 插入单条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int insert(ActivityTokenMoneyPO record);

    /**
     * 描述: 插入多条数据
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int allInsert(List<ActivityTokenMoneyPO> record);

    /**
     * 描述: 更新单条数据（可选择的）
     *
     * @throws
     * @param: po
     * @return: int
     * @author: zhoulu
     * @date: 2023年12月11日16:43:59
     */
    int update(ActivityTokenMoneyPO record);
	
}
