package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.ActActivityAppraiseInfoDo;
import com.tydic.dyc.act.repository.api.ActActivityAppraiseInfoRepository;
import com.tydic.dyc.act.repository.dao.ActActivityAppraiseInfoMapper;
import com.tydic.dyc.act.repository.dao.ActivityBaseInfoMapper;
import com.tydic.dyc.act.repository.po.ActActivityAppraiseInfoPO;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoPO;
import com.tydic.dyc.act.service.bo.DycActQryAppraiseBo;
import com.tydic.dyc.act.service.bo.DycActQryAppraiseListByPageRspBo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：ActActivityAppraiseInfoRepositoryImpl
 * 说明：活动评价Repository实现类
 * 时间：2024/5/14 3:15 下午
 * 作者：汪成松
 */
@Service
public class ActActivityAppraiseInfoRepositoryImpl implements ActActivityAppraiseInfoRepository {

    @Autowired
    private ActActivityAppraiseInfoMapper actActivityAppraiseInfoMapper;
    @Autowired
    private ActivityBaseInfoMapper activityBaseInfoMapper;
    @Override
    public int insert(ActActivityAppraiseInfoDo actActivityAppraiseInfoDo) {
        ActActivityAppraiseInfoPO actActivityAppraiseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(actActivityAppraiseInfoDo), ActActivityAppraiseInfoPO.class);
        //查询活动上的活动所属组织名称
        ActivityBaseInfoPO infoPO = new ActivityBaseInfoPO();
        infoPO.setActivityId(actActivityAppraiseInfoDo.getActivityId());
        List<ActivityBaseInfoPO> activityBaseInfoPOS = activityBaseInfoMapper.selectByCondition(infoPO);
        if(!CollectionUtils.isEmpty(activityBaseInfoPOS)){
            actActivityAppraiseInfoPo.setCreateOrgName(activityBaseInfoPOS.get(0).getActivityScopeOrgName());
        }
        return actActivityAppraiseInfoMapper.insert(actActivityAppraiseInfoPo);
    }

    @Override
    public int deleteBy(ActActivityAppraiseInfoDo actActivityAppraiseInfoDo) {
        ActActivityAppraiseInfoPO actActivityAppraiseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(actActivityAppraiseInfoDo), ActActivityAppraiseInfoPO.class);
        return actActivityAppraiseInfoMapper.deleteBy(actActivityAppraiseInfoPo);
    }

    @Override
    public int updateById(ActActivityAppraiseInfoDo actActivityAppraiseInfoDo) {
        ActActivityAppraiseInfoPO actActivityAppraiseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(actActivityAppraiseInfoDo), ActActivityAppraiseInfoPO.class);
        return actActivityAppraiseInfoMapper.updateById(actActivityAppraiseInfoPo);
    }

    @Override
    public int updateBy(ActActivityAppraiseInfoDo set, ActActivityAppraiseInfoDo where) {
        ActActivityAppraiseInfoPO poSet = JSONObject.parseObject(JSONObject.toJSONString(set), ActActivityAppraiseInfoPO.class);
        ActActivityAppraiseInfoPO poWhere = JSONObject.parseObject(JSONObject.toJSONString(where), ActActivityAppraiseInfoPO.class);
        return actActivityAppraiseInfoMapper.updateBy(poSet, poWhere);
    }

    @Override
    public int getCheckBy(ActActivityAppraiseInfoDo actActivityAppraiseInfoDo) {
        ActActivityAppraiseInfoPO actActivityAppraiseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(actActivityAppraiseInfoDo), ActActivityAppraiseInfoPO.class);
        return actActivityAppraiseInfoMapper.getCheckBy(actActivityAppraiseInfoPo);
    }

    @Override
    public ActActivityAppraiseInfoDo getModelBy(ActActivityAppraiseInfoDo actActivityAppraiseInfoDo) {
        ActActivityAppraiseInfoPO actActivityAppraiseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(actActivityAppraiseInfoDo), ActActivityAppraiseInfoPO.class);
        ActActivityAppraiseInfoPO modelBy = actActivityAppraiseInfoMapper.getModelBy(actActivityAppraiseInfoPo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy), ActActivityAppraiseInfoDo.class);
    }

    @Override
    public List<ActActivityAppraiseInfoDo> getList(ActActivityAppraiseInfoDo actActivityAppraiseInfoDo) {
        ActActivityAppraiseInfoPO actActivityAppraiseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(actActivityAppraiseInfoDo), ActActivityAppraiseInfoPO.class);
        List<ActActivityAppraiseInfoPO> list = actActivityAppraiseInfoMapper.getList(actActivityAppraiseInfoPo);
        if (CollectionUtils.isNotEmpty(list)) {
            return JSONObject.parseArray(JSONObject.toJSONString(list), ActActivityAppraiseInfoDo.class);
        } else {
            return new ArrayList<>();
        }
    }

    @Override
    public void insertBatch(List<ActActivityAppraiseInfoDo> list) {
        List<ActActivityAppraiseInfoPO> actActivityAppraiseInfoList = JSONObject.parseArray(JSONObject.toJSONString(list), ActActivityAppraiseInfoPO.class);
        actActivityAppraiseInfoMapper.insertBatch(actActivityAppraiseInfoList);
    }

    @Override
    public DycActQryAppraiseListByPageRspBo getListByPage(ActActivityAppraiseInfoDo actActivityAppraiseInfoDo) {
        ActActivityAppraiseInfoPO actActivityAppraiseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(actActivityAppraiseInfoDo), ActActivityAppraiseInfoPO.class);
        Page<ActActivityAppraiseInfoPO> page = PageHelper.startPage(actActivityAppraiseInfoDo.getPageNo(), actActivityAppraiseInfoDo.getPageSize()).doSelectPage(() -> this.actActivityAppraiseInfoMapper.getList(actActivityAppraiseInfoPo));
        if (CollectionUtils.isEmpty(page.getResult())) {
            DycActQryAppraiseListByPageRspBo dycActQryAppraiseListByPageRspBo = new DycActQryAppraiseListByPageRspBo();
            dycActQryAppraiseListByPageRspBo.setPageNo(page.getPageNum());
            dycActQryAppraiseListByPageRspBo.setRows(new ArrayList<>());
            dycActQryAppraiseListByPageRspBo.setTotal(0);
            dycActQryAppraiseListByPageRspBo.setRecordsTotal(0);
            dycActQryAppraiseListByPageRspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            dycActQryAppraiseListByPageRspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return dycActQryAppraiseListByPageRspBo;
        }
        //封装集合
        List<DycActQryAppraiseBo> dycActQryAppraiseBoList = new ArrayList<>();
        for (ActActivityAppraiseInfoPO actActivityAppraiseInfoPoModel : page.getResult()) {
            DycActQryAppraiseBo actQryAppraiseBo = new DycActQryAppraiseBo();
            BeanUtils.copyProperties(actActivityAppraiseInfoPoModel, actQryAppraiseBo);
            dycActQryAppraiseBoList.add(actQryAppraiseBo);
        }
        DycActQryAppraiseListByPageRspBo dycActQryAppraiseListByPageRspBo = new DycActQryAppraiseListByPageRspBo();
        dycActQryAppraiseListByPageRspBo.setPageNo(page.getPageNum());
        dycActQryAppraiseListByPageRspBo.setRows(dycActQryAppraiseBoList);
        dycActQryAppraiseListByPageRspBo.setTotal(page.getPages());
        dycActQryAppraiseListByPageRspBo.setRecordsTotal((int) page.getTotal());
        dycActQryAppraiseListByPageRspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        dycActQryAppraiseListByPageRspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return dycActQryAppraiseListByPageRspBo;
    }
}
