package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.util.IdUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActActivityWarning;
import com.tydic.dyc.act.repository.api.ActActivityWarningRepository;
import com.tydic.dyc.act.repository.dao.ActActivityWarningMapper;
import com.tydic.dyc.act.repository.po.ActActivityWarningPO;
import com.tydic.dyc.act.utils.ActRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题 ActActivityWarningRepositoryImpl
 * 说明 预警记录
 * 时间 2024/4/23 16:27
 *
 * @author 唐富强
 */
@Service
public class ActActivityWarningRepositoryImpl implements ActActivityWarningRepository {

    @Autowired
    private ActActivityWarningMapper actActivityWarningMapper;

    /**
     * 预警记录批量插入
     * @param list
     */
    @Override
    public void allInsert(List<ActActivityWarning> list) {
        List<ActActivityWarningPO> actActivityWarningPOS = new ArrayList<>(list.size());
        Date now = new Date();
        for (ActActivityWarning actActivityWarning:list){
            ActActivityWarningPO actActivityWarningPO = ActRu.js(actActivityWarning, ActActivityWarningPO.class);
            actActivityWarningPO.setId(Sequence.getInstance().nextId());
            actActivityWarningPO.setCreateTime(now);
            actActivityWarningPOS.add(actActivityWarningPO);
        }
        actActivityWarningMapper.allInsert(actActivityWarningPOS);
    }

    @Override
    public void delete(ActActivityWarning record) {
        ActActivityWarningPO actActivityWarningPO = ActRu.js(record,ActActivityWarningPO.class);
        actActivityWarningMapper.delete(actActivityWarningPO);
    }
}
