package com.tydic.dyc.act.repository.impl;

import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.ActActivityWarningModel;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.ActActivityWarning;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityUserInfo;
import com.tydic.dyc.act.service.api.ActGetWarningActivityService;
import com.tydic.dyc.act.service.bo.ActGetWarningActivityReqBO;
import com.tydic.dyc.act.service.bo.ActGetWarningActivityRspBO;
import com.tydic.dyc.act.service.bo.DycActActivityBaseInfoBO;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题 ActGetWarningActivityServiceImpl
 * 说明 预警活动获取
 * 时间 2024/5/6 16:33
 *
 * @author 唐富强
 */
@HTServiceImpl
public class ActGetWarningActivityServiceImpl implements ActGetWarningActivityService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Autowired
    private ActActivityWarningModel actActivityWarningModel;

    @Override
    public ActGetWarningActivityRspBO getWarningActivity(ActGetWarningActivityReqBO reqBO) {
        //处理预警失效的活动
        dealLose(reqBO);
        DycActivityBaseInfo dycActivityBaseInfo = ActRu.js(reqBO,DycActivityBaseInfo.class);
        dycActivityBaseInfo.setAlertType(null);
        List<DycActivityBaseInfo> warningActivity = dycActActivityModel.getWarningActivity(dycActivityBaseInfo);
        ActGetWarningActivityRspBO rspBO = new ActGetWarningActivityRspBO();
        rspBO.setList(ActRu.jsl(warningActivity, DycActActivityBaseInfoBO.class));
        return rspBO;
    }

    /**
     * 处理预警失效的活动
     * @param reqBO
     */
    private void dealLose(ActGetWarningActivityReqBO reqBO){
        DycActivityBaseInfo dycActivityBaseInfo = new DycActivityBaseInfo();
        dycActivityBaseInfo.setAlertType(reqBO.getAlertType());
        dycActivityBaseInfo.setWaringDayEnd(reqBO.getDays());
        List<DycActivityBaseInfo> list = dycActActivityModel.getWarningActivity(dycActivityBaseInfo);
        if(!CollectionUtils.isEmpty(list)){
              for (DycActivityBaseInfo info:list){
                  DycActivityBaseInfo set = new DycActivityBaseInfo();
                  set.setAlertType(DycActivityConstants.AlertType.UN);
                  set.setWarningDay(0);
                  DycActivityBaseInfo where = new DycActivityBaseInfo();
                  where.setActivityId(info.getActivityId());
                  where.setAlertType(reqBO.getAlertType());
                  dycActActivityModel.updateLoseActivityAlertType(set,where);
                  ActActivityWarning actActivityWarning = new ActActivityWarning();
                  actActivityWarning.setObjId(info.getActivityId());
                  actActivityWarning.setObjType(DycActivityConstants.OBJ_TYPE.ACTIVITY);
                  actActivityWarning.setAlterConfigCode(reqBO.getAlterConfigCOde());
                  actActivityWarningModel.delete(actActivityWarning);
              }
        }
//        dycActActivityModel.updateActivityUserInfoBy()
    }
}
