package com.tydic.dyc.act.repository.impl;

import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.ActQryPerformanceRiskControlBusinessEarlyReqBO;
import com.tydic.dyc.act.model.bo.ActQryPerformanceRiskControlBusinessEarlyRspBO;
import com.tydic.dyc.act.model.bo.ActQryPerformanceRiskControlEmployeeWelfareReqBO;
import com.tydic.dyc.act.model.bo.ActQryPerformanceRiskControlEmployeeWelfareRspBO;
import com.tydic.dyc.act.repository.api.ActPerformanceRiskControlRepository;
import com.tydic.dyc.act.repository.dao.ActPerformanceRiskControlMapper;
import com.tydic.dyc.act.repository.dao.ActSkuPriceLogMapper;
import com.tydic.dyc.act.repository.po.ActPerformanceRiskControlPo;
import com.tydic.dyc.act.repository.po.ActSkuPriceLogExtPO;
import com.tydic.dyc.act.utils.ActRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题：DycActPerformanceRiskControlRepositoryImpl
 * 说明：履约风控统计Repository
 * 时间：2024/5/7
 *
 * @author zhoujie
 */
@Service
public class ActPerformanceRiskControlRepositoryImpl implements ActPerformanceRiskControlRepository {

    @Autowired
    private ActPerformanceRiskControlMapper actPerformanceRiskControlMapper;

    @Autowired
    private ActSkuPriceLogMapper actSkuPriceLogMapper;


    @Override
    public ActQryPerformanceRiskControlEmployeeWelfareRspBO qryPerformanceRiskControlEmployeeWelfare(ActQryPerformanceRiskControlEmployeeWelfareReqBO reqBO) {
        //查询福利活动数量（活动生效时间在所选时间周期内）
        ActPerformanceRiskControlPo actPerformanceRiskControlPo = ActRu.js(reqBO, ActPerformanceRiskControlPo.class);
        int activityBaseInfoCount  = actPerformanceRiskControlMapper.getActivityBaseInfoCount(actPerformanceRiskControlPo);
        //查询采购商品数量
        Integer activitySkuCount =  actPerformanceRiskControlMapper.getActivitySkuCount(actPerformanceRiskControlPo);
        //查询福利订单
        int activityOrderCount =  actPerformanceRiskControlMapper.getActivityOrderCount(actPerformanceRiskControlPo);
        ActQryPerformanceRiskControlEmployeeWelfareRspBO rspBO = new ActQryPerformanceRiskControlEmployeeWelfareRspBO();
        rspBO.setActCount(activityBaseInfoCount);
        rspBO.setSkuCount(activitySkuCount != null ? activitySkuCount : 0);
        rspBO.setOrderCount(activityOrderCount);
        return rspBO;
    }

    @Override
    public ActQryPerformanceRiskControlBusinessEarlyRspBO qryPerformanceRiskControlBusinessEarly(ActQryPerformanceRiskControlBusinessEarlyReqBO qryDo) {
        ActQryPerformanceRiskControlBusinessEarlyRspBO rspBO = new ActQryPerformanceRiskControlBusinessEarlyRspBO();
        ActPerformanceRiskControlPo qryActPerformanceRiskControlPo = ActRu.js(qryDo, ActPerformanceRiskControlPo.class);
        List<ActPerformanceRiskControlPo> actPerformanceRiskControlPos = actPerformanceRiskControlMapper.qryActAlertInfoCountList(qryActPerformanceRiskControlPo);
        if(!CollectionUtils.isEmpty(actPerformanceRiskControlPos)){
            for (ActPerformanceRiskControlPo each : actPerformanceRiskControlPos) {
                if(DycActivityConstants.AlertType.UN_SEND.equals(each.getAlertType())){
                    rspBO.setSendOrderCount(each.getAlertCount());
                }else if(DycActivityConstants.AlertType.UN_RECEIVCE.equals(each.getAlertType())){
                    rspBO.setReceiveOrderCount(each.getAlertCount());
                }else if(DycActivityConstants.AlertType.UN_RESPONSE.equals(each.getAlertType())){
                    rspBO.setAfterCount(each.getAlertCount());
                }else if(DycActivityConstants.AlertType.UN_SIGN.equals(each.getAlertType())){
                    rspBO.setReceiveInvoiceCount(each.getAlertCount());
                }else if(DycActivityConstants.AlertType.UN_PAY.equals(each.getAlertType())){
                    rspBO.setPayCount(each.getAlertCount());
                }else if(DycActivityConstants.AlertType.LAST_PAY.equals(each.getAlertType())){
                    rspBO.setLastPayCount(each.getAlertCount());
                }
            }
        }
        //活动同步异常信息
        ActPerformanceRiskControlPo actPerformanceRiskControlPo = new ActPerformanceRiskControlPo();
        actPerformanceRiskControlPo.setCompanyIdWeb(qryDo.getCompanyIdWeb());
        actPerformanceRiskControlPo.setActivitySyncState(DycActivityConstants.ActivitySyncState.FAIL);
        int activityBaseInfoCount = actPerformanceRiskControlMapper.getActivityBaseInfoCount(actPerformanceRiskControlPo);
        rspBO.setActSyncCount(activityBaseInfoCount);
        //活动中商品变价提醒

        ActSkuPriceLogExtPO qryActSkuPriceLogExtPo = new ActSkuPriceLogExtPO();
        qryActSkuPriceLogExtPo.setCompanyId(qryDo.getCompanyIdWeb());
        int priceChangeCountByComm = actSkuPriceLogMapper.qryPriceChangeCountByComm(qryActSkuPriceLogExtPo);
        //int priceChangeCountByGuide = actSkuPriceLogMapper.qryPriceChangeCountByGuide(qryActSkuPriceLogExtPo);
        rspBO.setSkuPriceCount(priceChangeCountByComm);
        return rspBO;
    }
}
