package com.tydic.dyc.act.repository.impl;

import com.tydic.dyc.act.model.bo.ActSysDictionaryBO;
import com.tydic.dyc.act.model.bo.ActSysDictionaryQryBO;
import com.tydic.dyc.act.repository.api.ActSysDictionaryRepository;
import com.tydic.dyc.act.repository.dao.SysDicDictionaryMapper;
import com.tydic.dyc.act.repository.po.SysDicDictionaryPo;
import com.tydic.dyc.act.utils.ActRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 标题 ActSysDictionaryRepositoryImpl
 * 说明
 * 时间 2024/4/11 14:54
 *
 * @author 唐富强
 */
@Service
public class ActSysDictionaryRepositoryImpl implements ActSysDictionaryRepository {

    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;

    /**
     * 字典列表查询
     * @param qryBO
     * @return
     */
    @Override
    public List<ActSysDictionaryBO> getList(ActSysDictionaryQryBO qryBO) {
        SysDicDictionaryPo sysDicDictionaryPo = ActRu.js(qryBO, SysDicDictionaryPo.class);
        List<SysDicDictionaryPo> list = sysDicDictionaryMapper.getList(sysDicDictionaryPo);
        return ActRu.jsl(list,ActSysDictionaryBO.class);
    }
}
