package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActActivityChangeCommodityCatalogInComRepository;
import com.tydic.dyc.act.repository.dao.ActivityChangeRelaCommodityCatalogInComMapper;
import com.tydic.dyc.act.repository.po.*;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogTreeBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

/**
 * 说明：〈活动商品变更基建方法〉实现
 *
 * @author zhoulu
 * @date 2023年12月22日 14:26
 */
@Service
public class DycActActivityChangeCommodityCatalogInComRepositoryImpl implements DycActActivityChangeCommodityCatalogInComRepository {

    @Autowired
    private ActivityChangeRelaCommodityCatalogInComMapper activityChangeRelaCommodityCatalogInComMapper;

    @Override
    public int batchSelectActivityChangeCommodity(DycActivityChangeDO reqBo) {
        if (ObjectUtils.isEmpty(reqBo) || null == reqBo.getChangeId()) {
            throw new ZTBusinessException("入参不能为空或者变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBo.getCommodityList())) {
            throw new ZTBusinessException("商品列表不能为空！");
        }
        List<ActivityChangeRelaCommodityCatalogInComPO> commodityPoList = JSON.parseArray(JSON.toJSONString(reqBo.getCommodityList()), ActivityChangeRelaCommodityCatalogInComPO.class);
        commodityPoList.forEach(item -> {
            item.setRelaId(Sequence.getInstance().nextId());
            item.setChangeId(reqBo.getChangeId());
            item.setDelFlag(0);
            item.setCreateTime(new Date());
            if (item.getFavorableRate() != null) {
                BigDecimal bigDecimal = BigDecimal.valueOf(item.getFavorableRate());
                item.setFavorableRate(bigDecimal.setScale(2, RoundingMode.HALF_UP).doubleValue());
            }
            item.setCreateUserId(reqBo.getCreateUserId());
            item.setCreateUserName(reqBo.getCreateUserName());
            item.setUpdateTime(null);
            item.setUpdateUserId(null);
            item.setUpdateUserName(null);
        });
        int i = activityChangeRelaCommodityCatalogInComMapper.allInsert(commodityPoList);
        if (reqBo.getCommodityList().size() != i) {
            throw new ZTBusinessException("活动变更商品选择（批量）服务失败！");
        }
        return i;
    }

    @Override
    public BasePageRspBo<ActivityChangeRelaCommodityInfo> queryActivityChangeCommodityPageList(ActActivityChangeCommodityInfoQryDO qryDo) {
        BasePageRspBo<ActivityChangeRelaCommodityInfo> rspBo = new BasePageRspBo<>();
        ActActivityChangeCommodityInfoQryPO qryPo = JSON.parseObject(JSON.toJSONString(qryDo), ActActivityChangeCommodityInfoQryPO.class);
        Page<ActActivityChangeCommodityInfoPO> page = PageHelper.startPage(qryDo.getPageNo(), qryDo.getPageSize()).doSelectPage(() -> this.activityChangeRelaCommodityCatalogInComMapper.selectByCondition(qryPo));
        if (ObjectUtils.isEmpty(page)) {
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        List<ActivityChangeRelaCommodityInfo> rows = JSON.parseArray(JSON.toJSONString(page.getResult()), ActivityChangeRelaCommodityInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(rows);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        if (!CollectionUtils.isEmpty(rspBo.getRows())) {
            for (ActivityChangeRelaCommodityInfo info : rspBo.getRows()) {
                info.setCatalogNameStr(info.getFirstCatalogName() + ">" + info.getSecondCatalogName() + ">" + info.getThreeCatalogName());
                if (info.getFavorableRate() != null) {
                    if (info.getFavorableRate() % info.getFavorableRate().intValue() == 0) {
                        info.setFavorableRateStr(info.getFavorableRate().intValue() + "%");
                    } else {
                        info.setFavorableRateStr(info.getFavorableRate() + "%");
                    }
                } else {
                    info.setFavorableRateStr("-");
                }
            }
        }
        return rspBo;
    }

    @Override
    public int batchRemoveActivityChangeCommodity(DycActivityChangeDO reqBO) {
        ActivityChangeRelaCommodityExtPO activityChangeRelaCommodityPo = new ActivityChangeRelaCommodityExtPO();
        activityChangeRelaCommodityPo.setChangeId(reqBO.getChangeId());
        activityChangeRelaCommodityPo.setUpdateTime(new Date());
        activityChangeRelaCommodityPo.setUpdateUserId(reqBO.getUpdateUserId());
        activityChangeRelaCommodityPo.setUpdateUserName(reqBO.getUpdateUserName());
        activityChangeRelaCommodityPo.setSkuIdList(reqBO.getSkuIdList());

        return activityChangeRelaCommodityCatalogInComMapper.batchRemoveActivityChangeCommodity(activityChangeRelaCommodityPo);
    }

    @Override
    public void delete(ActivityChangeRelaCommodityInfo activityChangeRelaCommodityInfo) {
        ActivityChangeRelaCommodityCatalogInComPO activityChangeRelaCommodityPO = ActRu.js(activityChangeRelaCommodityInfo, ActivityChangeRelaCommodityCatalogInComPO.class);
        activityChangeRelaCommodityCatalogInComMapper.delete(activityChangeRelaCommodityPO);
    }

    /**
     * 活动变更已选商品列表
     *
     * @param reqBO
     * @return
     */
    @Override
    public List<ActivityChangeRelaCommodityInfo> getList(ActivityChangeRelaCommodityInfo reqBO) {
        ActActivityChangeCommodityInfoQryPO qryPO = ActRu.js(reqBO, ActActivityChangeCommodityInfoQryPO.class);
        List<ActivityChangeRelaCommodityCatalogInComPO> activityChangeRelaCommodityPOS = activityChangeRelaCommodityCatalogInComMapper.selectByCondition(qryPO);
        return ActRu.jsl(activityChangeRelaCommodityPOS, ActivityChangeRelaCommodityInfo.class);
    }

    @Override
    public void update(ActivityChangeRelaCommodityInfo reqBO) {
        ActivityChangeRelaCommodityCatalogInComPO activityChangeRelaCommodityPO = ActRu.js(reqBO, ActivityChangeRelaCommodityCatalogInComPO.class);
        activityChangeRelaCommodityCatalogInComMapper.update(activityChangeRelaCommodityPO);
    }

    @Override
    public int insertNew(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityCatalogInComPO activityChangeRelaCommodityPo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityCatalogInComPO.class);
        return activityChangeRelaCommodityCatalogInComMapper.insertNew(activityChangeRelaCommodityPo);
    }

    @Override
    public int updateByNew(DycActivityChangeRelaCommodityInfo set, DycActivityChangeRelaCommodityInfo where) {
        ActivityChangeRelaCommodityCatalogInComPO setPo = JSONObject.parseObject(JSONObject.toJSONString(set), ActivityChangeRelaCommodityCatalogInComPO.class);
        ActivityChangeRelaCommodityCatalogInComPO wherePo = JSONObject.parseObject(JSONObject.toJSONString(where), ActivityChangeRelaCommodityCatalogInComPO.class);
        return activityChangeRelaCommodityCatalogInComMapper.updateBy(setPo, wherePo);
    }

    @Override
    public int getCheckByNew(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityCatalogInComPO activityChangeRelaCommodityPo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityCatalogInComPO.class);
        return activityChangeRelaCommodityCatalogInComMapper.getCheckBy(activityChangeRelaCommodityPo);
    }

    @Override
    public DycActivityChangeRelaCommodityInfo getModelByNew(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityCatalogInComPO activityChangeRelaCommodityPo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityCatalogInComPO.class);
        ActivityChangeRelaCommodityCatalogInComPO modelBy = activityChangeRelaCommodityCatalogInComMapper.getModelBy(activityChangeRelaCommodityPo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy), DycActivityChangeRelaCommodityInfo.class);
    }

    @Override
    public List<DycActivityChangeRelaCommodityInfo> getListNew(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityCatalogInComPO activityChangeRelaCommodityPo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityCatalogInComPO.class);
        List<ActivityChangeRelaCommodityCatalogInComPO> list = activityChangeRelaCommodityCatalogInComMapper.getList(activityChangeRelaCommodityPo);
        return JSONObject.parseArray(JSONObject.toJSONString(list), DycActivityChangeRelaCommodityInfo.class);
    }

    @Override
    public void insertBatchNew(List<DycActivityChangeRelaCommodityInfo> list) {
        List<ActivityChangeRelaCommodityCatalogInComPO> listPo = JSONObject.parseArray(JSONObject.toJSONString(list), ActivityChangeRelaCommodityCatalogInComPO.class);
        activityChangeRelaCommodityCatalogInComMapper.insertBatch(listPo);
    }

    @Override
    public void insertBatchSelect(DycActivityChangeRelaCommodityInfo info, Long activityId) {
        activityChangeRelaCommodityCatalogInComMapper.insertIntoSelectCommd(info.getCreateUserId(), info.getCreateUserName(), info.getChangeId(), activityId);
    }

    @Override
    public int updateByThreeCatalogIds(DycActivityChangeRelaCommodityInfo record) {
        ActivityChangeRelaCommodityCatalogInComPO inComPO = JSON.parseObject(JSON.toJSONString(record), ActivityChangeRelaCommodityCatalogInComPO.class);
        return activityChangeRelaCommodityCatalogInComMapper.updateByThreeCatalogIds(inComPO);
    }

    @Override
    public List<DycActivityChangeRelaCommodityInfo> getComCount(DycActivityChangeRelaCommodityInfo reqBo) {
        ActivityChangeRelaCommodityCatalogInComPO activityChangeRelaCommodityPo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeRelaCommodityCatalogInComPO.class);
        List<ActivityChangeRelaCommodityCatalogInComPO> comCount = activityChangeRelaCommodityCatalogInComMapper.getComCount(activityChangeRelaCommodityPo);
        return JSONObject.parseArray(JSONObject.toJSONString(comCount), DycActivityChangeRelaCommodityInfo.class);
    }

    @Override
    public DycActGuideDO querySelectCatalogTree(ActSelectQueryCatalogTreeReqBO reqBO) {
        DycActGuideDO rspBO = new DycActGuideDO();
        ActivityChangeRelaCommodityCatalogInComPO inComPO = new ActivityChangeRelaCommodityCatalogInComPO();
        inComPO.setChangeId(reqBO.getObjId());
        List<ActivityChangeRelaCommodityCatalogInComPO> catalog = activityChangeRelaCommodityCatalogInComMapper.getCatalogTree(inComPO);
        if(CollectionUtils.isEmpty(catalog)){
            return rspBO;
        }
        Map<String, DycActQueryCatalogTreeBO> nodesById = new HashMap<>();
        List<DycActQueryCatalogTreeBO> rootNodes = new ArrayList<>();
        for (ActivityChangeRelaCommodityCatalogInComPO po : catalog) {
            // 创建一级类目节点
            DycActQueryCatalogTreeBO firstCatalogNode = nodesById.computeIfAbsent(po.getFirstCatalogId(), k -> new DycActQueryCatalogTreeBO());
            firstCatalogNode.setGuideCatalogId(Long.valueOf(po.getFirstCatalogId()));
            firstCatalogNode.setCatalogName(po.getFirstCatalogName());
            firstCatalogNode.setCatalogLevel(1);

            // 创建二级类目节点
            DycActQueryCatalogTreeBO secondCatalogNode = nodesById.computeIfAbsent(po.getSecondCatalogId(), k -> new DycActQueryCatalogTreeBO());
            secondCatalogNode.setGuideCatalogId(Long.valueOf(po.getSecondCatalogId()));
            secondCatalogNode.setCatalogName(po.getSecondCatalogName());
            secondCatalogNode.setCatalogLevel(2);
            firstCatalogNode.getCatalogTreeList().add(secondCatalogNode);

            // 创建三级类目节点
            DycActQueryCatalogTreeBO thirdCatalogNode = nodesById.computeIfAbsent(po.getThreeCatalogId(), k -> new DycActQueryCatalogTreeBO());
            thirdCatalogNode.setGuideCatalogId(Long.valueOf(po.getThreeCatalogId()));
            thirdCatalogNode.setCatalogName(po.getThreeCatalogName());
            thirdCatalogNode.setCatalogLevel(3);
            secondCatalogNode.getCatalogTreeList().add(thirdCatalogNode);

            // 如果是一级类目，添加到根节点列表
            if (!nodesById.containsKey(po.getFirstCatalogId())) {
                rootNodes.add(firstCatalogNode);
            }
        }
        rspBO.setCatalogTreeList(rootNodes);
        return rspBO;
    }
}
