package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.util.DesensitizedUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.ActConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.ActivityChangeUserInfo;
import com.tydic.dyc.act.model.bo.ActivityChangeUserInfoQryBO;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo;
import com.tydic.dyc.act.repository.api.DycActActivityChangeUserRepository;
import com.tydic.dyc.act.repository.dao.ActivityChangeUserInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityChangeUserInfoExtPO;
import com.tydic.dyc.act.repository.po.ActivityChangeUserInfoPO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 说明：活动变更用户基建方法〉实现
 *
 * @author zhoulu
 * @date 2023年12月22日 14:25
 */
@Service
public class DycActActivityChangeUserRepositoryImpl implements DycActActivityChangeUserRepository {

    @Autowired
    private ActivityChangeUserInfoMapper activityChangeUserInfoMapper;

    @Value("${LIMIT_SCORES:50000}")
    private BigDecimal LIMIT_SCORES;

    @Override
    public void batchSelectActivityChangeUser(DycActivityChangeDO reqBo) {
        Map<String, ActivityChangeUserInfoPO> collectMap = null;
        List<ActivityChangeUserInfoPO> changeUserInfoPoList = new ArrayList<>();
        //查询是否有已移除的数据，如果是移除直接制为有效即可
        ActivityChangeUserInfoPO activityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        List<String> collect = reqBo.getUserList().stream().map(DycActivityChangeUserInfo::getActUserName).collect(Collectors.toList());
        activityChangeUserInfoPo.setUserNameList(collect);
        activityChangeUserInfoPo.setChangeId(reqBo.getChangeId());
        List<ActivityChangeUserInfoPO> activityChangeUserInfoPoList = activityChangeUserInfoMapper.selectByConditionAll(activityChangeUserInfoPo);
        if (!CollectionUtils.isEmpty(activityChangeUserInfoPoList)) {
            collectMap = activityChangeUserInfoPoList.stream().collect(Collectors.toMap(ActivityChangeUserInfoPO::getUserName, o -> o, (existing, replacement) -> existing));
        }
        for (DycActivityChangeUserInfo item : reqBo.getUserList()) {
            if (collectMap != null && collectMap.get(item.getActUserName()) != null && ActConstants.DelFlag.DEL.equals(collectMap.get(item.getActUserName()).getDelFlag())) {
                ActivityChangeUserInfoPO activityChangeUserInfoPoUpdate = new ActivityChangeUserInfoPO();
                activityChangeUserInfoPoUpdate.setDelFlag(ActConstants.DelFlag.NOT_DEL);
                ActivityChangeUserInfoPO activityChangeUserInfoPoUpdateWhere = new ActivityChangeUserInfoPO();
                activityChangeUserInfoPoUpdateWhere.setId(collectMap.get(item.getActUserName()).getId());
                activityChangeUserInfoMapper.updateBy(activityChangeUserInfoPoUpdate, activityChangeUserInfoPoUpdateWhere);
            } else if (collectMap != null && collectMap.get(item.getActUserName()) != null && ActConstants.DelFlag.NOT_DEL.equals(collectMap.get(item.getActUserName()).getDelFlag())) {
                throw new BaseBusinessException(DycActivityRspConstants.RESP_CODE_ERROR, "选择的用户，在已选列表中存在！");
            } else if (collectMap == null || collectMap.get(item.getActUserName()) == null) {
                ActivityChangeUserInfoPO changeUser = new ActivityChangeUserInfoPO();
                BeanUtils.copyProperties(item, changeUser);
                changeUser.setId(Sequence.getInstance().nextId());
                changeUser.setChangeId(reqBo.getChangeId());
                changeUser.setCreateUserId(reqBo.getCreateUserId());
                changeUser.setCreateUserName(reqBo.getCreateUserName());
                changeUser.setId(Sequence.getInstance().nextId());
                changeUser.setDelFlag(0);
                changeUser.setCreateTime(new Date());
                changeUser.setUserId(item.getActUserId());
                changeUser.setUserName(item.getActUserName());
                changeUser.setName(item.getActName());
                changeUser.setWorkNo(item.getActWorkNo());
                changeUser.setUserOrgId(item.getActUserOrgId());
                changeUser.setUserOrgName(item.getActUserOrgName());
                changeUser.setUpdateUserId(null);
                changeUser.setUpdateUserName(null);
                changeUser.setUpdateTime(null);
                changeUser.setUserCompanyId(item.getActUserCompanyId());
                changeUser.setUserCompanyName(item.getActUserCompanyName());
                changeUser.setUserOrgPath(item.getActUserOrgPath());
                changeUserInfoPoList.add(changeUser);
            }
        }
        if (!CollectionUtils.isEmpty(changeUserInfoPoList)) {
            int i = activityChangeUserInfoMapper.allInsert(changeUserInfoPoList);
            if (i != changeUserInfoPoList.size()) {
                throw new ZTBusinessException("变更用户批量添加失败！");
            }
        }
    }

    @Override
    public BasePageRspBo<ActivityChangeUserInfo> queryActivityChangeUserPageList(ActivityChangeUserInfoQryBO reqBo) {
        ActivityChangeUserInfoPO selectActivityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        BeanUtils.copyProperties(reqBo, selectActivityChangeUserInfoPo);
        selectActivityChangeUserInfoPo.setUserId(reqBo.getActUserId());
        selectActivityChangeUserInfoPo.setUserName(reqBo.getActUserName());
        selectActivityChangeUserInfoPo.setName(reqBo.getActName());
        selectActivityChangeUserInfoPo.setUserId(reqBo.getActUserId());
        selectActivityChangeUserInfoPo.setUserOrgId(reqBo.getActUserOrgId());
        List<ActivityChangeUserInfo> activityChangeUserInfoBoList = new ArrayList<>();
        BasePageRspBo<ActivityChangeUserInfo> rspPage = new BasePageRspBo<>();
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        if (reqBo.getPageNo() == -1 && reqBo.getPageSize() == -1) {
            rspPage.setPageNo(1);
            List<ActivityChangeUserInfoPO> list = activityChangeUserInfoMapper.selectByCondition(selectActivityChangeUserInfoPo);
            if (!CollectionUtils.isEmpty(list)) {
                makeChangeUserData(list, activityChangeUserInfoBoList);
                rspPage.setRows(activityChangeUserInfoBoList);
                rspPage.setRecordsTotal(activityChangeUserInfoBoList.size());
                rspPage.setTotal(1);
            } else {
                rspPage.setTotal(0);
                rspPage.setRecordsTotal(0);
            }
            rspPage.setRows(activityChangeUserInfoBoList);
        }
        Page<ActivityChangeUserInfoPO> page = PageHelper.startPage(reqBo.getPageNo(), reqBo.getPageSize()).doSelectPage(() -> this.activityChangeUserInfoMapper.selectByCondition(selectActivityChangeUserInfoPo));
        //封装集合
        if (!CollectionUtils.isEmpty(page.getResult())) {
            makeChangeUserData(page.getResult(), activityChangeUserInfoBoList);
        }
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityChangeUserInfoBoList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public int count(ActivityChangeUserInfoQryBO reqBo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPO = ActRu.js(reqBo, ActivityChangeUserInfoPO.class);
        return activityChangeUserInfoMapper.count(activityChangeUserInfoPO);
    }

    @Override
    public BigDecimal sumScores(ActivityChangeUserInfoQryBO reqBo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPO = ActRu.js(reqBo, ActivityChangeUserInfoPO.class);
        return activityChangeUserInfoMapper.sumScores(activityChangeUserInfoPO);
    }

    /**
     * 变更单用户数据封装
     */
    private void makeChangeUserData(List<ActivityChangeUserInfoPO> list, List<ActivityChangeUserInfo> activityChangeUserInfoBoList) {
        for (ActivityChangeUserInfoPO activityChangeUserInfoPo : list) {
            ActivityChangeUserInfo activityChangeUserInfoBo = new ActivityChangeUserInfo();
            BeanUtils.copyProperties(activityChangeUserInfoPo, activityChangeUserInfoBo);
            activityChangeUserInfoBo.setPhone(DesensitizedUtil.mobilePhone(activityChangeUserInfoBo.getPhone()));
            activityChangeUserInfoBoList.add(activityChangeUserInfoBo);
        }
    }

    @Override
    public int batchRemoveActivityChangeUser(DycActivityChangeDO reqBo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        BeanUtils.copyProperties(reqBo, activityChangeUserInfoPo);
        activityChangeUserInfoPo.setUpdateTime(new Date());
        return activityChangeUserInfoMapper.updateBatchByUserId(reqBo.getUserIdList(), activityChangeUserInfoPo);
    }

    @Override
    public List<ActivityChangeUserInfo> queryChangeActivityUserList(DycActivityChangeDO dycActivityChangeDO) {
        ActivityChangeUserInfoPO activityChangeUserInfoPO = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPO.setChangeId(dycActivityChangeDO.getChangeId());
        if (!CollectionUtils.isEmpty(dycActivityChangeDO.getUserIdList())) {
            activityChangeUserInfoPO.setUserIdList(dycActivityChangeDO.getUserIdList());
        }
        List<ActivityChangeUserInfoPO> activityChangeUserInfoPOS = activityChangeUserInfoMapper.selectByCondition(activityChangeUserInfoPO);
        return JSON.parseArray(JSON.toJSONString(activityChangeUserInfoPOS), ActivityChangeUserInfo.class);
    }

    @Override
    public int addChangeUser(DycActivityChangeDO dycActivityUserInfo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPO = JSON.parseObject(JSON.toJSONString(dycActivityUserInfo), ActivityChangeUserInfoPO.class);
        activityChangeUserInfoPO.setCreateTime(new Date());
        activityChangeUserInfoPO.setId(Sequence.getInstance().nextId());
        activityChangeUserInfoPO.setDelFlag(0);
        activityChangeUserInfoPO.setUserId(dycActivityUserInfo.getActUserId());
        activityChangeUserInfoPO.setUserName(dycActivityUserInfo.getActUserName());
        activityChangeUserInfoPO.setName(dycActivityUserInfo.getActName());
        activityChangeUserInfoPO.setWorkNo(dycActivityUserInfo.getActWorkNo());
        return activityChangeUserInfoMapper.insert(activityChangeUserInfoPO);
    }

    @Override
    public void batchModifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPo.setChangeId(dycActivityChangeDo.getChangeId());
        activityChangeUserInfoPo.setUserId(dycActivityChangeDo.getActUserId());
        ActivityChangeUserInfoPO activityChangeUserInfoPoModel = activityChangeUserInfoMapper.selectByConditionModel(activityChangeUserInfoPo);
        if (activityChangeUserInfoPoModel == null) {
            throw new ZTBusinessException("没有需要修改的用户");
        }
        ActivityChangeUserInfoPO activityChangeUserInfoPoUpdate = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPoUpdate.setId(activityChangeUserInfoPoModel.getId());
        activityChangeUserInfoPoUpdate.setBalanceScores(dycActivityChangeDo.getGiveScores());
        activityChangeUserInfoPoUpdate.setGiveScores(dycActivityChangeDo.getGiveScores());
        activityChangeUserInfoPoUpdate.setUsedScores(new BigDecimal(0));
        activityChangeUserInfoPoUpdate.setUpdateUserId(dycActivityChangeDo.getUpdateUserId());
        activityChangeUserInfoPoUpdate.setUpdateUserName(dycActivityChangeDo.getUpdateUserName());
        activityChangeUserInfoPoUpdate.setUpdateTime(new Date());
        activityChangeUserInfoMapper.update(activityChangeUserInfoPoUpdate);
    }

    @Override
    public void batchModifyIntegralZeroClearance(DycActivityChangeDO dycActivityChangeDo) {
        ActivityChangeUserInfoPO activityChangeUserInfoPo = JSONObject.parseObject(JSONObject.toJSONString(dycActivityChangeDo), ActivityChangeUserInfoPO.class);
        activityChangeUserInfoMapper.batchModifyIntegralZeroClearance(activityChangeUserInfoPo);
    }

    @Override
    public DycActivityChangeDO qryUserInfoLimitScore(DycActivityChangeDO dycActivityChangeDo) {
        //初始化返回参数
        DycActivityChangeDO dycActivityChangeDoModel = new DycActivityChangeDO();
        ActivityChangeUserInfoPO po = new ActivityChangeUserInfoPO();
        po.setChangeId(dycActivityChangeDo.getChangeId());
        po.setLimitScores(LIMIT_SCORES);
        List<ActivityChangeUserInfoPO> activityChangeUserInfoPoList = activityChangeUserInfoMapper.qryUserInfoLimitScore(po);
        if (CollectionUtils.isEmpty(activityChangeUserInfoPoList)) {
            dycActivityChangeDoModel.setLimitFlag(false);
            dycActivityChangeDoModel.setLimitFlagMessage(null);
        } else {
            dycActivityChangeDoModel.setLimitFlag(true);
            dycActivityChangeDoModel.setLimitFlagMessage("用户" + activityChangeUserInfoPoList.stream()
                    .map(ActivityChangeUserInfoPO::getUserName)
                    .collect(Collectors.joining("，")) + "发放的积分数超" + LIMIT_SCORES + "了，请确认正确发放！");
        }
        return dycActivityChangeDoModel;
    }

    /**
     * 更新活动变更用户
     *
     * @param dycActivityChangeUserInfo
     */
    @Override
    public void update(DycActivityChangeUserInfo dycActivityChangeUserInfo) {
        ActivityChangeUserInfoPO changeUser = ActRu.js(dycActivityChangeUserInfo, ActivityChangeUserInfoPO.class);
        changeUser.setUserId(dycActivityChangeUserInfo.getActUserId());
        changeUser.setUserName(dycActivityChangeUserInfo.getActUserName());
        changeUser.setName(dycActivityChangeUserInfo.getActName());
        changeUser.setWorkNo(dycActivityChangeUserInfo.getActWorkNo());
        changeUser.setUserOrgId(dycActivityChangeUserInfo.getActUserOrgId());
        changeUser.setUserOrgName(dycActivityChangeUserInfo.getActUserOrgName());
        changeUser.setUserCompanyId(dycActivityChangeUserInfo.getActUserCompanyId());
        changeUser.setUserCompanyName(dycActivityChangeUserInfo.getActUserCompanyName());
        changeUser.setUserOrgPath(dycActivityChangeUserInfo.getActUserOrgPath());
        activityChangeUserInfoMapper.update(changeUser);
    }

    @Override
    public List<ActivityChangeUserInfo> queryChangeActivityUserListAll(DycActivityChangeDO dycActivityChangeDO) {
        ActivityChangeUserInfoPO activityChangeUserInfoPo = new ActivityChangeUserInfoPO();
        activityChangeUserInfoPo.setChangeId(dycActivityChangeDO.getChangeId());
        if (!CollectionUtils.isEmpty(dycActivityChangeDO.getUserIdList())) {
            activityChangeUserInfoPo.setUserIdList(dycActivityChangeDO.getUserIdList());
        }
        if (!CollectionUtils.isEmpty(dycActivityChangeDO.getUserNameList())) {
            activityChangeUserInfoPo.setUserNameList(dycActivityChangeDO.getUserNameList());
        }
        List<ActivityChangeUserInfoPO> changeUserInfoPoList = activityChangeUserInfoMapper.selectByConditionAll(activityChangeUserInfoPo);
        return JSON.parseArray(JSON.toJSONString(changeUserInfoPoList), ActivityChangeUserInfo.class);
    }

    @Override
    public List<ActivityChangeUserInfo> selectByChangeId(DycActivityChangeDO dycActivityChangeDO) {
        ActivityChangeUserInfoExtPO infoExtPO = JSON.parseObject(JSON.toJSONString(dycActivityChangeDO), ActivityChangeUserInfoExtPO.class);
        List<ActivityChangeUserInfoExtPO> infoExtPOS = activityChangeUserInfoMapper.selectByChangeId(infoExtPO);
        return JSON.parseArray(JSON.toJSONString(infoExtPOS),ActivityChangeUserInfo.class);
    }

    @Override
    public int delete(DycActivityChangeUserInfo reqBO) {
        ActivityChangeUserInfoPO userInfoPO = new ActivityChangeUserInfoPO();
        userInfoPO.setChangeId(reqBO.getChangeId());
        return activityChangeUserInfoMapper.delete(userInfoPO);
    }

    @Override
    public int insertNew(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeUserInfoPO.class);
        return activityChangeUserInfoMapper.insertNew(insert);
    }

    @Override
    public int updateByNew(DycActivityChangeUserInfo set, DycActivityChangeUserInfo where) {
        ActivityChangeUserInfoPO setPo = JSONObject.parseObject(JSONObject.toJSONString(set), ActivityChangeUserInfoPO.class);
        ActivityChangeUserInfoPO wherePo = JSONObject.parseObject(JSONObject.toJSONString(where), ActivityChangeUserInfoPO.class);
        return activityChangeUserInfoMapper.updateBy(setPo, wherePo);
    }

    @Override
    public int getCheckByNew(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeUserInfoPO.class);
        return activityChangeUserInfoMapper.getCheckBy(insert);
    }

    @Override
    public DycActivityChangeUserInfo getModelByNew(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeUserInfoPO.class);
        ActivityChangeUserInfoPO modelBy = activityChangeUserInfoMapper.getModelBy(qryBo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy), DycActivityChangeUserInfo.class);
    }

    @Override
    public List<DycActivityChangeUserInfo> getListNew(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeUserInfoPO.class);
        List<ActivityChangeUserInfoPO> list = activityChangeUserInfoMapper.getList(qryBo);
        return JSONObject.parseArray(JSONObject.toJSONString(list), DycActivityChangeUserInfo.class);
    }

    @Override
    public void insertBatchNew(List<DycActivityChangeUserInfo> list) {
        List<ActivityChangeUserInfoPO> listPo = JSONObject.parseArray(JSONObject.toJSONString(list), ActivityChangeUserInfoPO.class);
        activityChangeUserInfoMapper.insertBatch(listPo);
    }

    @Override
    public BigDecimal getCheckByNewSoreCount(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO getCheckByNewSoreCount = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeUserInfoPO.class);
        return activityChangeUserInfoMapper.getCheckByNewSoreCount(getCheckByNewSoreCount);
    }

    @Override
    public int getCheckByNewByChangeCheck(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityChangeUserInfoPO.class);
        return activityChangeUserInfoMapper.getCheckByNewByChangeCheck(insert);
    }

    @Override
    public BigDecimal selectbalanceScores(DycActivityChangeUserInfo reqBo) {
        ActivityChangeUserInfoPO userInfoPO = new ActivityChangeUserInfoPO();
        userInfoPO.setChangeId(reqBo.getChangeId());
        return activityChangeUserInfoMapper.selectbalanceScores(userInfoPO);
    }

    @Override
    public void insertBatchSelect(DycActivityChangeUserInfo info, Long activityId) {
        activityChangeUserInfoMapper.insertBatchSelectUser(info.getCreateUserId(),info.getCreateUserName(),info.getChangeId(),activityId);
    }
}
