package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.ActConstants;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.ActActivityCommodityCatalogSumRepository;
import com.tydic.dyc.act.repository.api.DycActActivityRepository;
import com.tydic.dyc.act.repository.dao.ActActivitySyncExternalRecordMapper;
import com.tydic.dyc.act.repository.dao.ActAlertInfoMapper;
import com.tydic.dyc.act.repository.dao.ActivityBaseInfoMapper;
import com.tydic.dyc.act.repository.dao.ActivityRelaCommodityMapper;
import com.tydic.dyc.act.repository.po.*;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 描述: 〈活动实体基建方法实现〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:33
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Slf4j
@Service
public class DycActActivityRepositoryImpl implements DycActActivityRepository {

    @Autowired
    private ActivityBaseInfoMapper activityBaseInfoMapper;
    @Value("${yYLastPayTime:59}" )
    private String yYLastPayTime;

    /**
     * 同步类型 1：活动同步 2：活动变更同步
     */
    private static final Integer OPER_TYPE_CHANGE = 2;

    /**
     * 同步类型 1：活动同步 2：活动变更同步
     */
    private static final Integer OPER_TYPE = 1;

    @Autowired
    private ActAlertInfoMapper actAlertInfoMapper;

    @Autowired
    private ActivityRelaCommodityMapper activityRelaCommodityMapper;
    @Autowired
    private ActActivitySyncExternalRecordMapper actActivitySyncExternalRecordMapper;
    @Autowired
    private ActActivityCommodityCatalogSumRepository actActivityCommodityCatalogSumRepository;

    /**
     * 根据条件查询活动基本信息列表（分页）
     *
     * @param reqBO
     * @return
     */
    @Override
    public BasePageRspBo<DycActivityBaseInfo> queryActivityPageList(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPO = new ActivityBaseInfoPO();
        BasePageRspBo<DycActivityBaseInfo> rspPage = new BasePageRspBo<>();
        BeanUtils.copyProperties(reqBO, selectActivityBaseInfoPO);
        //因为需求变更，取消掉商品同步异常状态，所以改状态也属于同步成功状态
        if (null != selectActivityBaseInfoPO.getActivitySyncState() && selectActivityBaseInfoPO.getActivitySyncState() == 3) {
            selectActivityBaseInfoPO.setActivitySyncStateFlag(1);
            selectActivityBaseInfoPO.setActivitySyncState(null);
        }
        Page<ActivityBaseInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityBaseInfoMapper.selectByTabId(selectActivityBaseInfoPO));

        if (ObjectUtils.isEmpty(page)) {
            rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspPage;
        }

        Map<Long, ActivityRelaCommodityExtPO> extPOMap = getLongActivityRelaCommodityExtPOMap(page);

        //封装集合
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss" );
        SimpleDateFormat sdfStr = new SimpleDateFormat("yyyy-MM-dd" );
        List<DycActivityBaseInfo> activityBaseInfoBOList = new ArrayList<>();
        for (ActivityBaseInfoPO activityBaseInfoPO : page.getResult()) {
            DycActivityBaseInfo activityBaseInfoBO = new DycActivityBaseInfo();
            BeanUtils.copyProperties(activityBaseInfoPO, activityBaseInfoBO);
            activityBaseInfoBO.setInvoiceClassStr(DycActivityTransFieldUtil.InvoiceClass(String.valueOf(activityBaseInfoBO.getInvoiceClass())));
            activityBaseInfoBO.setInvoiceTypeStr(DycActivityTransFieldUtil.ActivityType(String.valueOf(activityBaseInfoBO.getInvoiceType())));
            activityBaseInfoBO.setActivityTypeStr(DycActivityTransFieldUtil.ActivityType(String.valueOf(activityBaseInfoBO.getActivityType())));
            activityBaseInfoBO.setActivityPayModeStr(DycActivityTransFieldUtil.ActivityPayMode(String.valueOf(activityBaseInfoBO.getActivityPayMode())));
            activityBaseInfoBO.setActivityStateStr(DycActivityTransFieldUtil.ActivityState(activityBaseInfoBO.getActivityState()));
            activityBaseInfoBO.setCommodityRelaMethodStr(DycActivityTransFieldUtil.CommodityRelaMethodSTR(String.valueOf(activityBaseInfoBO.getCommodityRelaMethod())));
            String startTime = sdf.format(activityBaseInfoPO.getActivityStartTime());
            String endTime = sdf.format(activityBaseInfoPO.getActivityEndTime());
            activityBaseInfoBO.setActivityStartToEndTime(startTime + "-" + endTime);
            activityBaseInfoBO.setActivitySyncStateStr(DycActivityTransFieldUtil.ActivitySyncState(String.valueOf(activityBaseInfoPO.getActivitySyncState())));
            if (null != activityBaseInfoPO.getLastPayTime()) {
                activityBaseInfoBO.setLastPayTimeStr(sdfStr.format(activityBaseInfoPO.getLastPayTime()));
            }
            if (null != activityBaseInfoPO.getYyLastPayTime()) {
                activityBaseInfoBO.setYyLastPayTimeStr(sdfStr.format(activityBaseInfoPO.getYyLastPayTime()));
            }
            if (!extPOMap.isEmpty() && extPOMap.containsKey(activityBaseInfoPO.getActivityId())) {
                ActivityRelaCommodityExtPO po = extPOMap.get(activityBaseInfoPO.getActivityId());
                activityBaseInfoBO.setSyncStateStr("成功：" + po.getSuccessCount() + "\n" + "失败：" + po.getFailCount());
            }

            activityBaseInfoBOList.add(activityBaseInfoBO);
        }

        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityBaseInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        rspPage.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspPage.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspPage;
    }

    private Map<Long, ActivityRelaCommodityExtPO> getLongActivityRelaCommodityExtPOMap(Page<ActivityBaseInfoPO> page) {
        //查询同步失败的商品个数
        Map<Long, ActivityRelaCommodityExtPO> extPOMap = new HashMap<>();
        List<Long> collect = new ArrayList<>();
        List<Long> catalog = new ArrayList<>();
        for (ActivityBaseInfoPO item : page.getResult()) {
            //同步状态
            Integer syncState = item.getActivitySyncState();
            //活动id
            Long activityId = item.getActivityId();
            //商品总数
            Integer totalCommodity = item.getTotalCommodity();
            //商品关联方式
            Integer commodityRelaMethod = item.getCommodityRelaMethod();

            if (!ObjectUtils.isEmpty(syncState)) {
                if (syncState == 5 && commodityRelaMethod == 3) {
                    //部分同步成功
                    collect.add(activityId);
                } else if (syncState == 3 && commodityRelaMethod == 3) {
                    //关联方式为商品才会有数据
                    ActivityRelaCommodityExtPO extPO = new ActivityRelaCommodityExtPO();
                    extPO.setActivityId(activityId);
                    //同步成功，全成功
                    extPO.setSuccessCount(totalCommodity);
                    extPO.setFailCount(0);
                    extPOMap.put(activityId, extPO);
                } else if (syncState == 4 && commodityRelaMethod == 3) {
                    ActivityRelaCommodityExtPO extPO = new ActivityRelaCommodityExtPO();
                    extPO.setActivityId(activityId);
                    //同步失败，分为2中情况，1、商品同步失败导致，2、商品同步成功，其他同步失败导致
                    ActActivitySyncExternalRecordPO recordPO = new ActActivitySyncExternalRecordPO();
                    recordPO.setObjId(activityId);
                    List<ActActivitySyncExternalRecordPO> recordPOS = actActivitySyncExternalRecordMapper.selectByCondition(recordPO);
                    for (ActActivitySyncExternalRecordPO temp : recordPOS) {
                        if ("SYNC_BASE_INFO".equals(temp.getSyncStep()) && !"SUCCESS".equals(temp.getSyncResult())) {
                            break;
                        }
                        if ("SYNC_COMMODITY".equals(temp.getSyncStep()) && "SUCCESS".equals(temp.getSyncResult())) {
                            extPO.setSuccessCount(totalCommodity);
                            extPO.setFailCount(0);
                            extPOMap.put(activityId, extPO);
                            break;
                        }
                        if ("SYNC_COMMODITY".equals(temp.getSyncStep()) && "FAIL".equals(temp.getSyncResult())) {
                            collect.add(activityId);
                            break;
                        }
                    }
                } else if (syncState == 5 && commodityRelaMethod == 2) {
                    catalog.add(activityId);
                }
            }
        }
        if (!collect.isEmpty()) {
            ActivityRelaCommodityExtPO extPO = new ActivityRelaCommodityExtPO();
            extPO.setActIds(collect);
            List<ActivityRelaCommodityExtPO> extPOList = activityRelaCommodityMapper.querySyncFail(extPO);
            Map<Long, ActivityRelaCommodityExtPO> poMap = extPOList.stream().collect(Collectors.toMap(ActivityRelaCommodityExtPO::getActivityId, Function.identity()));
            extPOMap.putAll(poMap);
        }
        if (!CollectionUtils.isEmpty(catalog)) {
            ActActivityCommodityCatalogSumDO catalogSumDO = new ActActivityCommodityCatalogSumDO();
            catalogSumDO.setActIds(catalog);
            List<ActActivityCommodityCatalogSumInfo> sumInfos = actActivityCommodityCatalogSumRepository.queryActActivityCommodityCatalogSumList(catalogSumDO);
            sumInfos.forEach(item -> {
                ActivityRelaCommodityExtPO extPO = new ActivityRelaCommodityExtPO();
                extPO.setActivityId(item.getActivityId());
                extPO.setSuccessCount(item.getSuccessCount());
                extPO.setFailCount(item.getFailCount());
                extPOMap.put(item.getActivityId(), extPO);
            });
        }
        return extPOMap;
    }

    @Override
    public List<DycActivityBaseInfo> queryActivityList(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPo = new ActivityBaseInfoPO();
        BeanUtils.copyProperties(reqBO, selectActivityBaseInfoPo);
        List<ActivityBaseInfoPO> activityBaseInfoPoList = activityBaseInfoMapper.selectByCondition(selectActivityBaseInfoPo);
        //封装集合
        List<DycActivityBaseInfo> activityBaseInfoBOList = new ArrayList<>();
        if (CollectionUtils.isEmpty(activityBaseInfoPoList)) {
            return new ArrayList<>();
        }
        for (ActivityBaseInfoPO activityBaseInfoPo : activityBaseInfoPoList) {
            DycActivityBaseInfo activityBaseInfoBo = new DycActivityBaseInfo();
            BeanUtils.copyProperties(activityBaseInfoPo, activityBaseInfoBo);
            activityBaseInfoBo.setActivityStateStr(DycActivityTransFieldUtil.ActivityState(activityBaseInfoPo.getActivityState()));
            activityBaseInfoBo.setActivityTypeStr(DycActivityTransFieldUtil.ActivityType(String.valueOf(activityBaseInfoPo.getActivityType())));
            activityBaseInfoBo.setActivityPayModeStr(DycActivityTransFieldUtil.ActivityPayMode(String.valueOf(activityBaseInfoPo.getActivityPayMode())));
            activityBaseInfoBo.setCommodityRelaMethodStr(DycActivityTransFieldUtil.CommodityRelaMethodSTR(String.valueOf(activityBaseInfoPo.getCommodityRelaMethod())));
            activityBaseInfoBOList.add(activityBaseInfoBo);
        }
        return activityBaseInfoBOList;
    }

    @Override
    public List<DycActivityBaseInfo> queryActivityId(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPo = new ActivityBaseInfoPO();
        BeanUtils.copyProperties(reqBO, selectActivityBaseInfoPo);
        List<ActivityBaseInfoPO> activityBaseInfoPoList = activityBaseInfoMapper.selectByConditionId(selectActivityBaseInfoPo);
        return JSON.parseArray(JSON.toJSONString(activityBaseInfoPoList), DycActivityBaseInfo.class);
    }


    /**
     * 描述:活动基本详情保存
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityBaseInfo
     */
    @Override
    public DycActivityBaseInfo saveActiveBaseInfo(DycActiveBaseInfoSaveReqBO reqBO) {
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        if (null == reqBO.getActivityId()) {
            //新增
            ActivityBaseInfoPO insertBO = new ActivityBaseInfoPO();
            BeanUtils.copyProperties(reqBO, insertBO);

            insertBO.setActivityId(Sequence.getInstance().nextId());
            insertBO.setActivityVersion(1);
            insertBO.setActivityState("1");
            insertBO.setDelFlag(0);
            insertBO.setCreateTime(new Date());
            insertBO.setIsSettleFlag(0);

            insertBO.setCreateCompanyId(reqBO.getCompanyId());
            insertBO.setCreateCompanyName(reqBO.getCompanyName());
            insertBO.setCreateOrgId(reqBO.getOrgId());
            insertBO.setCreateOrgName(reqBO.getOrgName());
            insertBO.setCreateOrgTreePath(reqBO.getOrgTreePathIn());

            //最后付款日期运营时间
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(reqBO.getActivityStartTime());
            calendar.add(Calendar.DAY_OF_MONTH, Integer.parseInt(yYLastPayTime));
            Date later = calendar.getTime();
            insertBO.setYyLastPayTime(later);

            //最后付款日期
            if (StringUtils.hasText(reqBO.getJnPayDay())) {
                Calendar calendarLast = Calendar.getInstance();
                calendarLast.setTime(insertBO.getYyLastPayTime());
                calendarLast.add(Calendar.DAY_OF_MONTH, -Integer.parseInt(reqBO.getJnPayDay()));
                Date laterLast = calendarLast.getTime();
                insertBO.setLastPayTime(laterLast);
            }

            activityBaseInfoMapper.insert(insertBO);
            rspBO.setActivityId(insertBO.getActivityId());
        } else {
            //修改
            ActivityBaseInfoPO baseInfoPO = new ActivityBaseInfoPO();
            BeanUtils.copyProperties(reqBO, baseInfoPO);

            if (null != baseInfoPO.getActivityStartTime()) {
                //最后付款日期运营时间
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(reqBO.getActivityStartTime());
                calendar.add(Calendar.DAY_OF_MONTH, Integer.parseInt(yYLastPayTime));
                Date later = calendar.getTime();
                baseInfoPO.setYyLastPayTime(later);

                //最后付款日期
                if (StringUtils.hasText(reqBO.getJnPayDay())) {
                    Calendar calendarLast = Calendar.getInstance();
                    calendarLast.setTime(baseInfoPO.getYyLastPayTime());
                    calendarLast.add(Calendar.DAY_OF_MONTH, -Integer.parseInt(reqBO.getJnPayDay()));
                    Date laterLast = calendarLast.getTime();
                    baseInfoPO.setLastPayTime(laterLast);
                }
            }

            baseInfoPO.setCreateUserId(null);
            baseInfoPO.setCreateUserName(null);
            baseInfoPO.setCreateOrgId(null);
            baseInfoPO.setCreateOrgName(null);
            baseInfoPO.setCreateCompanyId(null);
            baseInfoPO.setCreateCompanyName(null);
            baseInfoPO.setCreateOrgTreePath(null);
            if (null != reqBO.getActOrgId()) {
                baseInfoPO.setCreateOrgId(reqBO.getActOrgId());
            }
            if (StringUtils.hasText(reqBO.getActOrgName())) {
                baseInfoPO.setCreateOrgName(reqBO.getActOrgName());
            }
            if (null != reqBO.getActCompanyId()) {
                baseInfoPO.setCreateCompanyId(reqBO.getActCompanyId());
            }
            if (StringUtils.hasText(reqBO.getActCompanyName())) {
                baseInfoPO.setCreateCompanyName(reqBO.getActCompanyName());
            }
            if (StringUtils.hasText(reqBO.getActOrgTreePathIn())) {
                baseInfoPO.setCreateOrgTreePath(reqBO.getActOrgTreePathIn());
            }
            baseInfoPO.setUpdateTime(new Date());
            baseInfoPO.setUpdateUserId(reqBO.getCreateUserId());
            baseInfoPO.setUpdateUserName(reqBO.getCreateUserName());
            //判断是否进行商品价格区间的修改
            if (reqBO.getIsUpdatePriceRange() != null && reqBO.getIsUpdatePriceRange()) {
                //如果等于null，需要更改为null
                if (baseInfoPO.getMaxPrice() == null) {
                    baseInfoPO.setIsMaxPriceNull("1" );
                }
                if (baseInfoPO.getMinPrice() == null) {
                    baseInfoPO.setIsMinPriceNull("1" );
                }
            }
            activityBaseInfoMapper.updateBase(baseInfoPO);
        }
        return rspBO;
    }

    @Override
    public int changeActivityState(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！" );
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！" );
        }
        if (StringUtils.isEmpty(reqBO.getActivityState())) {
            throw new ZTBusinessException("活动状态不能为空！" );
        }
        ActivityBaseInfoPO activityBaseInfoPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityBaseInfoPO.class);
        activityBaseInfoPO.setUpdateTime(new Date());
        return activityBaseInfoMapper.update(activityBaseInfoPO);
    }

    @Override
    public int deleteActivity(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！" );
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！" );
        }
        ActivityBaseInfoPO infoPO = new ActivityBaseInfoPO();
        infoPO.setActivityId(reqBO.getActivityId());
        List<ActivityBaseInfoPO> infoPOS = activityBaseInfoMapper.selectByCondition(infoPO);
        if (!DycActivityConstants.ActivityState.ACTIVITY_STATE_ONE.equals(infoPOS.get(0).getActivityState())
                && !DycActivityConstants.ActivityState.ACTIVITY_STATE_THREE.equals(infoPOS.get(0).getActivityState())) {
            throw new ZTBusinessException("当前活动状态不允许删除！" );
        }

        ActivityBaseInfoPO activityBaseInfoPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityBaseInfoPO.class);
        activityBaseInfoPO.setUpdateTime(new Date());
        //如果有预警信息需要变更为已处理（即删除）
        ActAlertInfoPO actAlertInfoPO = new ActAlertInfoPO();
        actAlertInfoPO.setObjId(reqBO.getActivityId().toString());
        actAlertInfoPO.setAlertType(DycActivityConstants.AlertType.LAST_PAY);
        actAlertInfoPO.setAlertState(DycActivityConstants.AlertState.UN_DEAL);
        List<ActAlertInfoPO> actAlertInfoPOS = actAlertInfoMapper.selectByCondition(actAlertInfoPO);
        if (!CollectionUtils.isEmpty(actAlertInfoPOS)) {
            ActAlertInfoPO alertInfoPO = actAlertInfoPOS.get(0);
            ActAlertInfoPO set = new ActAlertInfoPO();
            set.setAlertState(DycActivityConstants.AlertState.DEALED);
            set.setUpdateTime(new Date());
            ActAlertInfoPO where = new ActAlertInfoPO();
            where.setObjId(alertInfoPO.getObjId());
            where.setAlertState(DycActivityConstants.AlertState.UN_DEAL);
            where.setAlertType(DycActivityConstants.AlertType.LAST_PAY);
            actAlertInfoMapper.updateBy(set, where);
        }
        return activityBaseInfoMapper.deleteActivity(activityBaseInfoPO);
    }

    @Override
    public List<Long> autoEffectActivity(DycActivityDO reqBO) {
        ActivityBaseInfoPO activityBaseInfoPO = new ActivityBaseInfoPO();
        Date now = new Date();
        activityBaseInfoPO.setActivityState(DycActivityConstants.ActivityState.ACTIVITY_STATE_FOUR);
        activityBaseInfoPO.setActivitySyncState(DycActivityConstants.ActivitySyncState.SUCCESS);
        activityBaseInfoPO.setActivityEndTimeStart(now);
        activityBaseInfoPO.setActivityStartTimeEnd(now);
        activityBaseInfoPO.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        List<ActivityBaseInfoPO> list = activityBaseInfoMapper.getList(activityBaseInfoPO);
        if (CollectionUtils.isEmpty(list)) {
            list = new ArrayList<>();
        }
        //添加部分同步成功也算成功
        ActivityBaseInfoPO baseInfoPartPO = new ActivityBaseInfoPO();
        baseInfoPartPO.setActivityState(DycActivityConstants.ActivityState.ACTIVITY_STATE_FOUR);
        baseInfoPartPO.setActivitySyncState(DycActivityConstants.ActivitySyncState.PART_SUCCESS);
        baseInfoPartPO.setActivityEndTimeStart(now);
        baseInfoPartPO.setActivityStartTimeEnd(now);
        baseInfoPartPO.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        List<ActivityBaseInfoPO> poList = activityBaseInfoMapper.getList(baseInfoPartPO);
        if (!CollectionUtils.isEmpty(poList)) {
            list.addAll(poList);
        }
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<>(0);
        }
        for (ActivityBaseInfoPO baseInfoPO : list) {
            baseInfoPO.setUpdateTime(new Date());
            baseInfoPO.setUpdateUserId(1L);
            baseInfoPO.setUpdateUserName("系统自动" );
            baseInfoPO.setActivityState(DycActivityConstants.ActivityState.ACTIVITY_STATE_FIVE);
        }
        try {
            activityBaseInfoMapper.batchUpdate(list);
        } catch (Exception e) {
            e.printStackTrace();
            throw new BaseBusinessException(DycActivityRspConstants.RESP_CODE_ERROR, "修改活动状态为已生效失败！" );
        }
        return list.stream().map(ActivityBaseInfoPO::getActivityId).distinct().collect(Collectors.toList());
    }

    @Override
    public DycActivityBaseInfo autoLoseEffectActivity(DycActivityDO reqBO) {
        ActivityBaseInfoPO activityBaseInfoPO = new ActivityBaseInfoPO();
        activityBaseInfoPO.setActivityEndTimeEnd(new Date());
//        activityBaseInfoPO.setActivityCycleType(DycActivityConstants.ActivityCycleType.FINITUDE);
        activityBaseInfoPO.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        activityBaseInfoPO.setActivityStateList(Arrays.asList(DycActivityConstants.ActivityState.ACTIVITY_STATE_FIVE, DycActivityConstants.ActivityState.ACTIVITY_STATE_SIX));
        List<ActivityBaseInfoPO> activityBaseInfoPOS = activityBaseInfoMapper.getList(activityBaseInfoPO);
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        if (CollectionUtils.isEmpty(activityBaseInfoPOS)) {
            return rspBO;
        }
        activityBaseInfoPOS.forEach(item -> {
            if (item.getActivityCycleType() == null
                    || DycActivityConstants.ActivityCycleType.FINITUDE.equals(item.getActivityCycleType())) {
                item.setActivityState(DycActivityConstants.ActivityState.ACTIVITY_STATE_SEVEN);
                item.setUpdateUserId(1L);
                item.setUpdateUserName("系统自动" );
                item.setUpdateTime(new Date());
            }

        });
        activityBaseInfoMapper.batchUpdate(activityBaseInfoPOS);
        return rspBO;
    }

    @Override
    public BasePageRspBo<DycActActivityApproveBaseInfo> queryActivityApprovePageList(DycProcessDO reqBO) {
        BasePageRspBo<DycActActivityApproveBaseInfo> rspBo = new BasePageRspBo<>();
        ActivityBaseInfoTimePO activityBaseInfoTimePO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityBaseInfoTimePO.class);
        List<Integer> status = DycActivityTransFieldUtil.TaskStatus(activityBaseInfoTimePO.getTabId());
        activityBaseInfoTimePO.setPendingAuditUserId(reqBO.getUserId());
        Page<DycActActivityApproveBaseInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityBaseInfoMapper.queryActivityApprovePageList(activityBaseInfoTimePO, status));

        if (ObjectUtils.isEmpty(page)) {
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        //封装集合
        List<DycActActivityApproveBaseInfo> activityBaseInfoBOList = JSON.parseArray(JSON.toJSONString(page.getResult()), DycActActivityApproveBaseInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(activityBaseInfoBOList);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public int updateActivityState(DycActivityDO reqBO) {
        //初始化时间
        Date date = new Date();
        ActivityBaseInfoPO infoPO = new ActivityBaseInfoPO();
        BeanUtils.copyProperties(reqBO, infoPO);
        infoPO.setUpdateTime(date);
        //同步成功处理数据
        if (ActConstants.SyncState.SUCCESS.equals(reqBO.getActivitySyncState()) || ActConstants.SyncState.PART_SUCCESS.equals(reqBO.getActivitySyncState())) {
            //查询活动信息
            ActivityBaseInfoPO modelBy = getActivityBaseInfoPo(reqBO);
            //处理活动状态
            dealState(reqBO, date, infoPO, modelBy);
        }
        return activityBaseInfoMapper.update(infoPO);
    }

    /**
     * 处理活动状态
     *
     * @param reqBO
     * @param date
     * @param infoPO
     * @param modelBy
     */
    private void dealState(DycActivityDO reqBO, Date date, ActivityBaseInfoPO infoPO, ActivityBaseInfoPO modelBy) {
        if (OPER_TYPE.equals(reqBO.getOperTypeSync()) && (date.compareTo(modelBy.getActivityEndTime()) <= 0 && date.compareTo(modelBy.getActivityStartTime()) >= 0)) {
            infoPO.setActivityState(ActConstants.ActivityState.ACTIVE);
        } else if (OPER_TYPE_CHANGE.equals(reqBO.getOperTypeSync()) && (date.compareTo(modelBy.getActivityEndTime()) <= 0 && date.compareTo(modelBy.getActivityStartTime()) >= 0)) {
            infoPO.setActivityState(ActConstants.ActivityState.ACTIVE);
        } else if (OPER_TYPE_CHANGE.equals(reqBO.getOperTypeSync()) && date.compareTo(modelBy.getActivityEndTime()) > 0) {
            infoPO.setActivityState(ActConstants.ActivityState.FAILURE);
        } else if (OPER_TYPE.equals(reqBO.getOperTypeSync()) && date.compareTo(modelBy.getActivityEndTime()) > 0) {
            infoPO.setActivityState(ActConstants.ActivityState.FAILURE);
        }
    }

    /**
     * 查询活动信息
     *
     * @param reqBO
     * @return
     */
    private ActivityBaseInfoPO getActivityBaseInfoPo(DycActivityDO reqBO) {
        ActivityBaseInfoPO activityBaseInfoPo = new ActivityBaseInfoPO();
        activityBaseInfoPo.setActivityId(reqBO.getActivityId());
        ActivityBaseInfoPO modelBy = activityBaseInfoMapper.getModelBy(activityBaseInfoPo);
        if (modelBy == null) {
            throw new BaseBusinessException(DycActivityRspConstants.RESP_CODE_ERROR, "查询活动单据为空！" );
        }
        return modelBy;
    }

    @Override
    public DycActivityBaseInfo getActivityBaseInfoDetail(DycActivityDO dycActivityDO) {
        ActivityBaseInfoPO qryInfoPo = JUtil.js(dycActivityDO, ActivityBaseInfoPO.class);
        ActivityBaseInfoPO activityBaseInfoPo = activityBaseInfoMapper.getActivityBaseInfoDetail(qryInfoPo);
        DycActivityBaseInfo dycActivityBaseInfo = null;
        if (activityBaseInfoPo != null) {
            dycActivityBaseInfo = JUtil.js(activityBaseInfoPo, DycActivityBaseInfo.class);
        }
        return dycActivityBaseInfo;
    }


    @Override
    public DycActivityBaseInfo qryActiveBaseInfo(DycActivityDO reqBo) {
        ActivityBaseInfoPO infoPo = new ActivityBaseInfoPO();
        infoPo.setActivityId(reqBo.getActivityId());
        ActivityBaseInfoPO activityBaseInfoPo = activityBaseInfoMapper.qryActiveBaseInfo(infoPo);
        return JSONObject.parseObject(JSONObject.toJSONString(activityBaseInfoPo), DycActivityBaseInfo.class);
    }

    @Override
    public void insert(DycActiveBaseInfoSaveReqBO reqBo) {
        ActivityBaseInfoPO activityBaseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityBaseInfoPO.class);
        activityBaseInfoMapper.insert(activityBaseInfoPo);
    }


    @Override
    public int insertNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityChangeInfoPo = JSONObject.parseObject(JSONObject.toJSONString(reqBO), ActivityBaseInfoPO.class);
        return activityBaseInfoMapper.insertNew(activityChangeInfoPo);
    }

    @Override
    public int updateByNew(DycActivityBaseInfo set, DycActivityBaseInfo where) {
        ActivityBaseInfoPO activityBaseInfoPoSet = JSONObject.parseObject(JSONObject.toJSONString(set), ActivityBaseInfoPO.class);
        ActivityBaseInfoPO activityBaseInfoPoWhere = JSONObject.parseObject(JSONObject.toJSONString(where), ActivityBaseInfoPO.class);
        return activityBaseInfoMapper.updateBy(activityBaseInfoPoSet, activityBaseInfoPoWhere);
    }

    /**
     * 预警失效活动处理
     *
     * @param set   set新值
     * @param where where条件（旧值）
     * @return
     */
    @Override
    public int updateLoseActivityAlertType(DycActivityBaseInfo set, DycActivityBaseInfo where) {
        ActAlertInfoPO actAlertInfoPO = new ActAlertInfoPO();
        actAlertInfoPO.setAlertType(where.getAlertType());
        actAlertInfoPO.setObjId(where.getActivityId().toString());
        actAlertInfoPO.setObjType(DycActivityConstants.OBJ_TYPE.ACTIVITY);
        actAlertInfoPO.setAlertState(DycActivityConstants.AlertState.DEALED);
        actAlertInfoMapper.update(actAlertInfoPO);
        ActivityBaseInfoPO activityBaseInfoPoSet = JSONObject.parseObject(JSONObject.toJSONString(set), ActivityBaseInfoPO.class);
        ActivityBaseInfoPO activityBaseInfoPoWhere = new ActivityBaseInfoPO();
        activityBaseInfoPoWhere.setActivityId(where.getActivityId());
        return activityBaseInfoMapper.updateBy(activityBaseInfoPoSet, activityBaseInfoPoWhere);
    }

    @Override
    public int getCheckByNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityChangeInfoPo = JSONObject.parseObject(JSONObject.toJSONString(reqBO), ActivityBaseInfoPO.class);
        return activityBaseInfoMapper.getCheckBy(activityChangeInfoPo);
    }

    @Override
    public DycActivityBaseInfo getModelByNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityBaseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(reqBO), ActivityBaseInfoPO.class);
        ActivityBaseInfoPO modelBy = activityBaseInfoMapper.getModelBy(activityBaseInfoPo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy), DycActivityBaseInfo.class);
    }

    @Override
    public List<DycActivityBaseInfo> getListNew(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityBaseInfoPo = JSONObject.parseObject(JSONObject.toJSONString(reqBO), ActivityBaseInfoPO.class);
        List<ActivityBaseInfoPO> list = activityBaseInfoMapper.getList(activityBaseInfoPo);
        return JSONObject.parseArray(JSONObject.toJSONString(list), DycActivityBaseInfo.class);
    }

    @Override
    public void insertBatchNew(List<DycActivityBaseInfo> list) {
        List<ActivityBaseInfoPO> listPo = JSONObject.parseArray(JSONObject.toJSONString(list), ActivityBaseInfoPO.class);
        activityBaseInfoMapper.insertBatch(listPo);
    }

    /**
     * 预警活动获取
     *
     * @param reqBO
     * @return
     */
    @Override
    public List<DycActivityBaseInfo> getWarningActivity(DycActivityBaseInfo reqBO) {

        ActivityBaseInfoPO activityBaseInfoPO = ActRu.js(reqBO, ActivityBaseInfoPO.class);
        List<ActivityBaseInfoPO> warningActivity = activityBaseInfoMapper.getWarningActivity(activityBaseInfoPO);
        return ActRu.jsl(warningActivity, DycActivityBaseInfo.class);
    }

    @Override
    public int updateAlertType(DycActivityBaseInfo reqBO) {
        ActivityBaseInfoPO activityBaseInfoPO = new ActivityBaseInfoPO();
        activityBaseInfoPO.setActivityId(reqBO.getActivityId());
        return activityBaseInfoMapper.updateAlertType(activityBaseInfoPO);
    }

    @Override
    public List<DycActivityDO> querySkuToActivity(DycActivityDO activityDO) {
        List<DycActivityDO> list = new ArrayList<>();
        ActivityRelaCommodityExtPO commodityExtPO = new ActivityRelaCommodityExtPO();
        commodityExtPO.setSkuIds(activityDO.getSkuIdList());
        List<ActivityRelaCommodityExtPO> listBySku = activityRelaCommodityMapper.querySkuToActivityBySku(commodityExtPO);
        if (!CollectionUtils.isEmpty(listBySku)) {
            list.addAll(ActRu.jsl(listBySku, DycActivityDO.class));
        }
        List<ActivityRelaCommodityExtPO> listByGuiDe = activityRelaCommodityMapper.querySkuToActivityByGuide(commodityExtPO);
        if (!CollectionUtils.isEmpty(listByGuiDe)) {
            list.addAll(ActRu.jsl(listByGuiDe, DycActivityDO.class));
        }
        return CollectionUtils.isEmpty(list) ? new ArrayList<>() : ActRu.jsl(list, DycActivityDO.class);
    }
}
