package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.constant.BaseRspConstants;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.ActActivitySkuChangePriceLogBO;
import com.tydic.dyc.act.model.bo.ActActivitySkuChangePriceLogListRspBO;
import com.tydic.dyc.act.model.bo.ActActivitySkuChangePriceLogReqBO;
import com.tydic.dyc.act.model.bo.ActActivitySkuChangePriceLogRspBO;
import com.tydic.dyc.act.repository.api.DycActActivitySkuChangePriceLogRepository;
import com.tydic.dyc.act.repository.dao.ActActivitySkuChangePriceLogMapper;
import com.tydic.dyc.act.repository.po.ActActivitySkuChangePriceLogExtPO;
import com.tydic.dyc.act.repository.po.ActActivitySkuChangePriceLogPO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 类名： ActActivitySkuChangePriceLogRepositoryImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2024/5/16 10:42
 */
@Service("DycActActivitySkuChangePriceLogRepository")
public class DycActActivitySkuChangePriceLogRepositoryImpl implements DycActActivitySkuChangePriceLogRepository {

    @Autowired
    private ActActivitySkuChangePriceLogMapper actActivitySkuChangePriceLogMapper;

    @Override
    public ActActivitySkuChangePriceLogRspBO queryActActivitySkuChangePriceLogSingle(ActActivitySkuChangePriceLogReqBO actActivitySkuChangePriceLogReqBO){
        ActActivitySkuChangePriceLogRspBO rspBO = new ActActivitySkuChangePriceLogRspBO();
        ActActivitySkuChangePriceLogPO selectActActivitySkuChangePriceLogPO = new ActActivitySkuChangePriceLogPO();
        BeanUtils.copyProperties(actActivitySkuChangePriceLogReqBO, selectActActivitySkuChangePriceLogPO);
        List<ActActivitySkuChangePriceLogPO> actActivitySkuChangePriceLogList = this.actActivitySkuChangePriceLogMapper.selectByCondition(selectActActivitySkuChangePriceLogPO);
        if (actActivitySkuChangePriceLogList.size() == 1) {
            ActActivitySkuChangePriceLogBO actActivitySkuChangePriceLogBO = new ActActivitySkuChangePriceLogBO();
            BeanUtils.copyProperties(actActivitySkuChangePriceLogList.get(0), actActivitySkuChangePriceLogBO);
            rspBO.setData(actActivitySkuChangePriceLogBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else if (actActivitySkuChangePriceLogList.size() > 1) {
            throw new ZTBusinessException("查询信息（单个）失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("查询信息（单个）失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    public ActActivitySkuChangePriceLogListRspBO queryActActivitySkuChangePriceLogList(ActActivitySkuChangePriceLogReqBO actActivitySkuChangePriceLogReqBO) {
        ActActivitySkuChangePriceLogListRspBO rspBO = new ActActivitySkuChangePriceLogListRspBO();
        ActActivitySkuChangePriceLogPO selectActActivitySkuChangePriceLogPO = new ActActivitySkuChangePriceLogPO();
        BeanUtils.copyProperties(actActivitySkuChangePriceLogReqBO, selectActActivitySkuChangePriceLogPO);
        List<ActActivitySkuChangePriceLogPO> actActivitySkuChangePriceLogPOList = this.actActivitySkuChangePriceLogMapper.selectByCondition(selectActActivitySkuChangePriceLogPO);

        List<ActActivitySkuChangePriceLogBO> actActivitySkuChangePriceLogBOList = new ArrayList<>();
        for (ActActivitySkuChangePriceLogPO actActivitySkuChangePriceLogPO : actActivitySkuChangePriceLogPOList) {
            ActActivitySkuChangePriceLogBO actActivitySkuChangePriceLogBO = new ActActivitySkuChangePriceLogBO();
            BeanUtils.copyProperties(actActivitySkuChangePriceLogPO, actActivitySkuChangePriceLogBO);
            actActivitySkuChangePriceLogBOList.add(actActivitySkuChangePriceLogBO);
        }

        rspBO.setData(actActivitySkuChangePriceLogBOList);
        rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
        rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public RspPage<ActActivitySkuChangePriceLogBO> queryActActivitySkuChangePriceLogListPage(ActActivitySkuChangePriceLogReqBO actActivitySkuChangePriceLogReqBO) {
        if (actActivitySkuChangePriceLogReqBO.getPageNo() < 1) {
            actActivitySkuChangePriceLogReqBO.setPageNo(1);
        }
        if (actActivitySkuChangePriceLogReqBO.getPageSize() < 1) {
            actActivitySkuChangePriceLogReqBO.setPageSize(10);
        }

        ActActivitySkuChangePriceLogPO selectActActivitySkuChangePriceLogPO = new ActActivitySkuChangePriceLogPO();
        BeanUtils.copyProperties(actActivitySkuChangePriceLogReqBO, selectActActivitySkuChangePriceLogPO);
        Page<ActActivitySkuChangePriceLogPO> page = PageHelper.startPage(actActivitySkuChangePriceLogReqBO.getPageNo(), actActivitySkuChangePriceLogReqBO.getPageSize()).doSelectPage(() -> this.actActivitySkuChangePriceLogMapper.selectByCondition(selectActActivitySkuChangePriceLogPO));

        //封装集合
        List<ActActivitySkuChangePriceLogBO> actActivitySkuChangePriceLogBOList = new ArrayList<>();
        for (ActActivitySkuChangePriceLogPO actActivitySkuChangePriceLogPO : page.getResult()) {
            ActActivitySkuChangePriceLogBO actActivitySkuChangePriceLogBO = new ActActivitySkuChangePriceLogBO();
            BeanUtils.copyProperties(actActivitySkuChangePriceLogPO, actActivitySkuChangePriceLogBO);
            actActivitySkuChangePriceLogBOList.add(actActivitySkuChangePriceLogBO);
        }

        RspPage<ActActivitySkuChangePriceLogBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actActivitySkuChangePriceLogBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public RspPage<ActActivitySkuChangePriceLogBO> queryActActivitySkuChangePriceLogListPageExt(ActActivitySkuChangePriceLogReqBO actActivitySkuChangePriceLogReqBO) {
        if (actActivitySkuChangePriceLogReqBO.getPageNo() < 1) {
            actActivitySkuChangePriceLogReqBO.setPageNo(1);
        }
        if (actActivitySkuChangePriceLogReqBO.getPageSize() < 1) {
            actActivitySkuChangePriceLogReqBO.setPageSize(10);
        }

        ActActivitySkuChangePriceLogExtPO selectActActivitySkuChangePriceLogPO = new ActActivitySkuChangePriceLogExtPO();
        BeanUtils.copyProperties(actActivitySkuChangePriceLogReqBO, selectActActivitySkuChangePriceLogPO);
        Page<ActActivitySkuChangePriceLogExtPO> page = PageHelper.startPage(actActivitySkuChangePriceLogReqBO.getPageNo(), actActivitySkuChangePriceLogReqBO.getPageSize()).doSelectPage(() -> this.actActivitySkuChangePriceLogMapper.selectByConditionExt(selectActActivitySkuChangePriceLogPO));

        //封装集合
        List<ActActivitySkuChangePriceLogBO> actActivitySkuChangePriceLogBOList = new ArrayList<>();
        for (ActActivitySkuChangePriceLogPO actActivitySkuChangePriceLogPO : page.getResult()) {
            ActActivitySkuChangePriceLogBO actActivitySkuChangePriceLogBO = new ActActivitySkuChangePriceLogBO();
            BeanUtils.copyProperties(actActivitySkuChangePriceLogPO, actActivitySkuChangePriceLogBO);
            actActivitySkuChangePriceLogBOList.add(actActivitySkuChangePriceLogBO);
        }

        RspPage<ActActivitySkuChangePriceLogBO> rspPage = new RspPage<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(actActivitySkuChangePriceLogBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    @Transactional
    public ActActivitySkuChangePriceLogRspBO addActActivitySkuChangePriceLog(ActActivitySkuChangePriceLogReqBO actActivitySkuChangePriceLogReqBO) {
        ActActivitySkuChangePriceLogRspBO rspBO = new ActActivitySkuChangePriceLogRspBO();

        ActActivitySkuChangePriceLogPO insertActActivitySkuChangePriceLogPO = new ActActivitySkuChangePriceLogPO();
        BeanUtils.copyProperties(actActivitySkuChangePriceLogReqBO, insertActActivitySkuChangePriceLogPO);
        //TODO 封装其它信息

        int num = this.actActivitySkuChangePriceLogMapper.insert(insertActActivitySkuChangePriceLogPO);
        if (num == 1) {
            ActActivitySkuChangePriceLogBO ActActivitySkuChangePriceLogBO = new ActActivitySkuChangePriceLogBO();
            BeanUtils.copyProperties(insertActActivitySkuChangePriceLogPO, ActActivitySkuChangePriceLogBO);
            rspBO.setData(ActActivitySkuChangePriceLogBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }


    @Override
    @Transactional
    public ActActivitySkuChangePriceLogListRspBO addListActActivitySkuChangePriceLog(List<ActActivitySkuChangePriceLogReqBO> actActivitySkuChangePriceLogReqBO) {
        ActActivitySkuChangePriceLogListRspBO rspBO = new ActActivitySkuChangePriceLogListRspBO();
        for(int i = 0;i < actActivitySkuChangePriceLogReqBO.size();i++){
            long id = Sequence.getInstance().nextId();
            actActivitySkuChangePriceLogReqBO.get(i).setId(id);
        }

        List<ActActivitySkuChangePriceLogPO> insertActActivitySkuChangePriceLogPO = JSONObject.parseArray(JSONObject.toJSONString(actActivitySkuChangePriceLogReqBO),ActActivitySkuChangePriceLogPO.class);


        int num = this.actActivitySkuChangePriceLogMapper.allInsert(insertActActivitySkuChangePriceLogPO);
        if (num == actActivitySkuChangePriceLogReqBO.size()) {
            List<ActActivitySkuChangePriceLogBO> lActActivitySkuChangePriceLogBO = JSONObject.parseArray(JSONObject.toJSONString(insertActActivitySkuChangePriceLogPO),ActActivitySkuChangePriceLogBO.class);
            rspBO.setData(lActActivitySkuChangePriceLogBO);
            rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
            rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
        } else {
            throw new ZTBusinessException("新增信息失败：新增信息失败");
        }
        return rspBO;
    }

    @Override
    @Transactional
    public ActActivitySkuChangePriceLogRspBO updateActActivitySkuChangePriceLog(ActActivitySkuChangePriceLogReqBO actActivitySkuChangePriceLogReqBO) {
        ActActivitySkuChangePriceLogRspBO rspBO = new ActActivitySkuChangePriceLogRspBO();
        ActActivitySkuChangePriceLogPO selectActActivitySkuChangePriceLogPO = new ActActivitySkuChangePriceLogPO();
        selectActActivitySkuChangePriceLogPO.setId(actActivitySkuChangePriceLogReqBO.getId());
        List<ActActivitySkuChangePriceLogPO> actActivitySkuChangePriceLogList = this.actActivitySkuChangePriceLogMapper.selectByCondition(selectActActivitySkuChangePriceLogPO);
        if (actActivitySkuChangePriceLogList.size() == 1) {
            ActActivitySkuChangePriceLogPO updateActActivitySkuChangePriceLogPO = new ActActivitySkuChangePriceLogPO();
            BeanUtils.copyProperties(actActivitySkuChangePriceLogReqBO, updateActActivitySkuChangePriceLogPO);

            int num = this.actActivitySkuChangePriceLogMapper.update(updateActActivitySkuChangePriceLogPO);
            if (num == 1) {
                ActActivitySkuChangePriceLogBO actActivitySkuChangePriceLogBO = new ActActivitySkuChangePriceLogBO();
                BeanUtils.copyProperties(updateActActivitySkuChangePriceLogPO, actActivitySkuChangePriceLogBO);
                rspBO.setData(actActivitySkuChangePriceLogBO);
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("修改信息失败：修改信息失败");
            }
        } else if (actActivitySkuChangePriceLogList.size() > 1) {
            throw new ZTBusinessException("修改信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("修改信息失败：不存在对应的信息");
        }
        return rspBO;
    }

    @Override
    @Transactional
    public ActActivitySkuChangePriceLogRspBO saveActActivitySkuChangePriceLog(ActActivitySkuChangePriceLogReqBO actActivitySkuChangePriceLogReqBO) {
        //新增信息
        if (actActivitySkuChangePriceLogReqBO.getId() == null) {
            return this.addActActivitySkuChangePriceLog(actActivitySkuChangePriceLogReqBO);
        }
        //修改信息
        else {
            return this.updateActActivitySkuChangePriceLog(actActivitySkuChangePriceLogReqBO);
        }
    }

    @Override
    @Transactional
    public ActActivitySkuChangePriceLogRspBO deleteActActivitySkuChangePriceLog(ActActivitySkuChangePriceLogReqBO actActivitySkuChangePriceLogReqBO) {
        ActActivitySkuChangePriceLogRspBO rspBO = new ActActivitySkuChangePriceLogRspBO();
        ActActivitySkuChangePriceLogPO selectActActivitySkuChangePriceLogPO = new ActActivitySkuChangePriceLogPO();
        selectActActivitySkuChangePriceLogPO.setId(actActivitySkuChangePriceLogReqBO.getId());
        List<ActActivitySkuChangePriceLogPO> actActivitySkuChangePriceLogList = this.actActivitySkuChangePriceLogMapper.selectByCondition(selectActActivitySkuChangePriceLogPO);
        if (actActivitySkuChangePriceLogList.size() == 1) {
            ActActivitySkuChangePriceLogPO deleteActActivitySkuChangePriceLogPO = new ActActivitySkuChangePriceLogPO();
            BeanUtils.copyProperties(actActivitySkuChangePriceLogReqBO, deleteActActivitySkuChangePriceLogPO);

            int num = this.actActivitySkuChangePriceLogMapper.delete(deleteActActivitySkuChangePriceLogPO);
            if (num == 1) {
                rspBO.setMessage(BaseRspConstants.RSP_DESC_SUCCESS);
                rspBO.setCode(BaseRspConstants.CODE_SUCCESS);
            } else {
                throw new ZTBusinessException("删除信息失败：删除信息失败");
            }
        } else if (actActivitySkuChangePriceLogList.size() > 1) {
            throw new ZTBusinessException("删除信息失败：存在多条对应的信息");
        } else {
            throw new ZTBusinessException("删除信息失败：不存在对应的信息");
        }
        return rspBO;
    }
}
