package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.util.DesensitizedUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActActivityUserRepository;
import com.tydic.dyc.act.repository.dao.ActivityBaseInfoMapper;
import com.tydic.dyc.act.repository.dao.ActivityUserInfoMapper;
import com.tydic.dyc.act.repository.dao.ActivityUserScoresUseRecordMapper;
import com.tydic.dyc.act.repository.po.*;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 说明：
 *
 * @author zhoulu
 * @date 2023年12月18日 16:31
 */
@Service
public class DycActActivityUserRepositoryImpl implements DycActActivityUserRepository {

    @Autowired
    private ActivityUserInfoMapper activityUserInfoMapper;
    @Autowired
    private ActivityUserScoresUseRecordMapper activityUserScoresUseRecordMapper;
    @Value("${LIMIT_SCORES:50000}")
    private BigDecimal LIMIT_SCORES;
    @Autowired
    private ActivityBaseInfoMapper activityBaseInfoMapper;

    @Override
    public DycSaasActQueryActivityUserPageListRspBO queryActivityUserPageList(DycActivityDO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        DycSaasActQueryActivityUserPageListRspBO rspBo = new DycSaasActQueryActivityUserPageListRspBO();
        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties(reqBO, activityUserInfoPO);
        activityUserInfoPO.setUserId(reqBO.getActUserId());
        activityUserInfoPO.setUserName(reqBO.getActUserName());
        activityUserInfoPO.setName(reqBO.getActName());
        activityUserInfoPO.setWorkNo(reqBO.getActWorkNo());
        activityUserInfoPO.setUserOrgId(reqBO.getActUserOrgId());
        activityUserInfoPO.setUserOrgName(reqBO.getActUserOrgName());
        Page<ActivityUserInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityUserInfoMapper.selectByCondition(activityUserInfoPO));
        if (ObjectUtils.isEmpty(page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        List<DycActivityUserInfo> activityUserInfos = page.getResult().stream().map(item -> {
            DycActivityUserInfo userInfo = new DycActivityUserInfo();
            BeanUtils.copyProperties(item, userInfo);
            userInfo.setActUserId(item.getUserId());
            userInfo.setActUserName(item.getUserName());
            userInfo.setActName(item.getName());
            userInfo.setActWorkNo(item.getWorkNo());
            userInfo.setActUserOrgId(item.getUserOrgId());
            userInfo.setActUserOrgName(item.getUserOrgName());
            userInfo.setActUserCompanyId(item.getUserCompanyId());
            userInfo.setActUserCompanyName(item.getUserCompanyName());
            userInfo.setPhone(DesensitizedUtil.mobilePhone(item.getPhone()));
            return userInfo;
        }).collect(Collectors.toList());
        rspBo.setRows(activityUserInfos);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public List<DycActivityUserInfo> queryActivityUserList(DycActivityDO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties(reqBO, activityUserInfoPO);
        activityUserInfoPO.setUserId(reqBO.getActUserId());
        activityUserInfoPO.setUserName(reqBO.getActUserName());
        activityUserInfoPO.setName(reqBO.getActName());
        activityUserInfoPO.setWorkNo(reqBO.getActWorkNo());
        activityUserInfoPO.setUserOrgId(reqBO.getActUserOrgId());
        activityUserInfoPO.setUserOrgName(reqBO.getActUserOrgName());
        List<ActivityUserInfoPO> activityUserInfoPOS = activityUserInfoMapper.selectByCondition(activityUserInfoPO);
        if (CollectionUtils.isEmpty(activityUserInfoPOS)) {
            return new ArrayList<>();
        }
        List<DycActivityUserInfo> rspBo = activityUserInfoPOS.stream().map(item -> {
            DycActivityUserInfo userInfo = new DycActivityUserInfo();
            BeanUtils.copyProperties(item, userInfo);
            userInfo.setActUserId(item.getUserId());
            userInfo.setActUserName(item.getUserName());
            userInfo.setActName(item.getName());
            userInfo.setActWorkNo(item.getWorkNo());
            userInfo.setActUserOrgId(item.getUserOrgId());
            userInfo.setActUserOrgName(item.getUserOrgName());
            userInfo.setActUserCompanyId(item.getUserCompanyId());
            userInfo.setActUserCompanyName(item.getUserCompanyName());
            userInfo.setActUserOrgPath(item.getUserOrgPath());
            return userInfo;
        }).collect(Collectors.toList());
        return rspBo;
    }

    @Override
    public List<DycActivityUserInfo> queryActivityUserNotInPoolList(DycActivityDO reqBO) {
        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties(reqBO, activityUserInfoPO);
        activityUserInfoPO.setUserId(reqBO.getActUserId());
        activityUserInfoPO.setUserName(reqBO.getActUserName());
        activityUserInfoPO.setName(reqBO.getActName());
        activityUserInfoPO.setWorkNo(reqBO.getActWorkNo());
        activityUserInfoPO.setUserOrgId(reqBO.getActUserOrgId());
        activityUserInfoPO.setUserOrgName(reqBO.getActUserOrgName());
        List<ActivityUserInfoPO> activityUserInfoPOS = activityUserInfoMapper.selectByNotInPoolCondition(activityUserInfoPO);
        List<DycActivityUserInfo> rspBo = activityUserInfoPOS.stream().map(item -> {
            DycActivityUserInfo userInfo = new DycActivityUserInfo();
            BeanUtils.copyProperties(item, userInfo);
            userInfo.setActUserId(item.getUserId());
            userInfo.setActUserName(item.getUserName());
            userInfo.setActName(item.getName());
            userInfo.setActWorkNo(item.getWorkNo());
            userInfo.setActUserOrgId(item.getUserOrgId());
            userInfo.setActUserOrgName(item.getUserOrgName());
            return userInfo;
        }).collect(Collectors.toList());
        return rspBo;
    }

    @Override
    public List<DycActivityUserInfo> queryActivityUserNotInUserMapList(DycActivityDO reqBO) {
        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties(reqBO, activityUserInfoPO);
        List<ActivityUserInfoPO> activityUserInfoPOS = activityUserInfoMapper.selectByNotInUserMapCondition(activityUserInfoPO);
        List<DycActivityUserInfo> rspBo = activityUserInfoPOS.stream().map(item -> {
            DycActivityUserInfo userInfo = new DycActivityUserInfo();
            BeanUtils.copyProperties(item, userInfo);
            userInfo.setActUserId(item.getUserId());
            userInfo.setActUserName(item.getUserName());
            userInfo.setActName(item.getName());
            userInfo.setActWorkNo(item.getWorkNo());
            userInfo.setActUserOrgId(item.getUserOrgId());
            userInfo.setActUserOrgName(item.getUserOrgName());
            return userInfo;
        }).collect(Collectors.toList());
        return rspBo;
    }

    @Override
    public int addUser(DycActivityDO reqBO) {
        ActivityUserInfoPO activityUserInfoPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityUserInfoPO.class);
        activityUserInfoPO.setCreateTime(new Date());
        activityUserInfoPO.setId(Sequence.getInstance().nextId());
        activityUserInfoPO.setDelFlag(0);
        activityUserInfoPO.setUserId(reqBO.getActUserId());
        activityUserInfoPO.setUserName(reqBO.getActUserName());
        activityUserInfoPO.setName(reqBO.getActName());
        activityUserInfoPO.setWorkNo(reqBO.getActWorkNo());
        activityUserInfoPO.setUserOrgId(reqBO.getActUserOrgId());
        activityUserInfoPO.setUserOrgName(reqBO.getActUserOrgName());
        return activityUserInfoMapper.insert(activityUserInfoPO);
    }

    @Override
    public DycActivityUserInfo batchSelectActivityUser(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("保存内容不能为空或者活动id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getActivityUserList())) {
            throw new ZTBusinessException("保存内容用户信息不能为空！");
        }
        List<ActivityUserInfoPO> collect = reqBO.getActivityUserList().stream().map(item -> {
            ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
            BeanUtils.copyProperties(item, activityUserInfoPO);
            activityUserInfoPO.setActivityId(reqBO.getActivityId());
            activityUserInfoPO.setCreateUserId(reqBO.getCreateUserId());
            activityUserInfoPO.setCreateUserName(reqBO.getCreateUserName());
            activityUserInfoPO.setCreateTime(new Date());
            activityUserInfoPO.setId(Sequence.getInstance().nextId());
            activityUserInfoPO.setDelFlag(0);
            activityUserInfoPO.setUserId(item.getActUserId());
            activityUserInfoPO.setUserName(item.getActUserName());
            activityUserInfoPO.setName(item.getActName());
            activityUserInfoPO.setWorkNo(item.getActWorkNo());
            activityUserInfoPO.setUserOrgId(item.getActUserOrgId());
            activityUserInfoPO.setUserOrgName(item.getActUserOrgName());
            activityUserInfoPO.setUserCompanyId(item.getActUserCompanyId());
            activityUserInfoPO.setUserCompanyName(item.getActUserCompanyName());
            activityUserInfoPO.setUserOrgPath(item.getActUserOrgPath());
            return activityUserInfoPO;
        }).collect(Collectors.toList());
        int i = activityUserInfoMapper.allInsert(collect);
        if (reqBO.getActivityUserList().size() != i) {
            throw new ZTBusinessException("保存内容用户添加失败！");
        }
        return new DycActivityUserInfo();
    }

    @Override
    public DycActivityUserInfo batchRemoveActivityUser(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("保存内容不能为空或者活动id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getUserIdList())) {
            throw new ZTBusinessException("移除列表用户id不能为空！");
        }
        ActivityUserInfoPO userInfoPO = new ActivityUserInfoPO();
        userInfoPO.setActivityId(reqBO.getActivityId());
        userInfoPO.setUpdateUserId(reqBO.getUpdateUserId());
        userInfoPO.setUpdateUserName(reqBO.getUpdateUserName());
        userInfoPO.setUpdateTime(new Date());
        activityUserInfoMapper.batchRemoveActivityUser(reqBO.getUserIdList(), userInfoPO);

        return new DycActivityUserInfo();
    }

    @Override
    public DycActivityUserInfo modifyActivityUserScores(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("保存内容不能为空或者活动id不能为空！");
        }
        if (null == reqBO.getActUserId()) {
            throw new ZTBusinessException("发放对应用户id为不能为空！");
        }
        if (null != reqBO.getGiveScores() && BigDecimal.ZERO.compareTo(reqBO.getGiveScores()) > 0) {
            throw new ZTBusinessException("发放积分不能小于0！");
        }

        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties(reqBO, activityUserInfoPO);
        activityUserInfoPO.setUserId(reqBO.getActUserId());
        activityUserInfoPO.setUpdateTime(new Date());
        activityUserInfoPO.setBalanceScores(reqBO.getGiveScores());
        activityUserInfoPO.setUsedScores(new BigDecimal(0));
        int i = activityUserInfoMapper.update(activityUserInfoPO);
        if (1 != i) {
            throw new ZTBusinessException("积分修改失败！");
        }
        return new DycActivityUserInfo();
    }

    @Override
    public DycActivityUserInfo batchModifyActivityUserScores(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("保存内容不能为空或者活动id不能为空！");
        }
        if (null == reqBO.getGiveScores() || BigDecimal.ZERO.compareTo(reqBO.getGiveScores()) > 0) {
            throw new ZTBusinessException("批量发放积分不能为空或者积分不能小于0！");
        }
        if ("1".equals(reqBO.getIssueRange())) {
            ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
            activityUserInfoPO.setActivityId(reqBO.getActivityId());
            activityUserInfoPO.setUpdateTime(new Date());
            activityUserInfoPO.setUpdateUserId(reqBO.getUpdateUserId());
            activityUserInfoPO.setUpdateUserName(reqBO.getUpdateUserName());
            activityUserInfoPO.setBalanceScores(reqBO.getGiveScores());
            activityUserInfoPO.setUsedScores(new BigDecimal(0));
            activityUserInfoPO.setGiveScores(reqBO.getGiveScores());
            activityUserInfoMapper.update(activityUserInfoPO);
        } else {
            ActivityUserInfoPO userInfoPO = new ActivityUserInfoPO();
            userInfoPO.setActivityId(reqBO.getActivityId());
            List<ActivityUserInfoPO> infoPOS = activityUserInfoMapper.selectByConditionGiveScores(userInfoPO);
            if (CollectionUtils.isEmpty(infoPOS)) {
                return new DycActivityUserInfo();
            }
            List<Long> collect = infoPOS.stream().map(item -> item.getUserId()).collect(Collectors.toList());
            ActivityUserInfoPO infoPO = new ActivityUserInfoPO();
            infoPO.setActivityId(reqBO.getActivityId());
            infoPO.setGiveScores(reqBO.getGiveScores());
            infoPO.setBalanceScores(reqBO.getGiveScores());
            infoPO.setUsedScores(new BigDecimal(0));
            infoPO.setUpdateTime(new Date());
            infoPO.setUpdateUserId(reqBO.getUpdateUserId());
            infoPO.setUpdateUserName(reqBO.getUpdateUserName());
            activityUserInfoMapper.batchUpdateUserGiveScores(collect, infoPO);
        }
        return new DycActivityUserInfo();
    }

    @Override
    public BasePageRspBo<DycActivityUserScoresUseRecordInfo> queryActivityUserScoresUseRecordPageList(DycActivityDO reqBO) {
        BasePageRspBo<DycActivityUserScoresUseRecordInfo> rspBo = new BasePageRspBo<>();
        List<DycActivityUserScoresUseRecordInfo> rows = new ArrayList<>();
        ActivityUserScoresUseRecordTimePO activityUserScoresUseRecordTimePO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityUserScoresUseRecordTimePO.class);
        Page<ActivityUserScoresUseRecordPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityUserScoresUseRecordMapper.queryActivityUserScoresUseRecordPageList(activityUserScoresUseRecordTimePO));
        if (ObjectUtils.isEmpty(page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
            rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            return rspBo;
        }
        for (ActivityUserScoresUseRecordPO activityUserScoresUseRecordPO : page.getResult()) {
            DycActivityUserScoresUseRecordInfo dycActivityUserScoresUseRecordInfo = JSON.parseObject(JSON.toJSONString(activityUserScoresUseRecordPO), DycActivityUserScoresUseRecordInfo.class);
            dycActivityUserScoresUseRecordInfo.setUseTypeStr(DycActivityTransFieldUtil.UseType(dycActivityUserScoresUseRecordInfo.getUseType()));
            dycActivityUserScoresUseRecordInfo.setActUserId(activityUserScoresUseRecordPO.getUserId());
            dycActivityUserScoresUseRecordInfo.setActUserName(activityUserScoresUseRecordPO.getUserName());
            dycActivityUserScoresUseRecordInfo.setActName(activityUserScoresUseRecordPO.getName());
            rows.add(dycActivityUserScoresUseRecordInfo);
        }
        rspBo.setRows(rows);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int) page.getTotal());
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }

    @Override
    public int deductOrReturnActivityScores(DycActivityDO reqBO) {
        ActivityUserInfoPO activityUserInfoPO = JSON.parseObject(JSON.toJSONString(reqBO), ActivityUserInfoPO.class);
        List<ActivityUserInfoPO> activityUserInfoPOS = activityUserInfoMapper.selectByCondition(activityUserInfoPO);
        if (activityUserInfoPOS.size() < 1) {
            throw new ZTBusinessException("没有此用户");
        }
        ActivityUserInfoPO activityUserInfoPO1 = activityUserInfoPOS.get(0);
        //流水新增
        ActivityUserScoresUseRecordPO activityUserScoresUseRecordPO = new ActivityUserScoresUseRecordPO();
        activityUserScoresUseRecordPO.setBeforeUseScores(activityUserInfoPO1.getBalanceScores());
        if ("2".equals(reqBO.getOperType())) {
            if (activityUserInfoPO1.getBalanceScores().compareTo(reqBO.getUseScores()) < 0) {
                throw new ZTBusinessException("积分不够不能消费");
            }
            activityUserInfoPO1.setBalanceScores(activityUserInfoPO1.getBalanceScores().subtract(reqBO.getUseScores()));
            activityUserInfoPO1.setUsedScores(activityUserInfoPO1.getUsedScores().add(reqBO.getUseScores()));
        } else if ("3".equals(reqBO.getOperType())) {
            activityUserInfoPO1.setBalanceScores(activityUserInfoPO1.getBalanceScores().add(reqBO.getUseScores()));
            activityUserInfoPO1.setUsedScores(activityUserInfoPO1.getUsedScores().subtract(reqBO.getUseScores()));
        } else {
            throw new ZTBusinessException("操作异常");
        }
        activityUserInfoMapper.update(activityUserInfoPO1);

        activityUserScoresUseRecordPO.setRecordId(Sequence.getInstance().nextId());
        activityUserScoresUseRecordPO.setActivityId(reqBO.getActivityId());
        activityUserScoresUseRecordPO.setActivityName(reqBO.getActivityName());
        activityUserScoresUseRecordPO.setUserId(activityUserInfoPO1.getUserId());
        activityUserScoresUseRecordPO.setUserName(activityUserInfoPO1.getUserName());
        activityUserScoresUseRecordPO.setName(activityUserInfoPO1.getName());
        activityUserScoresUseRecordPO.setUseType(reqBO.getOperType());
        activityUserScoresUseRecordPO.setObjId(reqBO.getObjId());
        activityUserScoresUseRecordPO.setObjType(reqBO.getObjType());
        activityUserScoresUseRecordPO.setUseScores(reqBO.getUseScores());
        activityUserScoresUseRecordPO.setAfterUseScores(activityUserInfoPO1.getBalanceScores());
        activityUserScoresUseRecordPO.setUseTime(reqBO.getUseTime());
        activityUserScoresUseRecordPO.setUseUserId(reqBO.getUseUserId());
        activityUserScoresUseRecordPO.setUseUserName(reqBO.getUseUserName());
        activityUserScoresUseRecordPO.setCreateTime(new Date());
        activityUserScoresUseRecordPO.setCreateUserId(reqBO.getUseUserId());
        activityUserScoresUseRecordPO.setCreateUserName(reqBO.getUseUserName());
        return activityUserScoresUseRecordMapper.insert(activityUserScoresUseRecordPO);
    }

    @Override
    public int deleteActivityUser(DycActivityDO reqBO) {
        ActivityUserInfoPO infoPO = new ActivityUserInfoPO();
        infoPO.setActivityId(reqBO.getActivityId());
        infoPO.setUpdateTime(new Date());
        infoPO.setUpdateUserId(reqBO.getUpdateUserId());
        infoPO.setUpdateUserName(reqBO.getUpdateUserName());
        return activityUserInfoMapper.update(infoPO);
    }

    @Override
    public BigDecimal selectCountUserScores(DycActivityDO reqBO) {
        ActivityUserInfoPO infoPO = new ActivityUserInfoPO();
        infoPO.setActivityId(reqBO.getActivityId());
        return activityUserInfoMapper.selectCountUserScores(infoPO);
    }

    @Override
    public int selectCountUser(DycActivityDO reqBO) {
        ActivityUserInfoPO infoPO = new ActivityUserInfoPO();
        infoPO.setActivityId(reqBO.getActivityId());
        return activityUserInfoMapper.selectCountUser(infoPO);
    }

    @Override
    public List<DycActActivityInfo> qryActInfoByUserId(DycActQryActInfoByUserQryDO reqBO) {
        List<ActivityBaseInfoPO> activityBaseInfoPOS = activityUserInfoMapper.selectActByUserId(reqBO.getUserId());
        return JUtil.jsl(activityBaseInfoPOS, DycActActivityInfo.class);
    }

    /**
     * 活动用户修改
     *
     * @param info
     */
    @Override
    public void updateActivityUser(DycActivityUserInfo info) {
        ActivityUserInfoPO activityUserInfoPO = ActRu.js(info, ActivityUserInfoPO.class);
        activityUserInfoPO.setUserId(info.getActUserId());
        activityUserInfoPO.setUserName(info.getActUserName());
        activityUserInfoPO.setName(info.getActName());
        activityUserInfoPO.setWorkNo(info.getActWorkNo());
        activityUserInfoPO.setUserOrgId(info.getActUserOrgId());
        activityUserInfoPO.setUserOrgName(info.getActUserOrgName());
        activityUserInfoPO.setUserCompanyId(info.getActUserCompanyId());
        activityUserInfoPO.setUserCompanyName(info.getActUserCompanyName());
        activityUserInfoPO.setUserOrgPath(info.getActUserOrgPath());
        activityUserInfoMapper.update(activityUserInfoPO);
    }

    /**
     * 用户积分信息查询
     *
     * @param reqBO
     * @return
     */
    @Override
    public DycActUserScoresBaseInfoRspBO queryUserScoresPageList(DycActUserScoresBaseInfoQueryBO reqBO) {
        ActUserScoresBaseInfoPO infoPO = ActRu.js(reqBO, ActUserScoresBaseInfoPO.class);
        DycActUserScoresBaseInfoRspBO rspBo = new DycActUserScoresBaseInfoRspBO();
        if (DycActivityConstants.Sort.STATE_END_TIME_SORT.toString().equals(reqBO.getOrderBy())) {
            infoPO.setOrderBy(null);
            List<ActUserScoresBaseInfoPO> actUserScoresBaseInfoPOS = activityUserInfoMapper.queryUserScoresPageListByApp(infoPO);
            if (CollectionUtils.isEmpty(actUserScoresBaseInfoPOS)) {
                rspBo.setPageNo(reqBO.getPageNo());
                rspBo.setTotal(0);
                rspBo.setRecordsTotal(0);
                rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
                rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            } else {
                //处理是否可评价字段
                actUserScoresBaseInfoPOS.forEach(o -> {
                    if (o.getActivityAppraiseId() == null) {
                        o.setIsAppraise(true);
                    } else {
                        o.setIsAppraise(false);
                    }
                });
                sortUserScore(actUserScoresBaseInfoPOS, rspBo, reqBO);
            }
        } else {
            Page<ActUserScoresBaseInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityUserInfoMapper.queryUserScoresPageListByApp(infoPO));
            if (ObjectUtils.isEmpty(page.getResult())) {
                rspBo.setPageNo(reqBO.getPageNo());
                rspBo.setTotal(0);
                rspBo.setRecordsTotal(0);
                rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
                rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
            } else {
                rspBo.setPageNo(page.getPageNum());
                rspBo.setTotal(page.getPages());
                rspBo.setRecordsTotal((int) page.getTotal());
                rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
                rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
                Map<Integer, List<Long>> map = updateActivity(page.getResult());
                //处理是否可评价字段
                page.getResult().forEach(o -> {
                    if (o.getActivityAppraiseId() == null) {
                        o.setIsAppraise(true);
                    } else {
                        o.setIsAppraise(false);
                    }
                });
                rspBo.setRows(ActRu.jsl(page.getResult(), DycActUserScoresBaseInfo.class));
                setAutoType(rspBo, map);

            }
        }
        return rspBo;
    }

    /**
     * 设置自动任务类型
     *
     * @param rspBo
     * @param map
     */
    private void setAutoType(DycActUserScoresBaseInfoRspBO rspBo, Map<Integer, List<Long>> map) {
        if (!CollectionUtils.isEmpty(rspBo.getRows())) {
            //执行自动生效活动的id
            List<Long> comeInto = map.get(DycActivityConstants.AutoType.COME_INTO);
            //执行自动失效活动的id
            List<Long> lose = map.get(DycActivityConstants.AutoType.LOSE);
            for (DycActUserScoresBaseInfo info : rspBo.getRows()) {
                info.setAutoType(DycActivityConstants.AutoType.NO);
                if (!CollectionUtils.isEmpty(comeInto)) {
                    if (comeInto.contains(info.getActivityId())) {
                        info.setAutoType(DycActivityConstants.AutoType.COME_INTO);
                    }
                }
                if (!CollectionUtils.isEmpty(lose)) {
                    if (lose.contains(info.getActivityId())) {
                        info.setAutoType(DycActivityConstants.AutoType.LOSE);
                    }
                }
            }
            rspBo.setActivityIds(comeInto);
        }
    }

    /**
     * 用户积分列表排序
     *
     * @param actUserScoresBaseInfoPOS
     * @param rspBo
     * @param reqBO
     */
    private void sortUserScore(List<ActUserScoresBaseInfoPO> actUserScoresBaseInfoPOS, DycActUserScoresBaseInfoRspBO rspBo, DycActUserScoresBaseInfoQueryBO reqBO) {
        List<ActUserScoresBaseInfoPO> allList = new ArrayList<>();
        Map<Integer, List<Long>> map = updateActivity(actUserScoresBaseInfoPOS);
        //生效中排序集合
        sortUserScore(actUserScoresBaseInfoPOS, Collections.singletonList(DycActivityConstants.ActivityState.ACTIVITY_STATE_FIVE), allList);
        //待生效排序集合
        sortUserScore(actUserScoresBaseInfoPOS, Collections.singletonList(DycActivityConstants.ActivityState.ACTIVITY_STATE_FOUR), allList);
        //已失效排序集合
        sortUserScore(actUserScoresBaseInfoPOS, Collections.singletonList(DycActivityConstants.ActivityState.ACTIVITY_STATE_SEVEN), allList);
        //已结束排序集合
        sortUserScore(actUserScoresBaseInfoPOS, Collections.singletonList(DycActivityConstants.ActivityState.ACTIVITY_STATE_SIX), allList);
        rspBo.setRecordsTotal(allList.size());
        rspBo.setPageNo(reqBO.getPageNo());
        int fromIndex = (reqBO.getPageNo() - 1) * reqBO.getPageSize();
        int toIndex = Math.min((fromIndex + reqBO.getPageSize()), allList.size());
        if (toIndex > fromIndex) {
            rspBo.setRows(ActRu.jsl(allList.subList(fromIndex, toIndex), DycActUserScoresBaseInfo.class));
        }
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        if (allList.size() % reqBO.getPageSize() == 0) {
            rspBo.setTotal(allList.size() / reqBO.getPageSize());
        } else {
            rspBo.setTotal(allList.size() / reqBO.getPageSize() + 1);
        }
        setAutoType(rspBo, map);
    }

    /**
     * 触发活动生效失效
     *
     * @param actUserScoresBaseInfoPOS
     */
    private Map<Integer, List<Long>> updateActivity(List<ActUserScoresBaseInfoPO> actUserScoresBaseInfoPOS) {
        if (!CollectionUtils.isEmpty(actUserScoresBaseInfoPOS)) {
            //执行自动生效活动的id
            List<Long> comeInto = new ArrayList<>(actUserScoresBaseInfoPOS.size());
            //执行自动失效活动的id
            List<Long> lose = new ArrayList<>(actUserScoresBaseInfoPOS.size());
            for (ActUserScoresBaseInfoPO infoPO : actUserScoresBaseInfoPOS) {
                if (infoPO.getActivityCycleType() == null) {
                    infoPO.setActivityCycleType(DycActivityConstants.ActivityCycleType.FINITUDE);
                }
                if (infoPO.getActivityId() != null) {
                    //待生效活动已到生效时间
                    if (DycActivityConstants.ActivityState.ACTIVITY_STATE_FOUR.equals(infoPO.getActivityState())
                            && infoPO.getActivityStartTime() != null
                            && new Date().compareTo(infoPO.getActivityStartTime()) > 0
                            && (DycActivityConstants.ActivitySyncState.SUCCESS.equals(infoPO.getActivitySyncState()) || DycActivityConstants.ActivitySyncState.PART_SUCCESS.equals(infoPO.getActivitySyncState()))) {
                        ActivityBaseInfoPO activityBaseInfoPO = new ActivityBaseInfoPO();
                        activityBaseInfoPO.setActivityId(infoPO.getActivityId());
                        activityBaseInfoPO.setActivityState(DycActivityConstants.ActivityState.ACTIVITY_STATE_FIVE);
                        activityBaseInfoPO.setUpdateUserName("系统自动");
                        activityBaseInfoPO.setUpdateUserId(1L);
                        activityBaseInfoPO.setUpdateTime(new Date());
                        activityBaseInfoMapper.update(activityBaseInfoPO);
                        infoPO.setActivityState(DycActivityConstants.ActivityState.ACTIVITY_STATE_FIVE);
                        comeInto.add(infoPO.getActivityId());
                    } else if (DycActivityConstants.ActivityState.ACTIVITY_STATE_FIVE.equals(infoPO.getActivityState())
                            && DycActivityConstants.ActivityCycleType.FINITUDE.equals(infoPO.getActivityCycleType())
                            && infoPO.getActivityEndTime() != null
                            && new Date().compareTo(infoPO.getActivityEndTime()) > 0) {
                        // 生效活动已到失效时间
                        ActivityBaseInfoPO activityBaseInfoPO = new ActivityBaseInfoPO();
                        activityBaseInfoPO.setActivityId(infoPO.getActivityId());
                        activityBaseInfoPO.setActivityState(DycActivityConstants.ActivityState.ACTIVITY_STATE_SEVEN);
                        activityBaseInfoPO.setUpdateUserName("系统自动");
                        activityBaseInfoPO.setUpdateUserId(1L);
                        activityBaseInfoPO.setUpdateTime(new Date());
                        activityBaseInfoMapper.update(activityBaseInfoPO);
                        infoPO.setActivityState(DycActivityConstants.ActivityState.ACTIVITY_STATE_SEVEN);
                        lose.add(infoPO.getActivityId());
                    }
                }
            }
            Map<Integer, List<Long>> map = new HashMap<>(2);
            if (!CollectionUtils.isEmpty(comeInto)) {
                map.put(DycActivityConstants.AutoType.COME_INTO, comeInto);
            }
            if (!CollectionUtils.isEmpty(lose)) {
                map.put(DycActivityConstants.AutoType.LOSE, lose);
            }
            return map;
        }
        return new HashMap<>();
    }


    /**
     * 获取指定状态用户积分排序集合
     *
     * @param actUserScoresBaseInfoPOS 排序集合
     * @param state                    状态
     * @return
     */
    private void sortUserScore(List<ActUserScoresBaseInfoPO> actUserScoresBaseInfoPOS, List<String> state, List<ActUserScoresBaseInfoPO> allList) {
        List<ActUserScoresBaseInfoPO> list = new ArrayList<>(actUserScoresBaseInfoPOS.size());
        for (ActUserScoresBaseInfoPO infoPO : actUserScoresBaseInfoPOS) {
            if (state.contains(infoPO.getActivityState())) {
                list.add(infoPO);
            }
        }
        allList.addAll(list.stream().sorted(Comparator.comparing(ActUserScoresBaseInfoPO::getActivityEndTime)).collect(Collectors.toList()));
    }

    @Override
    public int insertNew(DycActivityUserInfo reqBo) {
        ActivityUserInfoPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityUserInfoPO.class);
        return activityUserInfoMapper.insertNew(insert);
    }

    @Override
    public int updateByNew(DycActivityUserInfo set, DycActivityUserInfo where) {
        ActivityUserInfoPO setPo = JSONObject.parseObject(JSONObject.toJSONString(set), ActivityUserInfoPO.class);
        ActivityUserInfoPO wherePo = JSONObject.parseObject(JSONObject.toJSONString(where), ActivityUserInfoPO.class);
        return activityUserInfoMapper.updateBy(setPo, wherePo);
    }

    @Override
    public int getCheckByNew(DycActivityUserInfo reqBo) {
        ActivityUserInfoPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityUserInfoPO.class);
        return activityUserInfoMapper.getCheckBy(insert);
    }

    @Override
    public DycActivityUserInfo getModelByNew(DycActivityUserInfo reqBo) {
        ActivityUserInfoPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityUserInfoPO.class);
        ActivityUserInfoPO modelBy = activityUserInfoMapper.getModelBy(qryBo);
        return JSONObject.parseObject(JSONObject.toJSONString(modelBy), DycActivityUserInfo.class);
    }

    @Override
    public List<DycActivityUserInfo> getListNew(DycActivityUserInfo reqBo) {
        ActivityUserInfoPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityUserInfoPO.class);
        List<ActivityUserInfoPO> list = activityUserInfoMapper.getList(qryBo);
        return JSONObject.parseArray(JSONObject.toJSONString(list), DycActivityUserInfo.class);
    }

    @Override
    public void insertBatchNew(List<DycActivityUserInfo> list) {
        List<ActivityUserInfoPO> listPo = JSONObject.parseArray(JSONObject.toJSONString(list), ActivityUserInfoPO.class);
        activityUserInfoMapper.insertBatch(listPo);
    }

    @Override
    public int delete(DycActivityUserInfo record) {
        ActivityUserInfoPO activityUserInfoPO = ActRu.js(record, ActivityUserInfoPO.class);
        return activityUserInfoMapper.delete(activityUserInfoPO);
    }

    @Override
    public int count(DycActivityUserInfo record) {
        ActivityUserInfoPO activityUserInfoPO = ActRu.js(record, ActivityUserInfoPO.class);
        return activityUserInfoMapper.count(activityUserInfoPO);
    }

    @Override
    public BigDecimal sumScores(DycActivityUserInfo record) {
        ActivityUserInfoPO activityUserInfoPO = ActRu.js(record, ActivityUserInfoPO.class);
        return activityUserInfoMapper.sumScores(activityUserInfoPO);
    }

    @Override
    public int getCheckByNewByCheck(DycActivityUserInfo reqBo) {
        ActivityUserInfoPO insert = JSONObject.parseObject(JSONObject.toJSONString(reqBo), ActivityUserInfoPO.class);
        return activityUserInfoMapper.getCheckByNewByCheck(insert);
    }

    @Override
    public BasePageRspBo<DycActUserScoresBaseInfo> qryActivityUserInfoPageList(DycActUserScoresBaseInfoQueryBO reqBO) {
        ActUserScoresBaseInfoPO infoPO = ActRu.js(reqBO, ActUserScoresBaseInfoPO.class);
        BasePageRspBo<DycActUserScoresBaseInfo> rspBo = new BasePageRspBo<>();
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        Page<ActUserScoresBaseInfoPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.activityUserInfoMapper.queryUserScoresPageList(infoPO));
        if (ObjectUtils.isEmpty(page.getResult())) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
        } else {
            rspBo.setPageNo(page.getPageNum());
            rspBo.setTotal(page.getPages());
            rspBo.setRecordsTotal((int) page.getTotal());
            rspBo.setRows(ActRu.jsl(page.getResult(), DycActUserScoresBaseInfo.class));
        }
        return rspBo;
    }

    @Override
    public int selectNotUsedScores(DycActivityDO reqBO) {
        ActivityUserInfoPO qryBo = JSONObject.parseObject(JSONObject.toJSONString(reqBO), ActivityUserInfoPO.class);
        return activityUserInfoMapper.selectNotUsedScores(qryBo);
    }

    @Override
    public DycActivityUserInfo dealCreateScoreExceedsLimit(DycActivityDO reqBO) {
        DycActivityUserInfo rspBO = new DycActivityUserInfo();
        ActivityUserInfoPO infoPO = new ActivityUserInfoPO();
        infoPO.setLimitScores(LIMIT_SCORES);
        infoPO.setActivityId(reqBO.getActivityId());
        List<ActivityUserInfoPO> infoPOS = activityUserInfoMapper.selectByScorseLimit(infoPO);
        if (CollectionUtils.isEmpty(infoPOS)) {
            rspBO.setLimitFlag(false);
            rspBO.setLimitFlagMessage(null);
        } else {
            rspBO.setLimitFlag(true);
            rspBO.setLimitFlagMessage("用户" + infoPOS.stream()
                    .map(ActivityUserInfoPO::getUserName)
                    .collect(Collectors.joining("，")) + "发放的积分数超" + LIMIT_SCORES + "了，请确认正确发放！");
        }
        return rspBO;
    }
}
