package com.tydic.dyc.act.repository.impl;

import com.tydic.dyc.act.model.bo.DycActCheckBillQryDO;
import com.tydic.dyc.act.model.bo.DycActOrdNumMoneyInfo;
import com.tydic.dyc.act.repository.api.DycActCheckBillRepository;
import com.tydic.dyc.act.repository.dao.ActFscCheckResultMapper;
import com.tydic.dyc.act.repository.po.ActFscCheckResultPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @ClassName DycActCheckBillRepositoryImpl
 * @Author 14051
 * @Date 2024/4/17 17:42
 * @Version 1.0
 **/
@Service
public class DycActCheckBillRepositoryImpl implements DycActCheckBillRepository {

    @Autowired
    private ActFscCheckResultMapper actFscCheckResultMapper;

    @Override
    public DycActOrdNumMoneyInfo qryOrdNumAndMoney(DycActCheckBillQryDO reqBO) {
        ActFscCheckResultPO record = new ActFscCheckResultPO();
        record.setExtActivityId(reqBO.getExtActivityId());
        return actFscCheckResultMapper.qryOrdNumAndMoney(record);
    }

    @Override
    public int getNotEqualCountByExtActId(DycActCheckBillQryDO reqBO) {
        ActFscCheckResultPO record = new ActFscCheckResultPO();
        record.setExtActivityId(reqBO.getExtActivityId());
        return actFscCheckResultMapper.getNotEqualCountByExtActId(record);
    }
}
