package com.tydic.dyc.act.repository.impl;

import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderInvoiceDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderInvoiceInfo;
import com.tydic.dyc.act.repository.api.DycActFscOrderInvoiceRepository;
import com.tydic.dyc.act.repository.dao.ActFscOrderInvoiceMapper;
import com.tydic.dyc.act.repository.po.ActFscOrderInvoicePO;
import com.tydic.dyc.base.utils.JUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @ClassName DycActFscOrderInvoiceRepositoryImpl
 * @Author 14051
 * @Date 2024/4/4 12:04
 * @Version 1.0
 * @Description TODO
 **/
@Service
public class DycActFscOrderInvoiceRepositoryImpl implements DycActFscOrderInvoiceRepository {

    @Autowired
    private ActFscOrderInvoiceMapper actFscOrderInvoiceMapper;

    @Override
    public DycActFscOrderInvoiceInfo selectOneFscOrderInvoice(DycActFscOrderDO reqBO) {
        ActFscOrderInvoicePO record = new ActFscOrderInvoicePO();
        record.setFscOrderId(reqBO.getFscOrderId());
        List<ActFscOrderInvoicePO> actFscOrderInvoicePOS = actFscOrderInvoiceMapper.selectByCondition(record);
        return JUtil.js(actFscOrderInvoicePOS.get(0), DycActFscOrderInvoiceInfo.class);
    }

    @Override
    public int saveFscOrderInvoice(DycActFscOrderInvoiceDO reqBO) {
        ActFscOrderInvoicePO record = JUtil.js(reqBO, ActFscOrderInvoicePO.class);
        return actFscOrderInvoiceMapper.insert(record);
    }
}
