package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActFscOrderRepository;
import com.tydic.dyc.act.repository.dao.*;
import com.tydic.dyc.act.repository.po.*;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName DycActFscOrderRepositoryImpl
 * @Author 14051
 * @Date 2024/4/2 20:26
 * @Version 1.0
 * @Description TODO
 **/
@Service
public class DycActFscOrderRepositoryImpl implements DycActFscOrderRepository {

    @Autowired
    private ActFscOrderMapper actFscOrderMapper;
    @Autowired
    private ActivityFileInfoMapper activityFileInfoMapper;
    @Autowired
    private ActFscOrderBatchInfoMapper actFscOrderBatchInfoMapper;
    @Autowired
    private ActFscOrderRelationMapper actFscOrderRelationMapper;
    @Autowired
    private ActAlertInfoMapper actAlertInfoMapper;

    @Override
    public int dealPayOrderState(DycActFscOrderDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        int i = actFscOrderMapper.update(record);
        return i;
    }

    @Override
    public int dealSignOrderState(DycActFscOrderSignDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        int i = actFscOrderMapper.update(record);
        return i;
    }

    @Override
    public DycActFscOrderInfo getFscOrderOne(DycActFscOrderDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        ActFscOrderPO actFscOrderPO = actFscOrderMapper.getFscOrderOne(record);
        return JSON.parseObject(JSON.toJSONString(actFscOrderPO), DycActFscOrderInfo.class);
    }

    @Override
    public BasePageRspBo<DycActFscOrderInfo> selectByCondition(DycActFscOrderQryDO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        Page<ActFscOrderPO> page = PageHelper.startPage(reqBO.getPageNo(), reqBO.getPageSize()).doSelectPage(() -> this.actFscOrderMapper.selectByCondition(record));
        //封装集合
        List<DycActFscOrderInfo> fscOrderInfos = new ArrayList<>();
        for (ActFscOrderPO fscOrderPO : page.getResult()) {
            DycActFscOrderInfo dycActFscOrderInfo = new DycActFscOrderInfo();
            BeanUtils.copyProperties(fscOrderPO, dycActFscOrderInfo);
            fscOrderInfos.add(dycActFscOrderInfo);
        }
        BasePageRspBo<DycActFscOrderInfo> rspPage = new BasePageRspBo<>();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(fscOrderInfos);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int) page.getTotal());
        return rspPage;
    }

    @Override
    public List<DycActFscOrderFileInfo> selectFileListByIds(DycActFscOrderFileQryDO reqBO) {
        List<DycActFscOrderFileInfo> rspBO = new ArrayList<>();
        ActivityFileInfoPO record = new ActivityFileInfoPO();
        record.setOrderIds(reqBO.getFscOrderIds());
        record.setObjIds(reqBO.getObjIds());
        List<ActivityFileInfoPO> activityFileInfoPOS = activityFileInfoMapper.selectByCondition(record);
        if (!CollectionUtils.isEmpty(activityFileInfoPOS)){
            rspBO = JSON.parseArray(JSON.toJSONString(activityFileInfoPOS), DycActFscOrderFileInfo.class);
        }
        return rspBO;
    }

    @Override
    public int dealOrderState(DycActFscOrderDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        int i = actFscOrderMapper.update(record);
        return i;
    }

    @Override
    public int updateLogisticsInfo(DycActFscOrderLogisticsInfoDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        int i = actFscOrderMapper.update(record);
        return i;
    }

    @Override
    public DycActFscOrdSaveInfo saveFscOrder(DycActFscOrderSaveDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        BeanUtils.copyProperties(reqBO, record);
        record.setFscOrderId(Sequence.getInstance().nextId());
        record.setCreateCompanyId(reqBO.getCompanyId());
        record.setCreateCompanyName(reqBO.getCompanyName());
        record.setCreateOperName(reqBO.getName());
        record.setCreateUserId(reqBO.getUserId());
        record.setCreateOrgId(reqBO.getOrgId());
        record.setCreateOrgName(reqBO.getOrgName());
        record.setCreateOrgPath(reqBO.getOrgPath());
        record.setBuildAction(0);
        record.setPayeeId(reqBO.getSupplierId());
        record.setPayeeName(reqBO.getSupplierName());
        record.setPayerId(reqBO.getCompanyId());
        record.setPayerName(reqBO.getCompanyName());
        actFscOrderMapper.insert(record);
        DycActFscOrdSaveInfo dycActFscOrdSaveInfo = new DycActFscOrdSaveInfo();
        dycActFscOrdSaveInfo.setFscOrderId(record.getFscOrderId());
        return dycActFscOrdSaveInfo;
    }

    @Override
    public int getFscPushFailNum(DycActFscOrderDO reqBO) {
        ActFscOrderBatchInfoPO record = new ActFscOrderBatchInfoPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        return actFscOrderBatchInfoMapper.getFscPushFailNum(record);
    }

    @Override
    public List<Long> qryAlertFscOrderList(DycActDealAlertQryOrderDO reqBO) {
        //查询待预警数据之前先把有预警标识的数据清空
        ActFscOrderPO updatePo = new ActFscOrderPO();
        updatePo.setAlertType(Integer.parseInt(reqBO.getAlertFlag()));
        actFscOrderMapper.clearAlertType(updatePo);

        //将已存在的预警历史记录表的数据改为待处理（中间状态）
        ActAlertInfoPO actAlertInfoPO = new ActAlertInfoPO();
        actAlertInfoPO.setAlertType(Integer.parseInt(reqBO.getAlertFlag()));
        actAlertInfoPO.setAlertState(DycActivityConstants.AlertState.DEALING);
        actAlertInfoPO.setOldAlertState(DycActivityConstants.AlertState.UN_DEAL);
        actAlertInfoMapper.updateAlertState(actAlertInfoPO);

        ActFscOrderPO record = new ActFscOrderPO();
        if (reqBO.getFscOrderId() != null){
            record.setFscOrderId(reqBO.getFscOrderId());
        }
        if (!CollectionUtils.isEmpty(reqBO.getFscOrderIds())){
            record.setFscOrderIds(reqBO.getFscOrderIds());
        }
        record.setDayNum(reqBO.getDayNum());
        if (DycActivityConstants.AlertType.UN_SIGN.equals(Integer.parseInt(reqBO.getAlertFlag()))) {
            return actFscOrderMapper.getUnSignFscOrder(record);
        } else if (DycActivityConstants.AlertType.UN_PAY.equals(Integer.parseInt(reqBO.getAlertFlag()))){
            return actFscOrderMapper.getUnPayFscOrder(record);
        }
        return null;
    }

    @Override
    public void updateOrderAlertType(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        ActFscOrderPO record = new ActFscOrderPO();
        record.setFscOrderId(Long.parseLong(dycActDealOrderAlertDO.getOrderId()));
        record.setAlertType(dycActDealOrderAlertDO.getAlertType());
        actFscOrderMapper.update(record);
    }

    @Override
    public void updateFscOrderAlertType(DycActFscOrderDO reqBO) {
        ActFscOrderPO record = new ActFscOrderPO();
        record.setFscOrderId(reqBO.getFscOrderId());
        record.setAlertType(reqBO.getAlertType());
        actFscOrderMapper.updateAlertType(record);
    }

    /**
     * 获取预警结算单
     * @param qryDO
     * @return
     */
    @Override
    public List<DycActFscOrderDO> getFscOrderWarning(DycActFscOrderQryDO qryDO) {
        ActFscOrderQryPO actFscOrderQryPO = ActRu.js(qryDO, ActFscOrderQryPO.class);
        List<ActFscOrderPO> fscOrderWarning = actFscOrderMapper.getFscOrderWarning(actFscOrderQryPO);
        return ActRu.jsl(fscOrderWarning,DycActFscOrderDO.class);
    }

    @Override
    public List<DycActFscOrderInfo> queryFscOrderList(DycActFscOrderQryDO qryDo) {
        ActFscOrderPO actFscOrderPo = ActRu.js(qryDo, ActFscOrderPO.class);
        List<ActFscOrderPO> actFscOrderPos = actFscOrderMapper.selectByCondition(actFscOrderPo);
        return ActRu.jsl(actFscOrderPos, DycActFscOrderInfo.class);
    }

    @Override
    public List<ActFscOrderBatchInfo> qryBatchInfoList(ActBatchInfoQryDO qryDO) {
        ActFscOrderBatchInfoPO record = new ActFscOrderBatchInfoPO();
        record.setFscOrderId(qryDO.getFscOrderId());
        record.setBatchId(qryDO.getBatchId());
        record.setPushResult(qryDO.getPushResult());
        List<ActFscOrderBatchInfoPO> actFscOrderBatchInfoPOS = actFscOrderBatchInfoMapper.selectByCondition(record);
        return JUtil.jsl(actFscOrderBatchInfoPOS, ActFscOrderBatchInfo.class);
    }

    @Override
    public List<String> qryBatchOrderIds(ActBatchInfoQryDO qryDO) {
        ActFscOrderRelationPO record = new ActFscOrderRelationPO();
        record.setFscOrderId(qryDO.getFscOrderId());
        record.setBatchId(qryDO.getBatchId());
        List<ActFscOrderRelationPO> actFscOrderRelationPOS = actFscOrderRelationMapper.selectByCondition(record);
        return actFscOrderRelationPOS.stream().map(o->o.getOrderId().toString()).collect(Collectors.toList());
    }
}
